/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.dbsession;

import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DbSessionBase
implements DbSession {
    private static final ThreadLocal tl = new ThreadLocal();
    private String id;
    private String realUser;
    private String cartOwnerSchema;
    private UserInfo userInfo;

    protected DbSessionBase() {
    }

    protected DbSessionBase(String withJccOwner) {
        this.cartOwnerSchema = withJccOwner == null ? null : withJccOwner.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRealUser() throws SQLException {
        if (this.realUser == null) {
            String sql = "select user from dual";
            ResultSet rs = null;
            Statement stmt = this.getConnection().createStatement();
            try {
                rs = stmt.executeQuery(sql);
                rs.next();
                this.realUser = rs.getString(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                stmt.close();
            }
        }
        return this.realUser;
    }

    @Override
    public void close(ResultSet rs, PreparedStatement ps) throws SQLException {
        if (ps == null) {
            return;
        }
        ps.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOracleSessionId() throws SQLException {
        if (this.id == null) {
            String sql = "SELECT userenv('SESSIONID') FROM dual";
            PreparedStatement ps = this.prepareStatement(sql);
            try {
                ResultSet rs = ps.executeQuery();
                rs.next();
                this.id = rs.getString(1);
            }
            finally {
                ps.close();
            }
            Object var2_2 = null;
        }
        return this.id;
    }

    @Override
    public String getJccOwner() {
        if (this.cartOwnerSchema == null) {
            String sql = "select jchem_core_pkg.get_cartowner_schema() from dual";
            try {
                PreparedStatement ps = this.prepareStatement(sql);
                ResultSet rs = ps.executeQuery(sql);
                rs.next();
                this.cartOwnerSchema = rs.getString(1);
                ps.close();
                ps = null;
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
                try {
                    String[] identities = DbSessionBase.getUserIdentities(this.getConnection());
                    System.err.println("[" + identities[0] + ":" + identities[1] + "]: Failing sql: " + sql);
                    JavaStoredProcSession.printRoleAttributes(this.getConnection());
                    throw sqlException;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.cartOwnerSchema;
    }

    @Override
    public Connection getConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String stmt) throws SQLException {
        return this.getConnection().prepareStatement(stmt);
    }

    @Override
    public PreparedStatement prepareStatementNoCache(String stmt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(String stmt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getJccSessionId() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getImpersonatedUser() throws SQLException {
        return this.getConnection().getMetaData().getUserName();
    }

    public static void setCurrent(DbSession dbSession) {
        tl.set(dbSession);
    }

    public static DbSession getCurrent() {
        DbSession session = (DbSession)tl.get();
        if (session == null) {
            return JavaStoredProcSession.instance();
        }
        return session;
    }

    @Override
    public UserInfo getUserInfo() throws SQLException {
        if (this.userInfo == null) {
            return new UserInfo(this.getRealUser(), null);
        }
        return this.userInfo;
    }

    @Override
    public SessionInfo getSessionInfo() throws SQLException {
        UserInfo userInfo = this.getUserInfo();
        return new SessionInfo(this.getOracleSessionId(), userInfo.getUserName(), userInfo.getPassword());
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] getUserIdentities(Connection conn) throws SQLException {
        String realUser;
        String sql = "select user from dual";
        ResultSet rs = null;
        PreparedStatement ps = conn.prepareStatement(sql);
        try {
            rs = ps.executeQuery();
            rs.next();
            realUser = rs.getString(1);
        }
        finally {
            ps.close();
        }
        String impersonatedUser = conn.getMetaData().getUserName();
        return new String[]{realUser, impersonatedUser};
    }
}

