/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.dbsession;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSessionBase;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import sqlj.runtime.RuntimeContext;

public class JavaStoredProcSession
extends DbSessionBase {
    public static final int DEFAULT_STMT_CACHE_SIZE = 200;
    public static final boolean debug = false;
    public static final boolean debugRoles = false;
    public static final int debugLevel = 1;
    private static final JCartLogger logger = JCartLogger.getLogger(JavaStoredProcSession.class);
    private static JavaStoredProcSession instance;
    private String jccSessionId;
    private Map stmtMap;
    private Map timeStampMap;
    private Connection conn;
    private String password;
    private boolean caching = false;

    public JavaStoredProcSession(int cacheSize, String jccOwner) {
        super(jccOwner);
        if (logger.isDebugEnabled()) {
            JFunctions.traceKarg("JavaStoredProcSession(" + cacheSize + ", " + jccOwner + ")");
        }
        this.stmtMap = new HashMap(cacheSize);
        this.stmtMap.values().toArray();
        this.timeStampMap = new HashMap(cacheSize);
        this.conn = RuntimeContext.getRuntime().getDefaultConnection();
        if (this.conn == null) {
            throw new IllegalArgumentException("Oracle runtime returned null for default connection!!!!!!!!!!!!");
        }
        OracleConnection oconn = (OracleConnection)this.conn;
        try {
            oconn.setImplicitCachingEnabled(false);
            oconn.setExplicitCachingEnabled(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (logger.isDebugEnabled()) {
            JFunctions.traceKarg("JavaStoredProcSession(...) completing...");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void close(ResultSet rs, PreparedStatement ps) throws SQLException {
        if (!this.caching && ps != null) {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printRoleAttributes(Connection conn) throws SQLException {
        ResultSet rs;
        String sql = "select user from dual";
        Statement stmt = conn.createStatement();
        try {
            rs = stmt.executeQuery(sql);
            rs.next();
            System.err.println("user=" + rs.getString(1));
        }
        finally {
            stmt.close();
        }
        sql = "select role, owner, table_name, privilege from role_tab_privs where table_name = 'JCHEM_CORE_PKG'";
        stmt = conn.createStatement();
        try {
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                System.err.println("No privilege on any JCHEM_CORE_PKG");
            } else {
                String role = rs.getString("role");
                String owner = rs.getString("owner");
                String tableName = rs.getString("table_name");
                String privilege = rs.getString("privilege");
                System.err.println("role=" + role + ", owner=" + owner + ", table_name=" + tableName + ", privilege=" + privilege);
            }
        }
        finally {
            stmt.close();
        }
        sql = "select owner, synonym_name, table_owner, table_name from all_synonyms where upper(synonym_name) = 'JCHEM_CORE_PKG'";
        stmt = conn.createStatement();
        try {
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                System.err.println("No synonym for any JCHEM_CORE_PKG");
            } else {
                String owner = rs.getString("owner");
                String synName = rs.getString("synonym_name");
                String tableOwner = rs.getString("table_owner");
                String tableName = rs.getString("table_name");
                System.err.println("owner=" + owner + ", synonym_name=" + synName + ", table_owner=" + tableOwner + ", table_name=" + tableName);
            }
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.caching) {
            return this.cacheStatement(sql);
        }
        return this.conn.prepareStatement(sql);
    }

    private PreparedStatement cacheStatement(String stmt) throws SQLException {
        PreparedStatement ps = (PreparedStatement)this.stmtMap.get(stmt);
        if (ps != null) {
            this.timeStampMap.put(stmt, new Long(System.currentTimeMillis()));
            return ps;
        }
        if (this.stmtMap.size() >= 100) {
            this.removeLRU();
        }
        try {
            return this.newPreparedStatement(stmt);
        }
        catch (SQLException sqlE) {
            int errCode = sqlE.getErrorCode();
            if (errCode == 1000) {
                throw new RuntimeException("Please, set the values of the initialization parameter 'open_cursors' to at least 250.");
            }
            throw sqlE;
        }
    }

    private PreparedStatement newPreparedStatement(String stmt) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(stmt);
        this.stmtMap.put(stmt, ps);
        this.timeStampMap.put(stmt, new Long(System.currentTimeMillis()));
        return ps;
    }

    private void removeLRU() throws SQLException {
        String lruStmt = "";
        long lruStmtTime = Long.MAX_VALUE;
        Object stringBuffer = null;
        for (String stmt : this.timeStampMap.keySet()) {
            long time = (Long)this.timeStampMap.get(stmt);
            if (time >= lruStmtTime) continue;
            lruStmtTime = time;
            lruStmt = stmt;
        }
        this.timeStampMap.remove(lruStmt);
        PreparedStatement ps = (PreparedStatement)this.stmtMap.remove(lruStmt);
        if (ps == null) {
            throw new IllegalArgumentException("Statement not cached: " + lruStmt);
        }
        ps.close();
    }

    @Override
    public PreparedStatement prepareStatementNoCache(String stmt) throws SQLException {
        return this.conn.prepareStatement(stmt);
    }

    @Override
    public void invalidate(String stmt) {
        if (this.caching) {
            this.timeStampMap.remove(stmt);
            PreparedStatement ps = (PreparedStatement)this.stmtMap.remove(stmt);
            try {
                ps.close();
            }
            catch (Throwable tbl) {
                tbl.printStackTrace();
            }
        }
    }

    @Override
    public String getJccSessionId() throws SQLException {
        if (this.jccSessionId == null) {
            String sql = "SELECT " + this.getJccOwner() + ".jchem_sessionid_sq.nextval FROM dual";
            Statement stmt = this.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            this.jccSessionId = this.getOracleSessionId() + "_" + String.valueOf(rs.getInt(1));
        }
        return this.jccSessionId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCaching(boolean b) {
        if (!b) {
            SQLException firstError = null;
            Iterator i = this.stmtMap.values().iterator();
            while (i.hasNext()) {
                PreparedStatement pstmt = (PreparedStatement)i.next();
                try {
                    pstmt.close();
                    i.remove();
                }
                catch (SQLException sqlException) {
                    if (firstError != null) continue;
                    firstError = sqlException;
                }
            }
            this.timeStampMap.clear();
        }
        this.caching = b;
    }

    @Override
    public SessionInfo getSessionInfo() throws SQLException {
        UserInfo userInfo = this.getUserInfo();
        return new SessionInfo(this.getJccSessionId(), userInfo.getUserName(), userInfo.getPassword());
    }

    public static void cacheStatements(int b) {
        JavaStoredProcSession.instance().setCaching(b != 0);
    }

    public static int getCachedStmtCount() {
        return JavaStoredProcSession.instance().stmtMap.size();
    }

    public static JavaStoredProcSession instance() {
        return JavaStoredProcSession.instance(null);
    }

    public static JavaStoredProcSession instance(String jccOwner) {
        if (instance == null) {
            instance = new JavaStoredProcSession(200, jccOwner);
            instance.getJccOwner();
        }
        return instance;
    }

    public static String jccSessionId() throws SQLException {
        return JavaStoredProcSession.instance().getJccSessionId();
    }

    public static Connection getJspConnectionReflect() {
        try {
            Class<?> c = Class.forName("sqlj.runtime.RuntimeContext");
            Object runtime = c.getMethod("getRuntime", null).invoke(null, (Object[])null);
            return (Connection)c.getMethod("getDefaultConnection", null).invoke(runtime, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

