/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.dml;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dml.CacheRegistrationSnapshot;
import chemaxon.jchem.cartridge.rmi.Admin;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.util.JCartLogger;
import chemaxon.jchem.db.CacheRegistrationBase;
import chemaxon.jchem.db.CacheRegistrationInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class CacheRegistrationCache {
    private static final JCartLogger logger = JCartLogger.getLogger(CacheRegistrationCache.class);
    private CacheRegistrationBase cacheRegistrationUtil;
    private String jchemPropertiesTableName;
    private CacheRegistrationSnapshot snapshot;
    private String timeStamp;

    public CacheRegistrationCache(DbSession dbSession, String jchemPropertiesTableName) throws Exception {
        this.jchemPropertiesTableName = jchemPropertiesTableName;
        this.cacheRegistrationUtil = new CacheRegistrationBase(dbSession.getConnection(), jchemPropertiesTableName);
        this.checkMyCacheIdIsRegistrered(dbSession);
    }

    private void checkMyCacheIdIsRegistrered(DbSession dbSession) throws SQLException, Exception {
        StringBuffer notFoundList = new StringBuffer();
        Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
        String[] cacheIds = admin.getAllJccCacheIds(dbSession.getUserInfo(), dbSession.getJccOwner());
        if (cacheIds == null) {
            throw new IllegalStateException("No cache id registered internally to JChem Cartridge. (Failed upgrade?)");
        }
        CacheRegistrationInfo[] infos = this.cacheRegistrationUtil.getCacheRegistrationInfos();
        for (int ix = 0; ix < cacheIds.length; ++ix) {
            String cacheId = cacheIds[ix];
            boolean found = false;
            for (int i = 0; i < infos.length; ++i) {
                CacheRegistrationInfo cacheRegistrationInfo = infos[i];
                if (!cacheRegistrationInfo.getCacheId().equals(cacheId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (notFoundList.length() > 0) {
                notFoundList.append(", ");
            }
            notFoundList.append(cacheId);
        }
        if (notFoundList.length() > 0) {
            throw new IllegalStateException("The following cache ids are not registered for " + this.jchemPropertiesTableName + ": " + notFoundList.toString());
        }
    }

    public CacheRegistrationSnapshot getCacheRegistrationSnapshot() throws Exception {
        if (this.cacheIsDirty(this.cacheRegistrationUtil)) {
            CacheRegistrationInfo[] infos = this.cacheRegistrationUtil.getCacheRegistrationInfos();
            String[] onLineCaches = new String[infos.length];
            ArrayList newlyRegisteredCaches = this.processNewInfos(this.jchemPropertiesTableName, infos, onLineCaches);
            this.snapshot = new CacheRegistrationSnapshot(onLineCaches, newlyRegisteredCaches);
        } else if (this.snapshot.getNewlyRegisteredCaches().size() > 0) {
            this.snapshot.getNewlyRegisteredCaches().clear();
            this.snapshot.getNewlyRegisteredCaches().trimToSize();
        }
        return this.snapshot;
    }

    private boolean cacheIsDirty(CacheRegistrationBase cacheRegistrationUtil) throws Exception {
        boolean dirty = false;
        String vTimeStamp = JcMetaDataFunctions.getJspInstance().getProperty(this.jchemPropertiesTableName, "cache.validity_timestamp");
        if (this.timeStamp == null || !this.timeStamp.equals(vTimeStamp)) {
            dirty = true;
            this.timeStamp = vTimeStamp;
        }
        return dirty;
    }

    private ArrayList processNewInfos(String jchemPropertiesTableName, CacheRegistrationInfo[] infos, String[] onLineCaches) {
        ArrayList<String> newCacheList = new ArrayList<String>();
        for (int ix = 0; ix < infos.length; ++ix) {
            String cacheId;
            CacheRegistrationInfo info = infos[ix];
            onLineCaches[ix] = cacheId = info.getCacheId();
            if (!this.isNewCache(cacheId)) continue;
            newCacheList.add(cacheId);
        }
        if (newCacheList.size() > 0 && logger.isInfoEnabled()) {
            logger.info("The following structure caches have recently come on line: " + newCacheList);
        }
        return newCacheList;
    }

    private boolean isNewCache(String cacheId) {
        boolean isNew = true;
        if (this.snapshot == null) {
            isNew = false;
        } else {
            String[] prevCaches = this.snapshot.onLineCaches();
            for (int i = 0; i < prevCaches.length; ++i) {
                if (!cacheId.equals(prevCaches[i])) continue;
                isNew = false;
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("isNewCache: snapshot=" + this.snapshot + ", previous onLineCaches=" + (this.snapshot == null ? "none" : Arrays.asList(this.snapshot.onLineCaches()).toString()) + ", cacheId=" + cacheId);
        }
        return isNew;
    }
}

