/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.version.VersionInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.logging.Logger;

public class ChUrl {
    static Logger logger = Logger.getLogger(ChUrl.class.getName());
    public static final String INSTALL_SCHEMA_PLACE_HOLDER = "&1";
    public static final String JCHEM_VERSION_PLACE_HOLDER = "&2";
    public static final String TABLE_VERSION_PLACE_HOLDER = "&3";

    public static void prepareSqlScript(String schemaName, File inputFile, File outputFile) throws Exception {
        String eol = "\n";
        if (File.separatorChar == '\\') {
            eol = "\r\n";
        }
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        String line = in.readLine();
        while (line != null) {
            line = ChUrl.convertPlaceHolder(line, INSTALL_SCHEMA_PLACE_HOLDER, "return '" + schemaName + "';");
            line = ChUrl.convertPlaceHolder(line, JCHEM_VERSION_PLACE_HOLDER, "return '" + VersionInfo.JCHEM_VERSION + "';");
            line = ChUrl.convertPlaceHolder(line, TABLE_VERSION_PLACE_HOLDER, "return " + VersionInfo.JCHEM_TABLE_VERSION + ";");
            out.write(line);
            out.write(eol);
            line = in.readLine();
        }
        in.close();
        out.close();
    }

    private static String convertPlaceHolder(String lineIn, String placeHolder, String lineOut) {
        int idx = lineIn.indexOf(placeHolder);
        if (idx != -1) {
            return lineOut;
        }
        return lineIn;
    }
}

