/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.install.JccConfigUtilCmdLine;
import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexUserConfig {
    private static final Logger logger = Logger.getLogger(IndexUserConfig.class.getName());
    private JccConfigUtilCmdLine cmdLine = new JccConfigUtilCmdLine();
    private InstallParameters iparams = new InstallParameters();
    private ConfigurationParameter idxOwner = ConfigurationParameter.create("idx.owner", "The owner of the index", "The owner of the index", null, null);
    private ConfigurationParameter idxOwnerPassword = ConfigurationParameter.create("idx.owner.password", true, "The password of the index owner", "The password of the index owner", null, null);
    private ConfigurationParameter idxUser = ConfigurationParameter.create("idx.user", "The user of the index", "The user of the index", null, null);
    private String idxName;
    private Map<String, List<String>> sqlMap = new HashMap<String, List<String>>();

    public IndexUserConfig() throws Exception {
        ConfigurationParameter[] params;
        for (ConfigurationParameter p : params = new ConfigurationParameter[]{this.iparams.oracleHost, this.iparams.oracleListenerPort, this.iparams.oracleInstanceName, this.iparams.jccOwnerLogin, this.iparams.jccOwnerPassword, this.iparams.basicJccRole, this.idxOwner, this.idxOwnerPassword, this.idxUser}) {
            this.cmdLine.promptForInput(p);
        }
        this.getIdxName();
    }

    private void grantDirectPrivilegesToIndexOwner() throws IOException, NumberFormatException, ClassNotFoundException, SQLException {
        String sql = "call privman_pkg.grants_on_jcobjs('" + this.iparams.jccOwnerLogin.getUserInput() + "', '" + this.idxOwner.getUserInput() + "')";
        this.addToMap(this.iparams.jccOwnerLogin.getUserInput(), sql);
    }

    private void grantBasicJccRoleToIndexUser() throws SQLException, NumberFormatException, ClassNotFoundException {
        String sql = "grant " + this.iparams.basicJccRole.getUserInput() + " to " + this.idxUser.getUserInput();
        this.addToMap(this.iparams.jccOwnerLogin.getUserInput(), sql);
    }

    private void grantIdxPrivilegeToIndexUser() throws SQLException, NumberFormatException, ClassNotFoundException, IOException {
        String privFlags = this.getPrivFlags();
        String sql = "call " + this.iparams.jccOwnerLogin.getUserInput() + ".privman_pkg.grants_on_jcidx('" + this.idxUser.getUserInput() + "', '" + this.idxOwner.getUserInput() + "', '" + this.idxName + "', " + privFlags + ")";
        this.addToMap(this.idxOwner.getUserInput(), sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIdxName() throws IOException, SQLException, NumberFormatException, ClassNotFoundException {
        Connection conn = JccConfigUtilCmdLine.createConnection(this.iparams, this.idxOwner.getUserInput(), this.idxOwnerPassword.getUserInput());
        try {
            List<String> jccIndices = this.getUserJccIndices(conn);
            ConfigurationParameter idxNameParam = ConfigurationParameter.create("idx.name", "The name of the index", "The name of the index", jccIndices, jccIndices.get(0));
            this.cmdLine.promptForInput(idxNameParam);
            this.idxName = idxNameParam.getUserInput();
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserJccIndices(Connection conn) throws SQLException {
        ArrayList<String> l = new ArrayList<String>();
        String sql = "select index_name from user_indexes where ityp_name = 'JC_IDXTYPE'";
        Statement stmt = conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                l.add(rs.getString(1));
            }
        }
        finally {
            stmt.close();
        }
        if (l.size() == 0) {
            throw new IllegalArgumentException(this.idxOwner.getUserInput() + " has no JChem index");
        }
        return l;
    }

    private String getPrivFlags() throws IOException {
        String[] privTypes;
        StringBuilder sb = new StringBuilder();
        for (String p : privTypes = new String[]{"search", "insert", "update", "delete"}) {
            boolean give = this.cmdLine.promptForYesNo("Give " + p + " permission to " + this.idxUser.getUserInput() + " on " + this.idxName, false);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(give ? "1" : "0");
        }
        return sb.toString();
    }

    private void addToMap(String login, String sql) {
        List<String> l = this.sqlMap.get(login);
        if (l == null) {
            l = new ArrayList<String>();
            this.sqlMap.put(login, l);
        }
        l.add(sql);
    }

    private void listSqls() {
        String[] logins = this.getLoginsToExecuteWith();
        for (int idx = 0; idx < logins.length; ++idx) {
            List<String> sqls = this.sqlMap.get(logins[idx]);
            System.out.println("-- ---- SQLs to execute as " + logins[idx] + ":");
            for (String sql : sqls) {
                System.out.println(sql);
            }
        }
    }

    private boolean executeSqls() throws NumberFormatException, ClassNotFoundException, SQLException, IOException {
        ConfigurationParameter wantToExec = ConfigurationParameter.createYesNo("Do you want to execute the SQL statements", true);
        if (this.cmdLine.promptForYesNo(wantToExec)) {
            String[] logins = this.getLoginsToExecuteWith();
            String[] passwords = this.getPasswordsToExecuteWith();
            for (int idx = 0; idx < logins.length; ++idx) {
                this.executeAs(logins[idx], passwords[idx]);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAs(String login, String password) throws NumberFormatException, ClassNotFoundException, SQLException {
        List<String> sqls = this.sqlMap.get(login);
        Connection conn = JccConfigUtilCmdLine.createConnection(this.iparams, login, password);
        try {
            String sql = null;
            Statement stmt = conn.createStatement();
            try {
                Iterator<String> i$ = sqls.iterator();
                while (i$.hasNext()) {
                    String s;
                    sql = s = i$.next();
                    stmt.execute(sql);
                }
            }
            catch (SQLException sqlException) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Error while executing `" + sql + "` as " + login);
                }
                throw sqlException;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
    }

    private String[] getLoginsToExecuteWith() {
        return new String[]{this.iparams.jccOwnerLogin.getUserInput(), this.idxOwner.getUserInput()};
    }

    private String[] getPasswordsToExecuteWith() {
        return new String[]{this.iparams.jccOwnerPassword.getUserInput(), this.idxOwnerPassword.getUserInput()};
    }

    private void test() throws Exception {
        String[] testSqls = this.getTestSqls();
        System.out.println("");
        System.out.println("The following SQL statements will be used to test the new configuration:");
        for (String sql : testSqls) {
            System.out.println(sql);
        }
        if (this.cmdLine.promptForYesNo("Do you want to execute the test? (The password of the newly configured index user will be required.)", true)) {
            ConfigurationParameter p = ConfigurationParameter.create("idxUser.pwd", true, "Password of the newly configured index user", "Password of the newly configured index user", null, null);
            JccConfigUtilCmdLine.promptForPassword(p);
            this.execTest(p.getUserInput(), testSqls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTest(String idxUserPassword, String[] testSqls) throws SQLException, NumberFormatException, ClassNotFoundException {
        Connection conn = JccConfigUtilCmdLine.createConnection(this.iparams, this.idxUser.getUserInput(), idxUserPassword);
        try {
            this.setJccOwnerSchema(conn);
            String pwdSql = testSqls[0];
            PreparedStatement pstmt = conn.prepareStatement(pwdSql);
            try {
                pstmt.setString(1, idxUserPassword);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
            Statement stmt = conn.createStatement();
            try {
                for (int ix = 1; ix < testSqls.length; ++ix) {
                    String sql = testSqls[ix];
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        rs.getInt(1);
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJccOwnerSchema(Connection conn) throws SQLException {
        String jccOwner = this.iparams.jccOwnerLogin.getUserInput();
        Statement stmt = conn.createStatement();
        try {
            String sql = "call " + jccOwner + ".jchem_core_pkg.set_jccowner_schema('" + jccOwner + "')";
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTestSqls() throws Exception {
        Connection conn = JccConfigUtilCmdLine.createConnection(this.iparams, this.idxOwner.getUserInput(), this.idxOwnerPassword.getUserInput());
        try {
            String jccOwner = this.iparams.jccOwnerLogin.getUserInput();
            ClientSideSession dbSession = new ClientSideSession(conn, jccOwner);
            String idxQName = this.idxOwner.getUserInput().toUpperCase() + "." + this.idxName.toUpperCase();
            JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get((DbSession)dbSession, idxQName);
            String searchSql = "select count(*) from " + idxDesc.getBaseTableSchema() + "." + idxDesc.getBaseTableName() + " where " + jccOwner + ".jc_compare(" + idxDesc.getColName() + ", 'CN1CC[C@@]23[C@H]4OC5=C2C(C[C@@H]1[C@@H]3C=C[C@@H]4O)=CC=C5O', 't:s') = 1";
            String[] stringArray = new String[]{"call " + jccOwner + ".jchem_core_pkg.use_password(?)", searchSql};
            return stringArray;
        }
        finally {
            conn.close();
        }
    }

    public static void main(String[] args) {
        try {
            IndexUserConfig iuc = new IndexUserConfig();
            iuc.grantDirectPrivilegesToIndexOwner();
            iuc.grantBasicJccRoleToIndexUser();
            iuc.grantIdxPrivilegeToIndexUser();
            System.out.println("");
            iuc.listSqls();
            if (iuc.executeSqls()) {
                System.out.println("");
                System.out.println("Configuration done");
                System.out.println("");
                iuc.test();
                System.out.println("");
                System.out.println("Test successful");
            }
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
            System.exit(1);
        }
    }
}

