/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.ConnectUtil;
import chemaxon.jchem.cartridge.install.IndexUserConfig;
import chemaxon.jchem.cartridge.install.InstallCmdLine;
import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.install.params.UpgradeParameters;
import chemaxon.util.MaskingCmdLinePasswdReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JccConfigUtilCmdLine {
    private static final Logger logger = Logger.getLogger(JccConfigUtilCmdLine.class.getName());
    private List<ConfigurationParameter> allUserInput = new ArrayList<ConfigurationParameter>();

    private void printPrivilegesRequiredForStagingSchema() throws Exception {
        UpgradeParameters up = new UpgradeParameters();
        up.stagingSchema.setUserInput(null);
        this.promptForInput(up.stagingSchema);
        ArrayList<String> sqlList = new ArrayList<String>();
        String[] privs = InstallParameters.JCHEM_OWNER_PRIVILEGES;
        for (int ix = 0; ix < privs.length; ++ix) {
            String priv = privs[ix];
            sqlList.add("grant " + priv + " to " + InstallUtil.trimSYSLogin(up.stagingSchema.getUserInput()));
        }
        this.printSqlList(sqlList);
    }

    private void printPrivilegesRequiredForJccOwner(String[] args) throws Exception {
        ConfigurationParameter[] params;
        InstallParameters iparams = new InstallParameters();
        JccConfigUtilCmdLine.parseCmdLine(args, iparams);
        for (ConfigurationParameter p : params = new ConfigurationParameter[]{iparams.jccOwnerLogin, iparams.jchemServerHost, iparams.jchemServerPort}) {
            if (p.hasUserInput()) continue;
            this.promptForInput(p);
        }
        if (iparams.databaseVersion == null) {
            this.promptForDbVersion(iparams);
        }
        List<String> sqlList = iparams.stmtsToSetupJccOwnerPrivilegesAsDba();
        this.printSqlList(sqlList);
    }

    private void printPrivilegesRequiredForJccUser(String[] args) throws Exception {
        ConfigurationParameter[] params;
        InstallParameters iparams = new InstallParameters();
        JccConfigUtilCmdLine.parseCmdLine(args, iparams);
        String userToConfigure = JccConfigUtilCmdLine.parseUserToConfigre(args);
        for (ConfigurationParameter p : params = new ConfigurationParameter[]{iparams.jccOwnerLogin, iparams.jchemServerHost, iparams.jchemServerPort}) {
            if (p.hasUserInput()) continue;
            this.promptForInput(p);
        }
        if (iparams.databaseVersion == null) {
            this.promptForDbVersion(iparams);
        }
        if (userToConfigure == null) {
            userToConfigure = this.promptForUserToConfigure(iparams);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("-- To be executed as DBA:");
        sqlList.addAll(InstallUtil.getJavaPermGrantStmts(userToConfigure, iparams.jchemServerHost.getUserInput(), iparams.jchemServerPort.getUserInput(), iparams.databaseVersion));
        sqlList.add("");
        sqlList.add("-- To be executed as " + iparams.jccOwnerLogin.getUserInput() + ":");
        sqlList.addAll(iparams.stmtsToConfigureBasicJccRoleAsJccOwner(userToConfigure));
        this.printSqlList(sqlList);
    }

    private void listDbaSqls(String[] args) throws Exception {
        ConfigurationParameter[] params;
        InstallParameters iparams = new InstallParameters();
        JccConfigUtilCmdLine.parseCmdLine(args, iparams);
        for (ConfigurationParameter p : params = new ConfigurationParameter[]{iparams.jccOwnerLogin, iparams.jchemServerHost, iparams.jchemServerPort, iparams.basicJccRole}) {
            if (p.hasUserInput()) continue;
            this.promptForInput(p);
        }
        String userToConfigure = iparams.basicJccRole.getUserInput();
        if (iparams.databaseVersion == null) {
            this.promptForDbVersion(iparams);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("");
        sqlList.add("-- --------------------------------------------------------------------");
        sqlList.add("-- Before installation:");
        sqlList.add("-- --------------------------------------------------------------------");
        sqlList.add("");
        sqlList.add("-- -------------------------- JChem Owner -----------------------------");
        sqlList.add("create user " + iparams.jccOwnerLogin.getUserInput() + " identified by <password>");
        sqlList.add("--   For simplicity, UNLIMITED TABLESPACE is granted by default, but 100MB should be enough");
        sqlList.add("--   on the tablespace which is made the JChem owner's default tablespace");
        sqlList.addAll(iparams.stmtsToSetupJccOwnerPrivilegesAsDba());
        sqlList.add("");
        sqlList.add("-- -------------- Basic JChem Cartridge user role ---------------------");
        sqlList.add("create role " + userToConfigure);
        sqlList.addAll(InstallUtil.getJavaPermGrantStmts(userToConfigure, iparams.jchemServerHost.getUserInput(), iparams.jchemServerPort.getUserInput(), iparams.databaseVersion));
        sqlList.add("grant " + userToConfigure + " to " + iparams.jccOwnerLogin.getUserInput() + " with admin option");
        sqlList.add("");
        sqlList.add("-- --------------------------------------------------------------------");
        sqlList.add("-- After installation:");
        sqlList.add("-- --------------------------------------------------------------------");
        sqlList.add("call " + iparams.jccOwnerLogin.getUserInput() + ".privman_pkg.public_syns_for_jcobjs('" + iparams.jccOwnerLogin.getUserInput() + "')");
        this.printSqlList(sqlList, false);
    }

    public static void parseCmdLine(String[] args, InstallParameters iparams) {
        for (int ix = 0; ix < args.length; ++ix) {
            if (args[ix].equals("--jcc-owner")) {
                iparams.jccOwnerLogin.setUserInput(args[++ix]);
                continue;
            }
            if (args[ix].equals("--jchem-server-host")) {
                iparams.jchemServerHost.setUserInput(args[++ix]);
                continue;
            }
            if (args[ix].equals("--jchem-server-port")) {
                iparams.jchemServerPort.setUserInput(args[++ix]);
                continue;
            }
            if (!args[ix].equals("--oracle-version")) continue;
            iparams.databaseVersion = InstallParameters.parseDbVersion(args[++ix]);
        }
    }

    public static String parseUserToConfigre(String[] args) {
        for (int ix = 0; ix < args.length; ++ix) {
            if (!args[ix].equals("--user-to-configure")) continue;
            return args[++ix];
        }
        return null;
    }

    private void printSqlList(List<String> sqlList) {
        this.printSqlList(sqlList, true);
    }

    private void printSqlList(List<String> sqlList, boolean withCutLine) {
        System.err.println("");
        if (withCutLine) {
            System.err.println("-------------------------- CUT HERE ----------------------------");
        }
        for (String cmd : sqlList) {
            System.err.println(cmd + (cmd.length() == 0 || cmd.startsWith("--") ? "" : ";"));
        }
        if (withCutLine) {
            System.err.println("-------------------------- CUT HERE ----------------------------");
        }
        System.err.println("");
    }

    public boolean promptForYesNo(ConfigurationParameter pp) throws IOException {
        this.promptForInput(pp);
        return pp.getUserInput().equals("y");
    }

    public boolean promptForYesNo(String message, boolean def) throws IOException {
        ConfigurationParameter pp = ConfigurationParameter.createYesNo(message, def);
        return this.promptForYesNo(pp);
    }

    public static String readStdIn() throws IOException {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        return stdin.readLine();
    }

    private String promptForUserToConfigure(InstallParameters iparams) throws IOException {
        ConfigurationParameter jccUser = ConfigurationParameter.create("jcc.user", "The Oracle user to be configured for using JChem Cartridge installed in " + iparams.jccOwnerLogin.getUserInput(), "The target Oracle user", null, "zazie");
        while (!jccUser.hasUserInput()) {
            try {
                this.promptForInput(jccUser);
                return jccUser.getUserInput();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new RuntimeException("No user to configure");
    }

    public static void promptForPassword(ConfigurationParameter password) throws IOException {
        String pwd = null;
        String prompt = password.getPromptMessage();
        while (pwd == null) {
            char[] pw = MaskingCmdLinePasswdReader.getPassword(System.in, prompt + ": ");
            if (pw != null) {
                pwd = new String(pw);
                break;
            }
            InstallCmdLine.warn("Password is required!");
        }
        password.setUserInput(pwd);
    }

    public static String checkValue(ConfigurationParameter pp, String v) {
        if (v.equals("?")) {
            return pp.getDescription();
        }
        List<String> allowedValues = pp.getAllowedValues();
        if (allowedValues == null || allowedValues.size() == 0) {
            return null;
        }
        if (v.length() == 0 && pp.getDefaultValue() != null) {
            return null;
        }
        if (allowedValues.contains(v.trim())) {
            return null;
        }
        return "Invalid value: " + v + ". Allowed values: " + JccConfigUtilCmdLine.clean(allowedValues);
    }

    private static String clean(List<String> allowedValues) {
        String s = allowedValues.toString();
        s = s.substring(1, s.length() - 1);
        return s;
    }

    private void updateUserInput(ConfigurationParameter pp) {
        Iterator<ConfigurationParameter> iter = this.allUserInput.iterator();
        while (iter.hasNext()) {
            ConfigurationParameter p = iter.next();
            if (!p.getName().equals(pp.getName())) continue;
            iter.remove();
        }
        this.allUserInput.add(pp);
    }

    private void promptForDbVersion(InstallParameters iparams) throws IOException {
        ConfigurationParameter pDbVer = ConfigurationParameter.create("oracle.version", "Target Oracle version specified as <major-version>.<minor-version>", "Target Oracle version", null, "11.2");
        while (!pDbVer.hasUserInput()) {
            try {
                this.promptForInput(pDbVer);
                iparams.databaseVersion = InstallParameters.parseDbVersion(pDbVer.getUserInput());
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
    }

    public void promptForInput(ConfigurationParameter p) throws IOException {
        if (p.isPassword()) {
            JccConfigUtilCmdLine.promptForPassword(p);
            return;
        }
        String prompt = "\n" + p.getPromptMessage();
        String proposedInput = null;
        if (p.getAllowedValues() != null) {
            String allowedValues = JccConfigUtilCmdLine.clean(p.getAllowedValues());
            prompt = prompt + " (" + allowedValues + ")";
        }
        if (p.hasUserInput()) {
            proposedInput = p.getUserInput();
        } else if (p.hasDefaultValue()) {
            proposedInput = p.getDefaultValue();
        }
        if (proposedInput != null) {
            prompt = prompt + " [" + proposedInput + "]";
        }
        prompt = prompt + ": ";
        System.out.print(prompt);
        String input = JccConfigUtilCmdLine.readStdIn();
        String errMsg = JccConfigUtilCmdLine.checkValue(p, input);
        while (errMsg != null) {
            InstallCmdLine.warn(errMsg);
            System.out.print(prompt);
            input = JccConfigUtilCmdLine.readStdIn();
            errMsg = JccConfigUtilCmdLine.checkValue(p, input);
        }
        if (input.length() == 0) {
            input = proposedInput;
        }
        p.setUserInput(input);
        this.updateUserInput(p);
    }

    public List<ConfigurationParameter> getAllUserInputs() {
        return this.allUserInput;
    }

    public void promptCheckInput(ConfigurationParameter pp) throws IOException {
        while (true) {
            this.promptForInput(pp);
            String i = pp.getUserInput();
            if (i != null && i.trim().length() != 0) break;
            InstallCmdLine.warn("Required parameter:");
        }
    }

    private static final void printUsageAndExit() {
        System.err.println("");
        System.err.println("Arguments: command [options]");
        System.err.println("");
        System.err.println("   where command may be list-sqls-for-jcc-owner-privs, list-sqls-for-jcc-user-privs, list-sqls-for-creating-pub-syns, list-sqls-for-dropping-pub-syns, list-dba-sqls, list-sqls-for-staging-schema, config-index-user");
        System.err.println("");
        System.exit(1);
    }

    public static final void main(String[] args) {
        try {
            if (args.length == 0) {
                JccConfigUtilCmdLine.printUsageAndExit();
            }
            JccConfigUtilCmdLine cmd = new JccConfigUtilCmdLine();
            if (args[0].equals("list-sqls-for-jcc-owner-privs")) {
                cmd.printPrivilegesRequiredForJccOwner(args);
            } else if (args[0].equals("list-sqls-for-jcc-user-privs")) {
                cmd.printPrivilegesRequiredForJccUser(args);
            } else if (args[0].equals("list-sqls-for-creating-pub-syns")) {
                System.err.println("call <jcc-owner-schema>.privman_pkg.public_syns_for_jcobjs('<jcc-owner-schema>')");
            } else if (args[0].equals("list-sqls-for-dropping-pub-syns")) {
                System.err.println("call <jcc-owner-schema>.privman_pkg.drop_public_syns_for_jcobjs('<jcc-owner-schema>')");
            } else if (args[0].equals("list-dba-sqls")) {
                cmd.listDbaSqls(args);
            } else if (args[0].equals("list-sqls-for-staging-schema")) {
                cmd.printPrivilegesRequiredForStagingSchema();
            } else if (args[0].equals("config-index-user")) {
                IndexUserConfig.main(null);
            } else {
                JccConfigUtilCmdLine.printUsageAndExit();
            }
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
            System.exit(1);
        }
    }

    public static Connection createConnection(InstallParameters iparams, String login, String password) throws NumberFormatException, ClassNotFoundException, SQLException {
        return ConnectUtil.getConnection(iparams.oracleHost.getUserInput(), Integer.parseInt(iparams.oracleListenerPort.getUserInput()), iparams.oracleInstanceName.getUserInput(), login, password);
    }
}

