/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.server.Bootstrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerCtrl {
    private static final Logger logger = Logger.getLogger(ServerCtrl.class.getName());
    private InstallParameters ip;
    public static final String DEFAULT_CONFIG_FILE_PATH = "conf/jcart.properties";

    public ServerCtrl(InstallParameters ip) {
        this.ip = ip;
        ServerCtrl.getConfigFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePortInConfigFile(int port) throws IOException {
        String propName = "jchem.server.port";
        String propValue = port + "";
        Properties props = new Properties();
        String configFileName = "conf" + File.separator + "jcart.properties";
        FileInputStream fin = new FileInputStream(configFileName);
        try {
            props.load(fin);
        }
        finally {
            fin.close();
        }
        props.setProperty(propName, propValue);
        FileOutputStream fout = new FileOutputStream(configFileName);
        try {
            props.store(fout, "header");
        }
        finally {
            fout.close();
        }
    }

    private void updateInstallParameter(int port) {
        this.ip.jchemServerPort.setUserInput(port + "");
    }

    private int getFirstFreePort() throws IOException {
        int minPort = 1099;
        int maxPort = 60000;
        boolean found = false;
        int port = 1099;
        for (int ix = 0; ix < 60000; ++ix) {
            try {
                port += ix;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Trying port " + port + "...");
                }
                ServerSocket s = new ServerSocket(port);
                found = true;
                s.close();
                return port;
            }
            catch (IOException e) {
                if (!found) continue;
                throw e;
            }
        }
        throw new RuntimeException("No free port found between 1099 and 60000");
    }

    public int startCheckPort() throws IOException, InterruptedException {
        int port = Integer.parseInt(this.ip.jchemServerPort.getDefaultValue());
        int userSpecifiedPort = Integer.parseInt(this.ip.jchemServerPort.getUserInput());
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("port=" + port + ", userSpecifiedPort=" + userSpecifiedPort);
        }
        if (port != userSpecifiedPort) {
            port = userSpecifiedPort;
        } else {
            port = this.getFirstFreePort();
            this.updatePortInConfigFile(port);
            this.updateInstallParameter(port);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Starting JChem Server at port " + port + "...");
        }
        this.start();
        return port;
    }

    public boolean start() throws IOException, InterruptedException {
        if (this.ip.isJCServerLocal()) {
            Bootstrapper.getInstance().serverControl(this.ip.jchemHome, "start");
            Bootstrapper.getInstance().waitForServerProcezzAsynch();
            return true;
        }
        return false;
    }

    public boolean stop() throws IOException, InterruptedException {
        if (this.ip.isJCServerLocal()) {
            if (this.isRunning()) {
                Bootstrapper.getInstance().serverControl(this.ip.jchemHome, "stop");
            }
            return true;
        }
        return false;
    }

    public void destroy() {
        Bootstrapper.getInstance().destroy();
    }

    public boolean isRunning() throws InterruptedException {
        boolean isRunning;
        Thread.sleep(5000L);
        boolean bl = isRunning = !Bootstrapper.getInstance().isServerProcezzFinishing() && !Bootstrapper.getInstance().isServerProcezzFinished();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("returning " + isRunning);
        }
        return isRunning;
    }

    public static String getConfigFilePath() {
        String configFilePath = System.getProperty("chemaxon.jchem.cartridge.config.file");
        if (configFilePath == null) {
            configFilePath = DEFAULT_CONFIG_FILE_PATH;
            System.setProperty("chemaxon.jchem.cartridge.config.file", configFilePath);
        }
        return configFilePath;
    }
}

