/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.util.RuntimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsServiceInstaller {
    private static final Logger logger = Logger.getLogger(WindowsServiceInstaller.class.getName());
    public static final String SRV_DESCRIPTION = "JChem Cartridge Server";
    private InstallParameters ip;
    private File jcartDir;
    private File prunSrv;

    public WindowsServiceInstaller(InstallParameters ip) {
        this.ip = ip;
    }

    public void installService() throws IOException, InterruptedException {
        this.installOrUpdateService("I");
    }

    public void upgradeService() throws IOException, InterruptedException {
        this.installOrUpdateService("U");
    }

    private void installOrUpdateService(String discrim) throws IOException, InterruptedException {
        ArrayList<String> argList = this.initCommand();
        argList.add("//" + discrim + "S//" + this.ip.serviceName.getUserInput());
        argList.add("--DisplayName=" + this.ip.serviceDisplayName.getUserInput());
        argList.add("--Install=" + this.prunSrv.getCanonicalPath());
        String javaHome = System.getProperty("java.home");
        File jvmDll = new File(javaHome + "\\bin\\server\\jvm.dll");
        if (!jvmDll.exists()) {
            throw new IllegalArgumentException(jvmDll.getCanonicalPath() + " not found. JAVA_HOME must point " + "to a JDK instead of a JRE.");
        }
        argList.add("--JavaHome=" + javaHome);
        argList.add("--Jvm=" + jvmDll.getCanonicalPath());
        File confDir = new File(this.jcartDir, "conf");
        File jcartPropFile = new File(confDir, "jcart.properties");
        argList.add("--JvmOptions=-Xrs#-Doracle.home=" + this.ip.oracleHome.getUserInput() + "#-Dchemaxon.jchem.cartridge.config.file=" + jcartPropFile.getCanonicalPath());
        File jchemLibDir = new File(this.jcartDir.getParentFile(), "lib");
        File jchemJar = new File(jchemLibDir, "jchem.jar");
        argList.add("--Classpath=" + jchemJar.getCanonicalPath());
        argList.add("--StartMode=jvm");
        argList.add("--StopMode=jvm");
        argList.add("--StartClass=chemaxon.jchem.cartridge.server.Bootstrapper");
        argList.add("--StartParams=start");
        argList.add("--StartPath=" + this.jcartDir.getCanonicalPath());
        argList.add("--StopClass=chemaxon.jchem.cartridge.server.Bootstrapper");
        argList.add("--StopParams=stop");
        argList.add("--StopPath=" + this.jcartDir.getCanonicalPath());
        File stdout = new File(new File(this.jcartDir, "logs"), "server.stdout");
        if (!stdout.exists()) {
            stdout.createNewFile();
        }
        argList.add("--StdOutput=" + stdout.getCanonicalPath());
        File stderr = new File(new File(this.jcartDir, "logs"), "server.stderr");
        if (!stderr.exists()) {
            stderr.createNewFile();
        }
        argList.add("--StdError=" + stderr.getCanonicalPath());
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Executing " + this.toCmdLine(argList));
        }
        this.execCommand(argList, discrim.equals("I") ? 0 : 6);
    }

    public void removeService() throws IOException, InterruptedException {
        ArrayList<String> argList = this.initCommand();
        argList.add("//DS//" + this.ip.serviceName.getUserInput());
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Executing " + this.toCmdLine(argList));
        }
        this.execCommand(argList, 0);
    }

    public boolean probeService() throws IOException, InterruptedException {
        ArrayList<String> argList = this.initCommand();
        argList.add("//US//" + this.ip.serviceName.getUserInput());
        argList.add("--Description=JChem Cartridge Server");
        try {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Executing " + this.toCmdLine(argList));
            }
            this.execCommand(argList, 6);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Windows Service probe for " + this.ip.serviceName.getUserInput() + " failed", e);
            }
            return false;
        }
        return true;
    }

    private String toCmdLine(ArrayList<String> argList) {
        StringBuilder sb = new StringBuilder();
        for (String args : argList) {
            sb.append("\"").append(args).append("\" ");
        }
        return sb.toString();
    }

    private ArrayList<String> initCommand() throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        String userDir = System.getProperty("user.dir");
        this.jcartDir = new File(userDir);
        String programName = "prunsrv";
        if (System.getProperty("os.arch").trim().equals("amd64")) {
            programName = programName + "-amd64";
        }
        this.prunSrv = new File(this.jcartDir, programName);
        argList.add(this.prunSrv.getCanonicalPath());
        return argList;
    }

    private void execCommand(ArrayList<String> argList, int exitCode) throws IOException, InterruptedException {
        String[] args = new String[argList.size()];
        argList.toArray(args);
        RuntimeUtils.exec(args, exitCode);
    }
}

