/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.params;

import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.install.ConnectUtil;
import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.rmi.client.RmiServerDesc;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.util.RuntimeUtils;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallParameters {
    public static final Logger logger = Logger.getLogger(InstallParameters.class.getName());
    String[][] DEFAULT_SYSPROPS = new String[][]{{"java.rmi.dgc.leaseValue", "60000000"}, {"sun.rmi.transport.connectionTimeout", "60000000"}, {"sun.rmi.dgc.server.gcInterval", "60000000"}, {"sun.rmi.dgc.ackTimeout", "60000000"}, {"oracle.connection.cache.ValidateConnection", "true"}};
    String[][] DEFAULT_XX_OPTIONS = new String[][]{{"-OmitStackTraceInFastThrow", null}};
    public static final String[] JCHEM_OWNER_PRIVILEGES = new String[]{"unlimited tablespace", "create session", "create table", "create sequence", "create procedure", "create trigger", "create type", "create operator", "create indextype"};
    private static final String JCHEM_HOME_KEY = "jchem.home";
    public static final String USE_SQLPLUS_KEY = "chemaxon.jchem.cartridge.install.useSqlplus";
    public static final String USE_LOADJAVA_KEY = "chemaxon.jchem.cartridge.install.useLoadjava";
    public ConfigurationParameter oracleHome = new ConfigurationParameter("oracle.home");
    public ConfigurationParameter oracleHost = new ConfigurationParameter("oracle.server.host");
    public ConfigurationParameter oracleListenerPort = new ConfigurationParameter("oracle.server.port");
    public ConfigurationParameter oracleInstanceName = new ConfigurationParameter("oracle.server.instance");
    public ConfigurationParameter tnsName = new ConfigurationParameter("tns.name");
    public ConfigurationParameter jdbcDriver = new ConfigurationParameter("jdbc.driver.path");
    public ConfigurationParameter jccOwnerLogin = new ConfigurationParameter("jcart.owner.login");
    public ConfigurationParameter jccOwnerPassword = new ConfigurationParameter("jcart.owner.password");
    public ConfigurationParameter dbaLogin = new ConfigurationParameter("dba.login");
    public ConfigurationParameter dbaPassword = new ConfigurationParameter("dba.password");
    public ConfigurationParameter jchemServerHost = new ConfigurationParameter("jchem.server.host");
    public ConfigurationParameter jchemServerPort = new ConfigurationParameter("jchem.server.port");
    public ConfigurationParameter jchemServerMaxmem = new ConfigurationParameter("jcserver.maxmem");
    public ConfigurationParameter jchemServerLoggingConfigFile = new ConfigurationParameter("logging.config.file");
    public ConfigurationParameter jchemServerLogOutputDir = new ConfigurationParameter("logging.output.dir");
    public ConfigurationParameter structureCacheId = new ConfigurationParameter("structure.cache.id");
    public ConfigurationParameter basicJccRole = new ConfigurationParameter("basic.jcc.role");
    public ConfigurationParameter serviceName = new ConfigurationParameter("service.name");
    public ConfigurationParameter serviceDisplayName = new ConfigurationParameter("service.display.name");
    public Properties configFromFiles = new Properties();
    public boolean skipPrivilegeChecks;
    public int sqlPlusMajorVersion;
    public int[] databaseVersion;
    public String jchemHome = System.getProperty("jchem.home");
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public InstallParameters() throws Exception {
        if (this.jchemHome == null) {
            this.jchemHome = new File(System.getProperty("user.dir")).getParentFile().getCanonicalPath();
        }
        Map<String, ConfigurationParameter> params = ConfigurationParameter.loadFromResource("install.properties");
        this.copyParamsFrom(params);
    }

    protected void copyParamsFrom(Map<String, ConfigurationParameter> params) throws IOException, IllegalArgumentException, IllegalAccessException {
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            String paramName;
            ConfigurationParameter loadedParam;
            ConfigurationParameter paramFieldOfThis;
            Field field = fields[i];
            if (!field.getType().isAssignableFrom(ConfigurationParameter.class) || (paramFieldOfThis = (ConfigurationParameter)field.get(this)) == null || (loadedParam = params.get(paramName = paramFieldOfThis.getName())) == null) continue;
            loadedParam.copyTo(paramFieldOfThis);
        }
    }

    public Properties getConfigFromFiles() {
        return this.configFromFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustRmiUrlFromDb() throws Exception {
        RmiServerDesc rmiAddress = null;
        Connection conn = this.createConnection(this.jccOwnerLogin, this.jccOwnerPassword);
        try {
            rmiAddress = RmiDirectory.instance(new ClientSideSession(conn)).getRmiServerDesc();
        }
        finally {
            conn.close();
        }
        if (rmiAddress == null) {
            this.jchemServerHost.setDefaultValue("localhost");
            this.jchemServerPort.setDefaultValue("1099");
        } else {
            this.jchemServerHost.setDefaultValue(rmiAddress.host);
            this.jchemServerPort.setDefaultValue(rmiAddress.port + "");
        }
    }

    public void checkOracleHome() throws IOException, InterruptedException {
        String oraHome = this.oracleHome.getUserInput();
        File f = new File(oraHome + File.separator + "bin" + File.separator);
        if (!f.exists()) {
            throw new IllegalArgumentException("Invalid ORACLE_HOME '" + oraHome + "': Directory doesn't exist");
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("Invalid ORACLE_HOME '" + oraHome + "': is not a directory.");
        }
        String executable = RuntimeUtils.isWindows() ? "sqlplus.exe" : "sqlplus";
        executable = f.getAbsoluteFile() + File.separator + executable;
        File execFile = new File(executable);
        if (!execFile.exists()) {
            throw new IllegalArgumentException("Invalid ORACLE_HOME '" + oraHome + "': " + executable + " doesn't exist");
        }
        String out = "";
        try {
            out = RuntimeUtils.exec(new String[]{executable, "-V"});
            String intro = "SQL*Plus: Release ";
            int introPos = out.indexOf(intro);
            int firstDotPos = out.indexOf(46);
            String verStr = out.substring(introPos + intro.length(), firstDotPos);
            this.sqlPlusMajorVersion = Integer.parseInt(verStr);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", sioobe);
            }
            throw new IOException("Internal error : " + sioobe.getMessage() + " for '" + out + "'");
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", throwable);
            }
            throw new RuntimeException(throwable);
        }
    }

    public void checkDbaLogin() throws SQLException {
        this.checkLogin(this.dbaLogin, this.dbaPassword);
        this.checkDbaPrivileges(new String[]{"CREATE PUBLIC SYNONYM", "CREATE ANY SYNONYM"});
    }

    public void checkLogin(ConfigurationParameter login, ConfigurationParameter password) throws SQLException {
        String sql = "select systimestamp from dual";
        int port = Integer.parseInt(this.oracleListenerPort.getUserInput());
        Schema schema = new Schema(this.oracleHost.getUserInput(), port, this.oracleInstanceName.getUserInput(), login.getUserInput(), password.getUserInput(), null, false);
        try {
            schema.connect();
            schema.executeSql(sql);
            if (this.databaseVersion == null) {
                int maj = schema.getConnection().getMetaData().getDatabaseMajorVersion();
                int min = schema.getConnection().getMetaData().getDatabaseMinorVersion();
                this.databaseVersion = new int[]{maj, min};
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (SQLException sqlException) {
            int errorCode = sqlException.getErrorCode();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("error code: " + errorCode);
            }
            if (errorCode == 17002) {
                throw new SQLException("There appears to be no TNS Listener running at " + this.oracleHost.getUserInput() + ":" + port);
            }
            if (sqlException.getMessage().indexOf("ORA-12505") != -1) {
                throw new SQLException("No service identifier '" + this.oracleInstanceName.getUserInput() + "' known at " + this.oracleHost.getUserInput() + ":" + port);
            }
            if (errorCode == 1017) {
                throw new IllegalArgumentException(sqlException.getMessage(), sqlException);
            }
            if (errorCode == 1045) {
                throw new IllegalArgumentException(sqlException.getMessage(), sqlException);
            }
            throw sqlException;
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", throwable);
            }
            throw new RuntimeException(throwable);
        }
        finally {
            block19: {
                try {
                    schema.disconnect();
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(Level.SEVERE)) break block19;
                    logger.log(Level.SEVERE, "error", throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDbaPrivileges(String[] orablePrivs) throws SQLException {
        if (this.dbaLogin.getUserInput().equalsIgnoreCase("system")) {
            return;
        }
        boolean ok = false;
        Connection conn = this.createConnection(this.dbaLogin, this.dbaPassword);
        try {
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("select privilege from user_sys_privs");
                block6: while (rs.next()) {
                    String priv = rs.getString("privilege");
                    for (int i = 0; i < orablePrivs.length; ++i) {
                        String targetPriv = orablePrivs[i];
                        if (!priv.equals(targetPriv)) continue;
                        ok = true;
                        continue block6;
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
        if (!ok) {
            throw new IllegalArgumentException(this.dbaLogin.getUserInput() + " must have any of the following system privileges: " + InteropUtil.flattenStringArray(orablePrivs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTnsName(ConfigurationParameter login, ConfigurationParameter password) {
        try {
            File f = new File("check_tnsname.sql");
            try {
                if (f.exists()) {
                    f.delete();
                }
                FileOutputStream os = new FileOutputStream(f);
                try {
                    ((OutputStream)os).write("quit".getBytes());
                }
                finally {
                    ((OutputStream)os).close();
                }
                String executable = this.oracleHome.getUserInput() + File.separator + "bin" + File.separator + "sqlplus";
                RuntimeUtils.exec(new String[]{executable, "-L", login.getUserInput() + "@" + this.tnsName.getUserInput(), "@" + f.getName()}, password.getUserInput() + "\n");
            }
            finally {
                f.delete();
            }
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "exception", throwable);
            }
            String errCode = null;
            if (throwable.getMessage().indexOf("ORA-12514") != -1) {
                errCode = "ORA-12514";
            } else if (throwable.getMessage().indexOf("ORA-12154") != -1) {
                errCode = "ORA-12154";
            } else {
                throw new RuntimeException(throwable);
            }
            throw new IllegalArgumentException("Invalid TNS name (" + errCode + "): " + this.tnsName.getUserInput());
        }
    }

    public boolean doesBasicJccRoleExist() throws NumberFormatException, SQLException {
        InstallParameters ip = this;
        ConfigurationParameter login = ip.dbaLogin;
        ConfigurationParameter password = ip.dbaPassword;
        if (!login.hasUserInput()) {
            login = ip.jccOwnerLogin;
            password = ip.jccOwnerPassword;
        }
        String sql = "grant select on dual to " + this.basicJccRole.getUserInput();
        Connection conn = this.createConnection(login, password);
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqlException) {
            if (sqlException.getErrorCode() == 1917) {
                boolean bl = false;
                return bl;
            }
            throw sqlException;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemaIsEmpty(ConfigurationParameter login, ConfigurationParameter password) throws SQLException {
        String sql = "select count(*) from user_objects";
        Connection conn = this.createConnection(login, password);
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            if (rs.getInt(1) > 0) {
                throw new IllegalArgumentException("The schema " + login.getUserInput() + " must be empty.");
            }
        }
        finally {
            conn.close();
        }
    }

    public List<String> stmtsToSetupJccOwnerPrivilegesAsDba() {
        String jcartOwner = this.jccOwnerLogin.getUserInput();
        String jchemServerHost = this.jchemServerHost.getUserInput();
        String jchemServerPort = this.jchemServerPort.getUserInput();
        int[] dbVer = this.databaseVersion;
        ArrayList<String> l = new ArrayList<String>();
        for (String priv : JCHEM_OWNER_PRIVILEGES) {
            l.add("GRANT " + priv + " to " + jcartOwner);
        }
        l.addAll(InstallUtil.getJavaPermGrantStmts(jcartOwner, jchemServerHost, jchemServerPort, dbVer));
        return l;
    }

    public List<String> stmtsToSetupBasicJccRoleAsDba() throws SQLException {
        ArrayList<String> l = new ArrayList<String>();
        l.add("create role " + this.basicJccRole.getUserInput());
        l.addAll(InstallUtil.getJavaPermGrantStmts(this.basicJccRole.getUserInput(), this.jchemServerHost.getUserInput(), this.jchemServerPort.getUserInput(), this.databaseVersion));
        l.add("grant " + this.basicJccRole.getUserInput() + " to " + this.jccOwnerLogin.getUserInput() + " with admin option");
        return l;
    }

    public List<String> stmtsToConfigureBasicJccRoleAsJccOwner(String targetOracleUser) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("call " + this.jccOwnerLogin.getUserInput() + "." + "privman_pkg.grants_on_jcobjs('" + this.jccOwnerLogin.getUserInput() + "', '" + targetOracleUser + "')");
        return l;
    }

    public Connection createConnection(ConfigurationParameter login, ConfigurationParameter password) throws NumberFormatException, SQLException {
        Connection conn = ConnectUtil.getConnection(this.oracleHost.getUserInput(), Integer.parseInt(this.oracleListenerPort.getUserInput()), this.oracleInstanceName.getUserInput(), login.getUserInput(), password.getUserInput());
        return conn;
    }

    public static File jccPropFileInJccHome(File cartHome) {
        File confDir = new File(cartHome, "conf");
        return new File(confDir, "jcart.properties");
    }

    public void initJdbcDriverPath() throws IOException {
        if (!this.jdbcDriver.hasDefaultValue()) {
            File oracleHome = new File(this.oracleHome.getUserInput());
            File jdbcDir = new File(oracleHome.getCanonicalFile(), "jdbc");
            File jdbcLibDir = new File(jdbcDir, "lib");
            File jdbcDriver5File = new File(jdbcLibDir, "ojdbc5.jar");
            File jdbcDriver14File = new File(jdbcLibDir, "ojdbc14.jar");
            File jdbcDriverFile = jdbcDriver5File;
            if (!jdbcDriver5File.exists()) {
                if (jdbcDriver14File.exists()) {
                    jdbcDriverFile = jdbcDriver14File;
                } else {
                    throw new IllegalArgumentException("Neither " + jdbcDriver14File + ", nor " + jdbcDriver5File + " exists!");
                }
            }
            this.jdbcDriver.setDefaultValue(jdbcDriverFile.getCanonicalPath());
        }
    }

    public void checkJCartOwnerLogin() throws SQLException {
        this.checkLogin(this.jccOwnerLogin, this.jccOwnerPassword);
        this.checkSchemaIsEmpty(this.jccOwnerLogin, this.jccOwnerPassword);
        this.checkJCartOwnerPrivileges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJCartOwnerPrivileges() throws SQLException {
        Schema s = InstallUtil.createSchema(this, this.jccOwnerLogin, this.jccOwnerPassword, false);
        s.connect();
        try {
            if (!this.skipPrivilegeChecks) {
                InstallUtil.checkPrivileges(s, JCHEM_OWNER_PRIVILEGES);
            }
            try {
                InstallUtil.checkJavaPrivilege(s, "java.net.SocketPermission", this.jchemServerHost.getUserInput(), "resolve,connect");
            }
            catch (IllegalArgumentException iae) {
                try {
                    InstallUtil.checkJavaPrivilege(s, "java.net.SocketPermission", this.jchemServerHost.getUserInput(), "connect,resolve");
                }
                catch (IllegalArgumentException iae1) {
                    InstallUtil.checkJavaPrivilege(s, "java.net.SocketPermission", this.jchemServerHost.getUserInput(), "connect");
                    InstallUtil.checkJavaPrivilege(s, "java.net.SocketPermission", this.jchemServerHost.getUserInput(), "resolve");
                }
            }
        }
        finally {
            s.disconnect();
        }
    }

    public static int[] parseDbVersion(String dbVer) {
        String msg = "The database version parameter must be of the form <major-version>.<minor-version>. E.g: 10.2";
        int dotPos = dbVer.indexOf(46);
        if (dotPos == -1) {
            throw new IllegalArgumentException("The database version parameter must be of the form <major-version>.<minor-version>. E.g: 10.2");
        }
        try {
            int majorVer = Integer.parseInt(dbVer.substring(0, dotPos));
            int minorVer = Integer.parseInt(dbVer.substring(dotPos + 1));
            return new int[]{majorVer, minorVer};
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("The database version parameter must be of the form <major-version>.<minor-version>. E.g: 10.2");
        }
    }

    public String getRmiLocator() {
        return this.jchemServerHost.getUserInput() + ":" + this.jchemServerPort.getUserInput();
    }

    public void checkServiceName() {
        char[] arr$ = this.serviceName.getUserInput().toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (Character.isLetter(c.charValue()) || Character.isDigit(c.charValue())) continue;
            throw new IllegalArgumentException("The service name must be composed of alpha-numeric characters (as opposed to the service display name).");
        }
    }

    public void loadUiFromFiles(String fname) throws IOException, IllegalArgumentException, IllegalAccessException {
        this.configFromFiles = new Properties();
        StringTokenizer tokizer = new StringTokenizer(fname, ",");
        while (tokizer.hasMoreTokens()) {
            String f = tokizer.nextToken().trim();
            this.loadUiFromFile(this.configFromFiles, f);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Properties from files: " + this.configFromFiles);
        }
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getType().isAssignableFrom(ConfigurationParameter.class)) continue;
            ConfigurationParameter paramFieldOfThis = (ConfigurationParameter)field.get(this);
            String fieldName = paramFieldOfThis.getName();
            String configValueFromFile = this.configFromFiles.getProperty(fieldName);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Parameter field name=" + fieldName + ", value from config files=" + configValueFromFile);
            }
            if (configValueFromFile == null) continue;
            paramFieldOfThis.setUserInput(configValueFromFile);
            this.configFromFiles.remove(fieldName);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("oracle.server.host=" + this.oracleHost.getUserInput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUiFromFile(Properties props, String f) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        try {
            props.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String fname) throws IOException, IllegalArgumentException, IllegalAccessException {
        BufferedWriter w = new BufferedWriter(new FileWriter(fname));
        try {
            this.store(w);
        }
        finally {
            ((Writer)w).close();
        }
    }

    public Iterator<Object> persistentParameters() {
        final Class<?> clazz = this.getClass();
        final InstallParameters instance = this;
        return new Iterator<Object>(){
            private ArrayList<Object> l;

            @Override
            public boolean hasNext() {
                if (this.l == null) {
                    this.l = new ArrayList();
                    try {
                        Field[] fields = clazz.getFields();
                        for (int i = 0; i < fields.length; ++i) {
                            Field f = fields[i];
                            Object obj = f.get(instance);
                            if (f.getName().endsWith("Password") || !(obj instanceof ConfigurationParameter)) continue;
                            this.l.add(obj);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.l.size() > 0;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.l.remove(0);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void store(Writer writer) throws IllegalArgumentException, IllegalAccessException, IOException {
        Iterator<Object> iter = this.persistentParameters();
        while (iter.hasNext()) {
            ConfigurationParameter p = (ConfigurationParameter)iter.next();
            try {
                if (!p.isValueToBeSaved() || !p.hasUserInput() && !p.hasDefaultValue()) continue;
                this.store(writer, p);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing parameter: " + p.getName());
            }
        }
        Properties propsWithoutComment = this.getPropertiesWithoutComments();
        TreeSet<Object> sortedKeys = new TreeSet<Object>();
        sortedKeys.addAll(propsWithoutComment.keySet());
        for (Object e : sortedKeys) {
            String propertyName = (String)e;
            this.writeln(writer);
            this.write(writer, propertyName, propsWithoutComment.getProperty(propertyName));
        }
    }

    private Properties getPropertiesWithoutComments() {
        Properties propsWithoutComment = new Properties();
        for (int i = 0; i < this.DEFAULT_SYSPROPS.length; ++i) {
            String[] sysProp = this.DEFAULT_SYSPROPS[i];
            propsWithoutComment.setProperty("sysprop." + sysProp[0], sysProp[1]);
        }
        for (String[] xxOpt : this.DEFAULT_XX_OPTIONS) {
            propsWithoutComment.setProperty("xx.opt." + xxOpt[0], xxOpt[1] == null ? "" : xxOpt[1]);
        }
        propsWithoutComment.putAll((Map<?, ?>)this.configFromFiles);
        return propsWithoutComment;
    }

    private void store(Writer writer, ConfigurationParameter p) throws IOException {
        StringTokenizer paramDescByWord = new StringTokenizer(p.getDescription(), " \t");
        StringBuffer line = new StringBuffer();
        while (paramDescByWord.hasMoreTokens()) {
            String t = paramDescByWord.nextToken();
            if (line.length() > 0 && line.length() + t.length() > 75) {
                this.writeln(writer);
                writer.write("# ");
                this.write(writer, line.toString());
                line = new StringBuffer(t);
                continue;
            }
            if (line.length() > 0) {
                line.append(" ");
            }
            line.append(t);
        }
        if (line.length() > 0) {
            this.writeln(writer);
            writer.write("# ");
            this.write(writer, line.toString());
        }
        this.writeln(writer);
        if (!p.hasUserInput() && !p.hasDefaultValue()) {
            writer.write("# ");
        } else {
            String propertyName = p.getName();
            String propertyValue = null;
            if (p.hasUserInput()) {
                propertyValue = p.getUserInput();
            } else if (p.hasDefaultValue()) {
                propertyValue = p.getDefaultValue();
            }
            this.write(writer, propertyName, propertyValue);
        }
        this.writeln(writer);
    }

    private void writeln(Writer writer) throws IOException {
        String lineSep = "\n";
        if (RuntimeUtils.isWindows()) {
            lineSep = "\r\n";
        }
        writer.write(lineSep);
    }

    private void write(Writer writer, String s) throws IOException {
        writer.write(this.escape(s));
    }

    private void write(Writer writer, String name, String value) throws IOException {
        writer.write(this.escape(name) + "=" + this.escape(value));
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer();
        block8: for (int ix = 0; ix < s.length(); ++ix) {
            char aChar = s.charAt(ix);
            switch (aChar) {
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block8;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block8;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block8;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    sb.append('\\');
                    sb.append(s.charAt(ix));
                    continue block8;
                }
                case '\\': {
                    sb.append('\\').append('\\');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(InstallParameters.toHex(aChar >> 12 & 0xF));
                        sb.append(InstallParameters.toHex(aChar >> 8 & 0xF));
                        sb.append(InstallParameters.toHex(aChar >> 4 & 0xF));
                        sb.append(InstallParameters.toHex(aChar & 0xF));
                        continue block8;
                    }
                    sb.append(aChar);
                }
            }
        }
        return sb.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public boolean isJCServerLocal() throws IOException {
        return InstallUtil.isLocalAddress(this.jchemServerHost.getUserInput());
    }

    public boolean hasDbaWithCreateRolePrivs() throws SQLException {
        boolean hasReqDBA = true;
        if (!this.dbaLogin.hasUserInput()) {
            hasReqDBA = false;
        } else {
            try {
                this.checkDbaPrivileges(new String[]{"CREATE ROLE"});
            }
            catch (IllegalArgumentException iae) {
                hasReqDBA = false;
            }
        }
        return hasReqDBA;
    }

    public static void main(String[] args) {
        System.setProperty("sun.rmi.dgc.serer.gcInterval", "300000");
        System.out.println(System.getProperty("sun.rmi.dgc.serer.gcInterval"));
    }

    public boolean useSqlPlus() {
        String useSqlPlus = System.getProperty(USE_SQLPLUS_KEY);
        return useSqlPlus != null && Boolean.parseBoolean(useSqlPlus);
    }

    public boolean useLoadjava() {
        String useLoadjava = System.getProperty(USE_LOADJAVA_KEY);
        return useLoadjava != null && Boolean.parseBoolean(useLoadjava);
    }
}

