/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.params;

import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.install.schema.Schema;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpgradeParameters
extends InstallParameters {
    public static final Logger logger = Logger.getLogger(UpgradeParameters.class.getName());
    public ConfigurationParameter pathToOldJChem = new ConfigurationParameter("path.to.old.jchem");
    public ConfigurationParameter oldJccDir = new ConfigurationParameter("old.jcc.dir");
    public ConfigurationParameter pathToOldJcc = new ConfigurationParameter("path.to.old.jcc");
    public ConfigurationParameter stagingSchema = new ConfigurationParameter("staging.schema");
    public ConfigurationParameter stagingSchemaPassword = new ConfigurationParameter("staging.password");
    public ConfigurationParameter rebuildIndexes = new ConfigurationParameter("rebuild.indexes");
    public ConfigurationParameter skipRebuildAutoCalcCt = new ConfigurationParameter("skip.rebuild.autocalcct");
    public ConfigurationParameter oldStructureCacheId = new ConfigurationParameter("old.structure.cache.id");
    public ConfigurationParameter upgradePlanOnly = new ConfigurationParameter("upgrade.plan.only");
    public int sqlPlusMajorVersion;

    public UpgradeParameters() throws Exception {
        Map<String, ConfigurationParameter> params = ConfigurationParameter.loadFromResource("upgrade.properties");
        this.copyParamsFrom(params);
    }

    @Override
    public void checkJCartOwnerLogin() throws SQLException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("oracle.server.host=" + this.oracleHost.getUserInput());
        }
        this.checkLogin(this.jccOwnerLogin, this.jccOwnerPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStagingSchema() throws SQLException {
        this.checkSchemaIsEmpty(this.stagingSchema, this.stagingSchemaPassword);
        Schema s = InstallUtil.createSchema(this, this.stagingSchema, this.stagingSchemaPassword, false);
        s.connect();
        try {
            if (!this.skipPrivilegeChecks) {
                InstallUtil.checkPrivileges(s, JCHEM_OWNER_PRIVILEGES);
            }
        }
        finally {
            s.disconnect();
        }
    }

    public void checkOldJChemHome() throws IOException {
        File oldJChemHome = new File(this.pathToOldJChem.getUserInput());
        if (!oldJChemHome.exists() || !oldJChemHome.isDirectory()) {
            throw new IllegalArgumentException(oldJChemHome.getCanonicalPath() + " doesn't either exist or is not a directory");
        }
        File libDir = new File(oldJChemHome, "lib");
        File jchemJarFile = new File(libDir, "jchem.jar");
        if (!jchemJarFile.exists() || jchemJarFile.isDirectory()) {
            throw new IllegalArgumentException(oldJChemHome.getCanonicalPath() + " doesn't appear to be a JChem home directory.");
        }
    }

    public boolean isOldJChem50OrLater() throws IOException {
        File cartProp = InstallParameters.jccPropFileInJccHome(new File(this.pathToOldJcc.getUserInput()));
        return cartProp.isFile();
    }

    public void constructPathToOldJcc() throws IOException {
        File jc = new File(this.pathToOldJChem.getUserInput(), this.oldJccDir.getUserInput());
        this.pathToOldJcc.setUserInput(jc.getCanonicalPath());
    }
}

