/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.PlSqlOperatorBinding;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObject;
import chemaxon.jchem.cartridge.install.schema.UpgradeStep;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class IndexType
extends SchemaObject {
    private static final Logger logger = Logger.getLogger(IndexType.class.getName());
    private String implementationName;
    private ArrayList<PlSqlOperatorBinding> operatorBindings = new ArrayList();
    private String partitioning;
    private UpgradeStep dropBindingsStep;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexType(Schema schema, String name, String implementationName, String partitioning) throws SQLException {
        super(schema, "INDEXTYPE", name);
        this.implementationName = implementationName;
        this.partitioning = partitioning;
        String sql = "select operator_name, binding# from all_indextype_operators where owner = upper(?) and indextype_name = upper(?) and operator_schema = upper(?)";
        PreparedStatement pstmt = schema.conn.prepareStatement(sql);
        try {
            int paramIdx = 1;
            pstmt.setString(paramIdx++, schema.username);
            pstmt.setString(paramIdx++, name);
            pstmt.setString(paramIdx++, schema.username);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String operatorName = rs.getString("operator_name");
                int bindingNo = rs.getInt("binding#");
                this.putSignature(operatorName, bindingNo);
            }
        }
        finally {
            pstmt.close();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Operator " + schema.username + "." + name + " has " + this.operatorBindings.size() + " operator binding(s) assigned to it");
        }
    }

    private void putSignature(String operatorName, int bindingNo) {
        List<PlSqlOperatorBinding> bindings = this.schema.allOperatorBindings.get(operatorName);
        if (bindings == null) {
            throw new RuntimeException("Bindings for " + operatorName + " not found amongst " + this.operatorBindings.size() + " bindings.");
        }
        for (PlSqlOperatorBinding binding : bindings) {
            if (bindingNo != binding.bindingNo) continue;
            this.operatorBindings.add(binding);
            return;
        }
    }

    public void create() throws SQLException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("create or replace indextype ");
        sqlBuffer.append(this.schema.username).append(".").append(this.id.getName());
        sqlBuffer.append(" for ");
        boolean startSigList = true;
        for (PlSqlOperatorBinding signature : this.operatorBindings) {
            if (startSigList) {
                startSigList = false;
            } else {
                sqlBuffer.append(",");
            }
            sqlBuffer.append("\n").append(signature.operatorName);
            sqlBuffer.append("(").append(signature).append(")");
        }
        sqlBuffer.append("using ").append(this.implementationName).append("\n");
        if (this.partitioning != null) {
            if (this.partitioning.equals("RANGE")) {
                sqlBuffer.append("with local range partition");
            } else {
                throw new IllegalArgumentException("Unexpected partitioning scheme: " + this.partitioning);
            }
        }
        this.createUpgradeStep(this.schema, sqlBuffer.toString());
        this.schema.add(this);
    }

    @Override
    public void prepareUpgradePlan(SchemaObject newVersion) throws SQLException {
        ArrayList<PlSqlOperatorBinding> dropList = new ArrayList<PlSqlOperatorBinding>();
        ArrayList<PlSqlOperatorBinding> addList = new ArrayList<PlSqlOperatorBinding>();
        IndexType newIdxTypVersion = (IndexType)newVersion;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Upgrading index type " + this.id.getName() + ". Number of current operator signatures: " + this.operatorBindings.size() + ", number of new operator signatures: " + newIdxTypVersion.operatorBindings.size());
        }
        for (PlSqlOperatorBinding currentBinding : this.operatorBindings) {
            if (!newIdxTypVersion.operatorBindings.remove(currentBinding)) {
                dropList.add(currentBinding);
                continue;
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest(currentBinding + " needs not to be dropped.");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Index type " + this.id.getName() + ". Number of current operator signatures: " + this.operatorBindings.size() + ", number of new operator signatures: " + newIdxTypVersion.operatorBindings.size());
        }
        Iterator<PlSqlOperatorBinding> iterator = newIdxTypVersion.operatorBindings.iterator();
        while (iterator.hasNext()) {
            addList.add(iterator.next());
        }
        this.dropAndAddBindings(dropList, addList);
    }

    private void dropAndAddBindings(ArrayList<PlSqlOperatorBinding> dropList, ArrayList<PlSqlOperatorBinding> addList) throws SQLException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("dropList size=" + dropList.size() + ", addList size=" + addList.size());
        }
        if (dropList.size() == 0 && addList.size() == 0) {
            return;
        }
        String dropString = this.dropOrAddList(dropList, "drop");
        String addString = this.dropOrAddList(addList, "add");
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("dropString=" + dropString + ", addString=" + addString);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("alter indextype ").append(this.id.getName()).append("\n");
        if (dropString.length() > 0) {
            sqlBuffer.append(dropString);
            this.dropBindingsStep = new UpgradeStep(this.schema, this.id, sqlBuffer.toString());
        }
        sqlBuffer = new StringBuffer();
        sqlBuffer.append("alter indextype ");
        sqlBuffer.append(this.schema.username).append(".").append(this.id.getName()).append("\n");
        if (addString.length() > 0) {
            sqlBuffer.append(addString);
            this.createUpgradeStep(this.schema, sqlBuffer.toString());
        }
    }

    private String dropOrAddList(ArrayList<PlSqlOperatorBinding> dropOrAddList, String dropOrAddCmd) {
        StringBuffer sqlBuffer = new StringBuffer();
        for (PlSqlOperatorBinding binding : dropOrAddList) {
            if (sqlBuffer.length() > 0) {
                sqlBuffer.append(",\n");
            }
            sqlBuffer.append(dropOrAddCmd).append(" ");
            sqlBuffer.append(this.schema.username).append(".").append(binding.operatorName);
            sqlBuffer.append("(").append(binding.argListString()).append(")");
        }
        return sqlBuffer.toString();
    }

    public List<UpgradeStep> getDropBindingsSteps() throws Exception {
        ArrayList<UpgradeStep> steps = new ArrayList<UpgradeStep>();
        if (this.dropBindingsStep != null) {
            steps.add(this.dropBindingsStep);
            this.dropBindingsStep = null;
        }
        return steps;
    }

    @Override
    public void prepareCreatePlan(Schema targetSchema) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

