/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.Schema;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlSqlLoader {
    private static final Logger logger = Logger.getLogger(PlSqlLoader.class.getName());
    private Connection conn;

    public PlSqlLoader(Connection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fileName) throws IOException, SQLException {
        StringBuilder source = new StringBuilder();
        boolean blockCommentOpen = false;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        try {
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).toLowerCase().startsWith("whenever") || line.toLowerCase().startsWith("show")) {
                    source = new StringBuilder();
                    line = br.readLine();
                    continue;
                }
                if (line.toLowerCase().startsWith("rem ") || line.startsWith("--")) {
                    line = br.readLine();
                    continue;
                }
                if (blockCommentOpen) {
                    if (line.endsWith("*/")) {
                        blockCommentOpen = false;
                    }
                } else {
                    if (line.startsWith("/*")) {
                        blockCommentOpen = true;
                        line = br.readLine();
                        continue;
                    }
                    if (line.startsWith("/")) {
                        this.load0(source.toString());
                        source = new StringBuilder();
                    } else {
                        source.append("\n").append(line);
                    }
                }
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load0(String string) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("=======================================> Executing <=======================================\n" + string);
            }
            stmt.execute(string);
        }
        catch (SQLException sqlException) {
            throw new SQLException("Statement " + string + " failed", sqlException);
        }
        finally {
            try {
                PlSqlLoader.checkErrors(this.conn, null, "%", null);
            }
            finally {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkErrors(Connection conn, String owner, String name, PlSqlErrorHandler eh) throws SQLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("owner=" + owner + ", name=" + name + ", eh=" + eh);
        }
        StringBuffer buffer = new StringBuffer();
        String errorCheckSql = "select owner, type, name, text, line, position from all_errors where owner = " + (owner == null ? "user" : "upper(?)") + " and name like upper(?) " + "order by sequence";
        PreparedStatement pstmt = conn.prepareStatement(errorCheckSql);
        try {
            int idxParam = 1;
            if (owner != null) {
                pstmt.setString(idxParam++, owner);
            }
            pstmt.setString(idxParam++, name);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String o = rs.getString("owner");
                String t = rs.getString("type");
                String n = rs.getString("name");
                String text = rs.getString("text");
                String line = rs.getString("line");
                String position = rs.getString("position");
                if (buffer.length() == 0 && eh != null) {
                    eh.handleErrorText(text);
                }
                buffer.append("\n");
                buffer.append(o + ": " + t + " " + n + "[").append(line).append(",").append(position).append("]: ").append(text);
            }
        }
        finally {
            pstmt.close();
        }
        if (buffer.length() > 0) {
            throw new SQLException(buffer.toString());
        }
    }

    public static void main(String[] args) {
        try {
            String host = "localhost";
            int port = 1521;
            String instance = "mydb";
            String user = "plsqlloader";
            String password = "ciril";
            Class.forName("oracle.jdbc.OracleDriver");
            Connection c = DriverManager.getConnection("jdbc:oracle:thin:@" + host + ":" + port + ":" + instance, user, password);
            PlSqlLoader l = new PlSqlLoader(c);
            l.load("C:\\Users\\pkovacs\\chemaxon\\work\\trunk\\jchem\\jchemsite\\cartridge\\jchem_cart.sql");
            Schema s = new Schema("localhost", 1521, "mydb", user, password, null, false);
            s.buildFromDatabase();
            s.verifyBasedOn(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static interface PlSqlErrorHandler {
        public void handleErrorText(String var1) throws SQLException;
    }
}

