/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.Schema;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class PlSqlOperatorBinding {
    private static final Logger logger = Logger.getLogger(PlSqlOperatorBinding.class.getName());
    private Schema schema;
    public String operatorName;
    public ArrayList<String> argumentTypes = new ArrayList();
    public int bindingNo;
    public String functionName;
    public String returnType;
    public String contextClause;

    public PlSqlOperatorBinding(Schema schema, int bindingNo, String operatorName) throws SQLException {
        this.schema = schema;
        this.operatorName = operatorName;
        this.bindingNo = bindingNo;
        this.init(operatorName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String operatorName) throws SQLException {
        String sql = "select function_name, return_schema, return_type, implementation_type, property from all_opbindings where owner = upper(?) and operator_name = upper(?) and binding# = ?";
        PreparedStatement pstmt = this.schema.conn.prepareStatement(sql);
        try {
            pstmt.setString(1, this.schema.username);
            pstmt.setString(2, operatorName);
            pstmt.setInt(3, this.bindingNo);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No bindings returned for operator=" + operatorName);
            }
            String retSchema = rs.getString("return_schema");
            if (retSchema != null && !retSchema.equals(this.schema.username)) {
                throw new RuntimeException("Return schema for operator " + operatorName + " is different from schema " + this.schema.username);
            }
            this.functionName = rs.getString("function_name");
            this.returnType = rs.getString("return_type");
            String implementationType = rs.getString("implementation_type");
            String property = rs.getString("property");
            if (property != null) {
                if (property.equals("WITH INDEX CONTEXT")) {
                    this.contextClause = "with index context, scan context " + implementationType;
                } else {
                    throw new IllegalArgumentException("Unexpected operator binding property for " + this.schema.username + "." + operatorName + ": " + property);
                }
            }
            if (rs.next()) {
                throw new RuntimeException("Too many bindings returned for operator=" + operatorName);
            }
        }
        finally {
            pstmt.close();
        }
    }

    protected String argListString() {
        StringBuffer argTypeBuffer = new StringBuffer();
        for (String type : this.argumentTypes) {
            if (argTypeBuffer.length() > 0) {
                argTypeBuffer.append(',');
            }
            argTypeBuffer.append(type);
        }
        return argTypeBuffer.toString();
    }

    public String toAddString() {
        return "add binding " + this.toString();
    }

    public String toDropString() {
        return "drop binding (" + this.argListString() + ")";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(").append(this.argListString()).append(") return ");
        buffer.append(this.returnType);
        if (this.contextClause != null) {
            buffer.append(" ").append(this.contextClause);
        }
        if (this.functionName != null) {
            buffer.append(" using ").append(this.functionName);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Returning '" + buffer + "'...");
        }
        return buffer.toString();
    }

    public String toFullString() {
        return this.operatorName + this.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlSqlOperatorBinding)) {
            return false;
        }
        PlSqlOperatorBinding other = (PlSqlOperatorBinding)obj;
        return this.toFullString().equals(other.toFullString());
    }

    public int hashCode() {
        return this.toFullString().hashCode();
    }
}

