/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class PlSqlProgram
extends SchemaObject {
    private static final Logger logger = Logger.getLogger(PlSqlProgram.class.getName());
    protected String source = this.getSource();

    public PlSqlProgram(Schema schema, String type, String name) throws SQLException {
        super(schema, type, name);
    }

    @Override
    public void prepareCreatePlan(Schema targetSchema) throws SQLException {
        if (this.source == null) {
            throw new RuntimeException("No source for " + this.id + " (" + this.getClass().getName() + ")");
        }
        this.createUpgradeStep(targetSchema, "create or replace " + this.source);
        targetSchema.add(this);
    }

    @Override
    public void prepareUpgradePlan(SchemaObject newVersion) throws SQLException {
        PlSqlProgram newProgram = (PlSqlProgram)newVersion;
        if (!this.source.equals(newProgram.source)) {
            this.source = newProgram.source;
            this.createUpgradeStep("create or replace " + this.source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSource() throws SQLException {
        StringBuffer buffer = new StringBuffer();
        String sql = "select text from all_source where owner = upper(?) and name = upper(?) and type = upper(?) order by line";
        PreparedStatement pstmt = this.schema.conn.prepareStatement(sql);
        try {
            int paramIdx = 1;
            pstmt.setString(paramIdx++, this.schema.username);
            pstmt.setString(paramIdx++, this.id.getName());
            pstmt.setString(paramIdx++, this.id.getType());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                buffer.append(rs.getString(1));
            }
        }
        finally {
            pstmt.close();
        }
        if (buffer.length() == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.schema.username + " could not find definition for " + this.id.getType() + ": " + this.schema.username + "." + this.id.getName() + ". Skipping...");
            }
            return null;
        }
        return buffer.toString();
    }
}

