/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.PlSqlLoader;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObjectId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class UpgradeStep {
    private static final Logger logger = Logger.getLogger(UpgradeStep.class.getName());
    private final SchemaObjectId dbObjectId;
    private Schema targetSchema;
    private String sql;
    private boolean done;

    public UpgradeStep(Schema targetSchema, SchemaObjectId dbObjectId, String sql) {
        this.dbObjectId = dbObjectId;
        this.targetSchema = targetSchema;
        this.sql = sql;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Upgrade step created for " + dbObjectId + ": " + sql);
            if (dbObjectId.getType().equals("FUNCTION") && dbObjectId.getName().equals("EXEC_FUNCB")) {
                logger.log(Level.FINEST, "...", new Exception());
            }
        }
    }

    public void perform() throws SQLException {
        if (this.done) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + " already done");
            }
            return;
        }
        this.targetSchema.executeSql(this.sql);
        PlSqlLoader.checkErrors(this.targetSchema.conn, this.targetSchema.username, this.dbObjectId.getName(), null);
        this.done = true;
    }

    private String getFirstLines(String s, int i) {
        String ls = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(s));
        try {
            String line = br.readLine();
            for (int ix = 0; ix < i && line != null; ++ix) {
                if (sb.length() > 0) {
                    sb.append(ls);
                }
                sb.append(line);
                line = br.readLine();
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getFirstLines(this.sql, 3) + "[...]";
    }
}

