/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.jcservcli;

import chemaxon.jchem.cartridge.rmi.JchemSearch;
import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

public class JchemSearchResultSRmiCli
implements TableScan {
    private static JCartLogger logger = JCartLogger.getLogger(JchemSearchResultSRmiCli.class);
    private JchemSearch remoteJcSearch = (JchemSearch)RmiDirectory.instance().getServer("JchemSearchServer");
    private Long id;

    public JchemSearchResultSRmiCli(SearchInfo searchInfo) throws UnknownHostException, IOException, Exception {
        try {
            this.id = this.remoteJcSearch.searchReturnSearchId(searchInfo);
        }
        catch (RemoteException re) {
            this.checkRemoteException(re);
            this.id = this.remoteJcSearch.searchReturnSearchId(searchInfo);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Constructed using " + this.remoteJcSearch);
        }
    }

    @Override
    public void dispose() throws RemoteException {
        try {
            this.remoteJcSearch.disposeSearch(this.id);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public int[] getNextHits() throws RemoteException {
        try {
            return this.remoteJcSearch.getNextHits(this.id);
        }
        catch (RemoteException re) {
            this.checkRemoteException(re);
            return this.remoteJcSearch.getNextHits(this.id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void checkRemoteException(RemoteException re) throws RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug("handleRemoteException: " + this.remoteJcSearch + ": " + re.toString());
        }
        if (re instanceof NoSuchObjectException && this.reInitRemoteJcSearch()) {
            return;
        }
        throw re;
    }

    private boolean reInitRemoteJcSearch() {
        if (logger.isInfoEnabled()) {
            logger.info("Trying to reinitialize remoteJcSearch...");
        }
        try {
            RmiDirectory.instance();
            RmiDirectory.clearRemoteRefCache();
            this.remoteJcSearch = (JchemSearch)RmiDirectory.instance().getServer("JchemSearchServer");
            if (logger.isInfoEnabled()) {
                logger.info("remoteJcSearch reinitialized.");
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getMemoryUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getSearchId() throws RemoteException {
        return this.id;
    }
}

