/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.jcservcli;

import chemaxon.jchem.cartridge.Debug;
import chemaxon.jchem.cartridge.batch.BatchInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResponseReader
implements Debug {
    private static final JCartLogger logger = JCartLogger.getLogger(ResponseReader.class);
    public static final int MAX_ERRMSG_LEN = 400;
    private static final ByteArrayOutputStream rxBuffer = new ByteArrayOutputStream(102400);
    private InputStream in;
    private boolean lastByteValid = false;
    private byte lastByte;
    private byte[] tmpBuffer = new byte[4096000];
    private ByteArrayOutputStream backupBuffer = new ByteArrayOutputStream(400);

    public ResponseReader(InputStream in) {
        if (logger.isDebugEnabled()) {
            logger.debug("constructor called");
        }
        this.in = in;
    }

    public void read() throws Exception {
        this.read(Integer.MAX_VALUE);
    }

    public void read(int nrRequestedBytes) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("nrRequestedBytes=" + nrRequestedBytes);
        }
        if (nrRequestedBytes < 0) {
            throw new IllegalArgumentException("nrRequestedBytes must be greater than or equal to 0");
        }
        rxBuffer.reset();
        if (this.in == null) {
            return;
        }
        while (rxBuffer.size() < nrRequestedBytes) {
            int extraByte = this.lastByteValid ? 0 : 1;
            int toBuffer = Math.min(this.tmpBuffer.length, nrRequestedBytes - rxBuffer.size() + extraByte);
            int r = this.in.read(this.tmpBuffer, 0, toBuffer);
            if (logger.isDebugEnabled()) {
                logger.debug("read count=" + r);
            }
            if (r == 0) continue;
            if (r == -1) {
                try {
                    this.in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.in = null;
                this.checkForException();
                break;
            }
            if (this.lastByteValid) {
                rxBuffer.write(this.lastByte);
            }
            this.lastByteValid = true;
            rxBuffer.write(this.tmpBuffer, 0, r - 1);
            this.lastByte = this.tmpBuffer[r - 1];
            this.backupBytes(r);
        }
    }

    protected void backupBytes(int r) {
        byte[] oldBytes = this.backupBuffer.toByteArray();
        this.backupBuffer.reset();
        int fromNewLen = Math.min(r, 400);
        int fromOldLen = Math.min(oldBytes.length, 400 - fromNewLen);
        if (fromOldLen > 0) {
            int oldStartIdx = oldBytes.length - fromOldLen;
            this.backupBuffer.write(oldBytes, oldStartIdx, fromOldLen);
        }
        this.backupBuffer.write(this.tmpBuffer, 0, fromNewLen);
    }

    protected void processBatchReceiveBuffer(BatchInfo batchInfo) throws Exception {
        if (batchInfo != null && batchInfo.getResultProcessor() != null) {
            byte[] b = rxBuffer.toByteArray();
            batchInfo.getResultProcessor().process(b);
            rxBuffer.reset();
        }
    }

    private void checkForException() throws Exception {
        int errMsgLength;
        if (this.lastByte == 0) {
            return;
        }
        byte[] msg = this.backupBuffer.toByteArray();
        String errorString = new String(msg, msg.length - (errMsgLength = Math.min(400, msg.length)), errMsgLength);
        if (errorString != null) {
            throw new Exception("The following exception has been thrown in JChemServer:\n" + errorString);
        }
    }

    protected ByteArrayOutputStream getRxBuffer() {
        if (logger.isDebugEnabled()) {
            logger.debug("returning rxBuffer containing " + rxBuffer.size());
        }
        return rxBuffer;
    }

    public void cleanup() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

