/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.jctable;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ColumnTypeHandler {
    private static JCartLogger logger = JCartLogger.getLogger(ColumnTypeHandler.class);
    private String tableName;
    private String jchemPropTableName;
    private boolean jchemTable;
    private String tableValidity;
    private Map colTypes = new HashMap();
    private static Hashtable colTypeCache = new Hashtable();

    private ColumnTypeHandler(String tableName, String jchemPropTableName, boolean jchemTable) {
        this.tableName = tableName;
        this.jchemPropTableName = jchemPropTableName;
        this.jchemTable = jchemTable;
    }

    private void checkCacheValidity(DbSession dbSession) throws Exception {
        String currTableValidity = new JcMetaDataFunctions(dbSession).getJChemPropertyForIndex(this.jchemPropTableName, this.tableName, this.jchemTable, "validityTimestamp");
        if (logger.isDebugEnabled()) {
            logger.debug("checkCacheValidity: tableValidity=" + this.tableValidity + ", currTableValidity=" + currTableValidity);
        }
        if (this.tableValidity == null || !this.tableValidity.equals(currTableValidity)) {
            this.colTypes.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("colTypes cleared");
            }
            this.tableValidity = currTableValidity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getColumnType(DbSession dbSession, String colName) throws Exception {
        Integer colType;
        this.checkCacheValidity(dbSession);
        if (this.colTypes.size() == 0) {
            ResultSet rs = null;
            String sql = "SELECT * FROM " + this.tableName + " WHERE 1 = 2";
            if (logger.isDebugEnabled()) {
                logger.debug("getColumnType: Executing \"" + sql + "\"...");
            }
            Statement stmt = dbSession.getConnection().createStatement();
            try {
                rs = stmt.executeQuery(sql);
                ResultSetMetaData rsMetaData = rs.getMetaData();
                int colCount = rsMetaData.getColumnCount();
                for (int ix = 0; ix < colCount; ++ix) {
                    String name = rsMetaData.getColumnName(ix + 1);
                    Integer type = new Integer(rsMetaData.getColumnType(ix + 1));
                    this.colTypes.put(name, type);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("column '" + name + "' of type " + type);
                }
            }
            finally {
                stmt.close();
            }
        }
        if ((colType = (Integer)this.colTypes.get(colName.toUpperCase())) == null) {
            throw new IllegalArgumentException("Column " + colName + " has no type info.");
        }
        return colType;
    }

    public synchronized String getJchemPropTableName() {
        return this.jchemPropTableName;
    }

    public void setValue(DbSession dbSession, String colName, String stringValue, PreparedStatement ps, int paramIdx) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("setValue: colName=" + colName + ", stringValue=" + stringValue);
        }
        int targetType = this.getColumnType(dbSession, colName);
        if (stringValue == null) {
            ps.setNull(paramIdx, targetType);
            return;
        }
        String oraDataType = null;
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                ps.setString(paramIdx, stringValue);
                return;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(paramIdx, new BigDecimal(stringValue));
                return;
            }
            case -7: {
                ps.setBoolean(paramIdx, stringValue != null && stringValue.equalsIgnoreCase("true"));
                return;
            }
            case -6: {
                ps.setByte(paramIdx, Byte.parseByte(stringValue));
                return;
            }
            case 5: {
                ps.setShort(paramIdx, Short.parseShort(stringValue));
                return;
            }
            case 4: {
                ps.setInt(paramIdx, Integer.parseInt(stringValue));
                return;
            }
            case -5: {
                ps.setLong(paramIdx, Long.parseLong(stringValue));
                return;
            }
            case 7: {
                ps.setFloat(paramIdx, Float.parseFloat(stringValue));
                return;
            }
            case 6: 
            case 8: {
                ps.setDouble(paramIdx, Double.parseDouble(stringValue));
                return;
            }
            case -3: 
            case -2: {
                oraDataType = "RAW";
                break;
            }
            case -4: {
                oraDataType = "LONGRAW";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                oraDataType = "DATE";
                break;
            }
            case 2004: {
                oraDataType = "BLOB";
                break;
            }
            case 2005: {
                oraDataType = "CLOB";
                break;
            }
            default: {
                throw new IllegalArgumentException("Obscure, unsupported JDBC type for user defined column (" + colName + "): " + targetType);
            }
        }
        throw new Exception("Unsupported type for user defined column (" + colName + "): " + oraDataType);
    }

    private String getValue(DbSession dbSession, String colName, ResultSet rs, int paramIdx) throws Exception {
        int targetType = this.getColumnType(dbSession, colName);
        String oraDataType = null;
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return rs.getString(1);
            }
            case 2: 
            case 3: {
                BigDecimal v = rs.getBigDecimal(paramIdx);
                if (v == null) {
                    return null;
                }
                return String.valueOf(v);
            }
            case -7: {
                return String.valueOf(rs.getBoolean(paramIdx));
            }
            case -6: {
                return String.valueOf(rs.getByte(paramIdx));
            }
            case 5: {
                return String.valueOf(rs.getShort(paramIdx));
            }
            case 4: {
                return String.valueOf(rs.getInt(paramIdx));
            }
            case -5: {
                return String.valueOf(rs.getLong(paramIdx));
            }
            case 7: {
                return String.valueOf(rs.getFloat(paramIdx));
            }
            case 6: 
            case 8: {
                return String.valueOf(rs.getDouble(paramIdx));
            }
            case -3: 
            case -2: {
                oraDataType = "RAW";
                break;
            }
            case -4: {
                oraDataType = "LONGRAW";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                oraDataType = "DATE";
                break;
            }
            case 2004: {
                oraDataType = "BLOB";
                break;
            }
            case 2005: {
                oraDataType = "CLOB";
                break;
            }
            default: {
                throw new IllegalArgumentException("Obscure, unsupported JDBC type for user defined column (" + colName + "): " + targetType);
            }
        }
        throw new Exception("Unsupported type for user defined column (" + colName + "): " + oraDataType);
    }

    private static ColumnTypeHandler getColumnTypeHandler(DbSession dbSession, String idxTableQName, String jcptName, boolean jchemTable) {
        ColumnTypeHandler userDefColCache = (ColumnTypeHandler)colTypeCache.get(idxTableQName);
        if (userDefColCache == null) {
            userDefColCache = new ColumnTypeHandler(idxTableQName, jcptName, jchemTable);
            colTypeCache.put(idxTableQName, userDefColCache);
        } else {
            String cachedJcpTabName = userDefColCache.getJchemPropTableName();
            if (!cachedJcpTabName.equals(jcptName)) {
                userDefColCache = new ColumnTypeHandler(idxTableQName, jcptName, jchemTable);
                colTypeCache.put(idxTableQName, userDefColCache);
            }
        }
        return userDefColCache;
    }

    public static void setValue(DbSession dbSession, String idxTableQName, String jcptName, boolean jchemTable, String colName, String stringValue, PreparedStatement ps, int paramIdx) throws Exception {
        ColumnTypeHandler.getColumnTypeHandler(dbSession, idxTableQName, jcptName, jchemTable).setValue(dbSession, colName, stringValue, ps, paramIdx);
    }

    public static String getValue(DbSession dbSession, String idxTableQName, String jcptName, boolean jchemTable, String colName, ResultSet rs, int paramIdx) throws Exception {
        return ColumnTypeHandler.getColumnTypeHandler(dbSession, idxTableQName, jcptName, jchemTable).getValue(dbSession, colName, rs, paramIdx);
    }
}

