/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.ScanContext;
import chemaxon.jchem.cartridge.rmi.ErrorCache;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.tunnel.search.ErrorRecord;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.sql.ARRAY;
import oracle.sql.STRUCT;

public class ErrorCacheSp {
    public static final String ERROR_RECORD_TYPE_NAME = "ERROR_RECORD";
    public static final String ERROR_RECORD_ARRAY_TYPE_NAME = "ERROR_RECORD_ARRAY";

    private static final String getSessionId() throws SQLException {
        return JavaStoredProcSession.instance().getJccSessionId();
    }

    public static String setCleanUpInterval(long cleanUpInterval) throws Exception {
        try {
            ErrorCacheSp.errorCache().setCleanUpInterval(cleanUpInterval);
            return null;
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ARRAY getErrors(Long scanId, int count) throws Exception {
        try {
            ArrayList<STRUCT> list = new ArrayList<STRUCT>();
            ErrorRecord[] errors = ErrorCacheSp.errorCache().getErrors(ErrorCacheSp.getSessionId(), scanId, count);
            try {
                for (int ix = 0; ix < errors.length; ++ix) {
                    if (scanId != null && errors[ix].getScanId() != scanId.longValue()) continue;
                    Object[] sqlObjectAttributes = ErrorCacheSp.getErrorAsAttributeArray(ScanContext.getScanContext(errors[ix].getScanId()), errors[ix]);
                    list.add(JFunctions.createSqlStruct(ERROR_RECORD_TYPE_NAME, sqlObjectAttributes));
                }
            }
            finally {
                ScanContext.closeOpenScanContexts();
            }
            Object[] structArray = list.toArray(new STRUCT[list.size()]);
            return JFunctions.convertToARRAY(structArray, ERROR_RECORD_ARRAY_TYPE_NAME);
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    private static Object[] getErrorAsAttributeArray(ScanContext scanContext, ErrorRecord errorRecord) throws SQLException {
        return new Object[]{scanContext == null ? null : new Long(scanContext.getScanId()), ErrorCacheSp.getRowid(scanContext, errorRecord), ErrorCacheSp.truncate(errorRecord.getErrorMessage()), ErrorCacheSp.truncate(errorRecord.getNote())};
    }

    public static String truncate(String s) {
        if (s == null) {
            return null;
        }
        return s.substring(0, Math.min(s.length(), Short.MAX_VALUE));
    }

    private static String getRowid(ScanContext scanContext, ErrorRecord errorRecord) throws SQLException {
        if (scanContext == null) {
            return null;
        }
        if (errorRecord.getRowid() != null) {
            return errorRecord.getRowid();
        }
        if (errorRecord.getCdId() == 0) {
            return null;
        }
        return scanContext.retrieveRowid(errorRecord.getCdId());
    }

    public static String getErrorCount(int[] errorCount) throws Exception {
        try {
            int cnt;
            errorCount[0] = cnt = ErrorCacheSp.errorCache().getErrorCount(ErrorCacheSp.getSessionId());
            return null;
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    public static String clearCache() throws Exception {
        try {
            ErrorCacheSp.errorCache().clearCache(ErrorCacheSp.getSessionId());
            return null;
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    public static String setErrorRecordExpirationTime(long expirationTime) throws Exception {
        try {
            ErrorCacheSp.errorCache().setErrorRecordExpirationTime(ErrorCacheSp.getSessionId(), expirationTime);
            return null;
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    public static String setEmptySessionErrorsExpirationTime(long emptySessionErrorsExpirationTime) throws Exception {
        try {
            ErrorCacheSp.errorCache().setEmptySessionErrorsExpirationTime(ErrorCacheSp.getSessionId(), emptySessionErrorsExpirationTime);
            return null;
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    public static String setRemoveRecordsOnAccess(int removeRecordsOnAccess) throws Exception {
        try {
            ErrorCacheSp.errorCache().setRemoveRecordsOnAccess(ErrorCacheSp.getSessionId(), removeRecordsOnAccess != 0);
            return null;
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    private static ErrorCache errorCache() throws Exception {
        return (ErrorCache)RmiDirectory.instance().getServer("ErrorCache");
    }
}

