/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.rmi.Admin;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.ArrayList;
import java.util.Map;
import oracle.sql.ARRAY;
import oracle.sql.STRUCT;

public class LicenseType
implements SQLData {
    private static final String LICENSETYPE_TYPE_NAME = "LICENSE_RECORD";
    private static final String LICENSETYPE_TABLE_TYPE_NAME = "LICENSE_TABLE";
    private String software;
    private String license_term;
    private String licensee;
    private String licensed_unit_count;
    private String expiration_date;
    private String support_expiration_date;
    private String license_comment;
    private String restrictions;
    private String sql_type;

    private static STRUCT convertToStruct(LicenseType lt) throws Exception {
        return JFunctions.createSqlStruct(LICENSETYPE_TYPE_NAME, new Object[]{lt.software, lt.license_term, lt.licensee, lt.licensed_unit_count, lt.expiration_date, lt.support_expiration_date, lt.license_comment, lt.restrictions});
    }

    private static LicenseType[] convertFromHandler(ArrayList licenses) {
        if (licenses == null) {
            return null;
        }
        LicenseType[] licenseType = new LicenseType[licenses.size()];
        for (int i = 0; i < licenses.size(); ++i) {
            Map licenseRow = (Map)licenses.get(i);
            licenseType[i] = new LicenseType();
            licenseType[i].software = (String)licenseRow.get("Software");
            licenseType[i].license_term = (String)licenseRow.get("License Term");
            licenseType[i].licensee = (String)licenseRow.get("Licensee");
            licenseType[i].licensed_unit_count = (String)licenseRow.get("Number of users");
            licenseType[i].expiration_date = (String)licenseRow.get("Expiration Date");
            licenseType[i].support_expiration_date = (String)licenseRow.get("Support Expiration Date");
            licenseType[i].license_comment = (String)licenseRow.get("Comment");
            licenseType[i].restrictions = (String)licenseRow.get("Restrictions");
        }
        return licenseType;
    }

    public static LicenseType[] getLicensesByType() throws Exception {
        Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
        return LicenseType.convertFromHandler(admin.getLicenses(null, null).licenseMapList);
    }

    public static ARRAY getLicenses() throws Exception {
        if (!JavaStoredProcSession.getCurrent().getJccOwner().equals(JavaStoredProcSession.getCurrent().getRealUser())) {
            throw new Exception("Only the JChem Cartridge owner will be allowed to use this function.");
        }
        LicenseType[] lt = LicenseType.getLicensesByType();
        Object[] structArray = new STRUCT[lt.length];
        for (int i = 0; i < lt.length; ++i) {
            structArray[i] = LicenseType.convertToStruct(lt[i]);
        }
        return JFunctions.convertToARRAY(structArray, LICENSETYPE_TABLE_TYPE_NAME);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.sql_type;
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.sql_type = typeName;
        this.software = stream.readString();
        this.license_term = stream.readString();
        this.licensee = stream.readString();
        this.licensed_unit_count = stream.readString();
        this.expiration_date = stream.readString();
        this.support_expiration_date = stream.readString();
        this.license_comment = stream.readString();
        this.restrictions = stream.readString();
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeString(this.software);
        stream.writeString(this.license_term);
        stream.writeString(this.licensee);
        stream.writeString(this.licensed_unit_count);
        stream.writeString(this.expiration_date);
        stream.writeString(this.support_expiration_date);
        stream.writeString(this.license_comment);
        stream.writeString(this.restrictions);
    }
}

