/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.dml;

import chemaxon.jchem.cartridge.ColumnDescriptor;
import chemaxon.jchem.cartridge.IndexTableStruct;
import chemaxon.jchem.cartridge.JCFunctionsBlob;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.oresident.dml.IndexTableDmlBase;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.InsertRespData;
import java.util.List;

public class MarkushIndexTableDml
extends IndexTableDmlBase {
    public MarkushIndexTableDml(DbSession dbSession, JCartIndexDescriptor idxDescriptor) {
        super(dbSession, idxDescriptor);
    }

    @Override
    public int insert(InsertRespData responseData, String rowid) throws Exception {
        int cdId = super.insert(responseData, rowid);
        if (responseData.markushData != null) {
            if (this.idxDescriptor.isJChemTable()) {
                JCFunctionsBlob.loadBlobContent(this.idxDescriptor.getIdxTableQName(), "cd_markush", responseData.markushData, cdId);
            } else {
                JCFunctionsBlob.loadBlobContent(this.idxDescriptor.getIdxTableQName(), "cd_markush", responseData.markushData, rowid);
            }
        }
        return cdId;
    }

    @Override
    protected void update(InsertRespData responseData, String rowid, int cdId) throws Exception {
        super.update(responseData, rowid, cdId);
        if (responseData.markushData != null) {
            if (rowid == null) {
                JCFunctionsBlob.loadBlobContent(this.idxDescriptor.getIdxTableQName(), "cd_markush", responseData.markushData, cdId);
            } else {
                JCFunctionsBlob.loadBlobContent(this.idxDescriptor.getIdxTableQName(), "cd_markush", responseData.markushData, rowid);
            }
        }
    }

    @Override
    protected List getSqlValueList(InsertRespData responseData, List sqlColumnList) throws Exception {
        List valueList = super.getSqlValueList(responseData, sqlColumnList);
        if (responseData.markushData == null) {
            String cdMarkushColName = "CD_MARKUSH";
            int cdMarkushColIdx = sqlColumnList.indexOf("CD_MARKUSH");
            if (cdMarkushColIdx == -1) {
                throw new IllegalStateException("No such column in SQL column list: CD_MARKUSH");
            }
            valueList.set(cdMarkushColIdx, "null");
        }
        return valueList;
    }

    @Override
    protected ColumnDescriptor[] getMiscColDefs() {
        return IndexTableStruct.getMiscColumnDefs(3);
    }
}

