/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.longop;

import chemaxon.jchem.cartridge.oresident.longop.LongOp;
import chemaxon.jchem.cartridge.oresident.longop.LongOpOracleParams;
import java.sql.Connection;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LongOpStatus {
    private static final Logger logger = Logger.getLogger(LongOpStatus.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateStatus(LongOp longOp, LongOpOracleParams oracleParams) throws Exception {
        boolean ended = longOp.waitForRefresh();
        if (oracleParams.getRindex() != null && oracleParams.getRindex().longValue() == 0L && oracleParams.getSlno() != null && oracleParams.getSlno().longValue() == 0L) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Rindex and slno are set to 0, so no further information is sent to longops. Id: " + longOp.getId() + ".");
            }
        } else {
            Statement cs = null;
            Connection conn = longOp.getConnection();
            try {
                String sql = "{call DBMS_APPLICATION_INFO.SET_SESSION_LONGOPS(rindex => ?,slno => ?,op_name => '" + longOp.getOpName() + "', sofar => ?, totalwork => ? , context => ?, " + "target_desc => '" + longOp.getTarget() + "', units => 'rows processed')}";
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Longop start");
                }
                int sofar = longOp.getSofar();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Changing longop values: sofar=" + sofar + ".");
                }
                int totalwork = longOp.getTotalWork();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Changing longop values: totalwork=" + totalwork + ".");
                }
                cs = conn.prepareCall(sql);
                cs.registerOutParameter(1, 2);
                cs.registerOutParameter(2, 2);
                cs.setInt(3, sofar);
                cs.setInt(4, totalwork);
                cs.setLong(5, longOp.getId());
                if (oracleParams.getRindex() == null) {
                    cs.setNull(1, 4);
                } else {
                    cs.setInt(1, oracleParams.getRindex());
                }
                if (oracleParams.getSlno() == null) {
                    cs.setNull(2, 4);
                } else {
                    cs.setInt(2, oracleParams.getSlno());
                }
                cs.execute();
                oracleParams.setRindex(new Integer(cs.getInt(1)));
                if (cs.wasNull()) {
                    oracleParams.setRindex(null);
                }
                oracleParams.setSlno(new Integer(cs.getInt(2)));
                if (cs.wasNull()) {
                    oracleParams.setSlno(null);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Returned longop function");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cs.close();
            }
        }
        if (ended) {
            longOp.dispose();
        }
        return ended;
    }
}

