/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.nonidxscan;

import chemaxon.jchem.cartridge.IndexTableStruct;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.jctable.ColumnTypeHandler;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.structs.MdMetaDataSupport;
import chemaxon.jchem.cartridge.tunnel.search.MdScreenParams;
import chemaxon.jchem.cartridge.tunnel.search.ScreenParams;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.jdbc.OracleResultSet;

public class IdxBasedTarget {
    private static final JCartLogger logger = JCartLogger.getLogger(IdxBasedTarget.class);
    private JCartIndexDescriptor jccIdxDesc;
    private byte[] originalTarget;
    private String rid;
    private String rowidColName;
    private byte[] target = JccConfigConstants.UNINITIALIZED_BYTEARRAY;
    private boolean targetFromIndex = true;
    private int structureType;

    public IdxBasedTarget(JCartIndexDescriptor jccIdxDesc, byte[] originalTarget, String rid) throws Exception {
        this.jccIdxDesc = jccIdxDesc;
        this.originalTarget = originalTarget;
        this.rid = rid;
        this.rowidColName = jccIdxDesc.isJChemTable() ? "rowid" : "rid";
        this.structureType = this.getJccIdxDesc().getTableType();
    }

    public JCartIndexDescriptor getJccIdxDesc() {
        return this.jccIdxDesc;
    }

    public byte[] getOriginalTarget() {
        return this.originalTarget;
    }

    public String getRid() {
        return this.rid;
    }

    public byte[] getTarget() throws Exception {
        if (this.target == JccConfigConstants.UNINITIALIZED_BYTEARRAY) {
            this.target = this.getRealTarget();
        }
        return this.target;
    }

    public boolean isTargetFromIndex() throws Exception {
        this.getTarget();
        if (logger.isDebugEnabled()) {
            logger.debug("targetFromIndex=" + this.targetFromIndex);
        }
        return this.targetFromIndex;
    }

    private byte[] getRealTarget() throws Exception {
        boolean legacyJChem;
        int tableType = this.jccIdxDesc.getTableType();
        String internalStructColName = this.getMiscColName(tableType, 0);
        boolean bl = legacyJChem = this.jccIdxDesc.isJChemTable() && this.jccIdxDesc.getColName().equals(internalStructColName);
        if (logger.isDebugEnabled()) {
            logger.debug("jccIdxDesc.getColName()=" + this.jccIdxDesc.getColName() + ", internalStructColName=" + internalStructColName);
        }
        if (legacyJChem) {
            if (this.originalTarget == null) {
                byte[] struc = this.getColByRowid("cd_structure");
                if (struc == null) {
                    this.target = null;
                } else {
                    this.targetFromIndex = false;
                    this.originalTarget = struc;
                }
            } else {
                this.target = (byte[])(this.originalTarget.equals(" ") ? null : this.originalTarget);
            }
        } else if (this.originalTarget == null) {
            this.target = null;
        } else if (this.rid != null) {
            byte[] internalStruct = this.getColByRowid(internalStructColName);
            if (internalStruct == null && tableType == 3 && (internalStruct = this.getColByRowid(this.getMiscColName(tableType, 1))) != null) {
                this.structureType = 2;
            }
            if (internalStruct == null) {
                this.target = this.originalTarget;
                this.targetFromIndex = false;
            } else if (internalStruct.length == 0 || JFunctions.isSpace(internalStruct)) {
                this.target = null;
                this.targetFromIndex = false;
            } else {
                this.target = internalStruct;
            }
        }
        return this.target;
    }

    private String getMiscColName(int tableType, int i) {
        return IndexTableStruct.getMiscColumnDefs((int)tableType)[i].colName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getColByRowid(String colName) throws Exception {
        byte[] byArray;
        if (this.jccIdxDesc.getTableType() == 4) {
            return null;
        }
        String sql = "SELECT " + colName + " FROM " + this.jccIdxDesc.getIdxTableQName() + " WHERE " + this.rowidColName + " = ?";
        if (logger.isDebugEnabled()) {
            logger.debug("getColByRowid: " + sql);
        }
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            ps.setString(1, this.rid);
            rset = ps.executeQuery();
            rset.next();
            byte[] o = JFunctions.readBytes(rset, 1);
            if (logger.isDebugEnabled()) {
                logger.debug("getColByRowid: returning=" + o);
            }
            byArray = o;
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, ps);
            ps = null;
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        ps = null;
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getFingerprintsFromTable() throws Exception {
        int[] fpProps = this.getJccIdxDesc().getFingerPrintProps();
        int[] fp_t = new int[fpProps[0] / 32];
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SELECT ");
        for (int i = 0; i < fp_t.length; ++i) {
            if (i > 0) {
                sbuf.append(",");
            }
            sbuf.append("cd_fp" + (i + 1));
        }
        sbuf.append(" FROM ");
        sbuf.append(this.getJccIdxDesc().getIdxTableQName());
        sbuf.append(" WHERE " + this.rowidColName + " = ?");
        OracleResultSet rset = null;
        PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sbuf.toString());
        try {
            ps.setString(1, this.rid);
            rset = (OracleResultSet)ps.executeQuery();
            rset.next();
            for (int i = 0; i < fp_t.length; ++i) {
                fp_t[i] = rset.getInt(i + 1);
            }
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close((ResultSet)rset, ps);
            rset = null;
            ps = null;
            throw throwable;
        }
        JavaStoredProcSession.instance().close((ResultSet)rset, ps);
        rset = null;
        ps = null;
        return fp_t;
    }

    public byte[] getMdFingerprintsFromTable(CxOptions cxOptions) throws Exception {
        StringBuffer sqlBuffer;
        block3: {
            byte[] byArray;
            String molDescName = cxOptions.getStringValue("descriptorName");
            String mdTableName = MdMetaDataSupport.getMdTableNameByMdName(this.getJccIdxDesc().getAllMdMetaData(), molDescName);
            String idxTblQName = this.getJccIdxDesc().getIdxTableQName();
            sqlBuffer = new StringBuffer("");
            sqlBuffer.append("SELECT ").append(mdTableName).append(".MD_DATA FROM ");
            sqlBuffer.append(idxTblQName).append(", ").append(mdTableName);
            sqlBuffer.append(" WHERE ").append(idxTblQName).append(".").append(this.rowidColName).append("=?");
            sqlBuffer.append(" AND ").append(idxTblQName).append(".CD_ID=");
            sqlBuffer.append(mdTableName).append(".CD_ID");
            ResultSet rs = null;
            PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sqlBuffer.toString());
            try {
                ps.setString(1, this.rid);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                byArray = JFunctions.readBytes(rs, 1);
            }
            catch (Throwable throwable) {
                JavaStoredProcSession.instance().close(rs, ps);
                throw throwable;
            }
            JavaStoredProcSession.instance().close(rs, ps);
            return byArray;
        }
        throw new RuntimeException("No match for " + sqlBuffer + " with " + this.rowidColName + " = " + this.rid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChemTermValue(String chemTermColumnName) throws Exception {
        String ctValue = null;
        String sql = "SELECT " + chemTermColumnName + " FROM " + this.getJccIdxDesc().getIdxTableQName() + " WHERE " + this.rowidColName + " = ?";
        ResultSet rs = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            pstmt.setString(1, this.rid);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new IllegalArgumentException("No ROWID in " + this.getJccIdxDesc().getIdxTableQName() + "." + this.rowidColName + ": " + this.rid);
            }
            ctValue = ColumnTypeHandler.getValue(JavaStoredProcSession.instance(), this.getJccIdxDesc().getIdxTableQName(), this.getJccIdxDesc().getJcptName(), this.getJccIdxDesc().isJChemTable(), chemTermColumnName, rs, 1);
            if (rs.next()) {
                throw new IllegalArgumentException("Too many ROWIDs in " + this.getJccIdxDesc().getIdxTableQName() + "." + this.rowidColName + ": " + this.rid);
            }
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rs, pstmt);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rs, pstmt);
        return ctValue;
    }

    public ScreenParams getSceenParams(CxOptions cxOptions) throws Exception {
        MdScreenParams mdScreenParams = MdMetaDataSupport.getMdScreenParams(this.getJccIdxDesc(), cxOptions);
        byte[] targetMdData = this.getMdFingerprintsFromTable(cxOptions);
        return new ScreenParams(targetMdData, mdScreenParams);
    }

    public int getStructureType() throws Exception {
        this.getTarget();
        return this.structureType;
    }
}

