/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.nonidxscan;

import chemaxon.jchem.cartridge.Indexing;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.oresident.nonidxscan.IdxBasedTarget;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisOperationBase;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.Miscellanious;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JChemProperties;
import chemaxon.jchem.cartridge.util.JCartLogger;
import chemaxon.jchem.interop.InteropOptions;

public class NisDissimilarity
extends NisOperationBase {
    private static final JCartLogger logger = JCartLogger.getLogger(NisDissimilarity.class);
    protected double dissimThreshold = -1.0;
    private boolean diss;

    protected String getReturnValue(double dissim) throws Exception {
        String retval = this.dissimThreshold == -1.0 ? String.valueOf(this.diss ? dissim : 1.0 - dissim) : String.valueOf((this.diss ? dissim : 1.0 - dissim) <= this.dissimThreshold ? 1 : 0);
        if (logger.isDebugEnabled()) {
            logger.debug("getReturnValue: diss=" + this.diss + ", dissimThreshold=" + this.dissimThreshold + ", dissim=" + dissim + ", retval=" + retval);
        }
        return retval;
    }

    @Override
    public Object execute(JChemProperties jcp, byte[] target, byte[] query) throws Exception {
        int structureType = -1;
        int[] fpProps = null;
        int[] targetFp = null;
        String standardizerConfig = jcp.getStandardizerConfig();
        int idxSubType = Indexing.getIdxSubType(this.cxOptions);
        if (idxSubType == 1) {
            structureType = 10000;
        } else {
            structureType = NisDissimilarity.getStructureType(this.cxOptions, false);
            fpProps = jcp.getFingerPrintProps();
            if (fpProps == null) {
                fpProps = new int[]{-1, -1, -1};
            }
        }
        Miscellanious m = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
        double dissim = m.getChemFpDissimilarity(structureType, targetFp, target, true, query, fpProps, standardizerConfig, this.cxOptions.getStringValue("dissimilarityMetric"));
        String obj = this.getReturnValue(dissim);
        if (logger.isDebugEnabled()) {
            logger.debug("getSimilarityValue returning " + obj);
        }
        return obj;
    }

    @Override
    public Object execute(IdxBasedTarget target, byte[] query) throws Exception {
        int structureType = -1;
        byte[] origTarget = null;
        int[] fpProps = null;
        int[] targetFp = null;
        String standardizerConfig = null;
        int idxSubType = target.getJccIdxDesc().getIdxSubType();
        if (idxSubType == 1) {
            structureType = 10000;
            origTarget = target.getOriginalTarget();
            if (origTarget == null) {
                return null;
            }
        } else {
            structureType = target.getJccIdxDesc().getTableType();
            fpProps = target.getJccIdxDesc().getFingerPrintProps();
            targetFp = target.getFingerprintsFromTable();
            standardizerConfig = target.getJccIdxDesc().getStandardizerConfig();
        }
        Miscellanious m = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
        if (logger.isDebugEnabled()) {
            logger.debug("m=" + m + ", query=" + JFunctions.decodeDbString(query) + ", target=" + JFunctions.decodeDbString(origTarget) + ", cxOptions=" + this.cxOptions);
        }
        double dissim = m.getChemFpDissimilarity(structureType, targetFp, origTarget, false, query, fpProps, standardizerConfig, this.cxOptions.getStringValue("dissimilarityMetric"));
        String obj = this.getReturnValue(dissim);
        if (logger.isDebugEnabled()) {
            logger.debug("getSimilarityValue returning " + obj);
        }
        return obj;
    }

    public double getDissimThreshold() {
        return this.dissimThreshold;
    }

    public void setDissimThreshold(double dissimThreshold) {
        this.dissimThreshold = dissimThreshold;
    }

    @Override
    public void reset() {
        this.dissimThreshold = -1.0;
        this.diss = false;
    }

    public void setDiss(boolean diss) {
        this.diss = diss;
    }

    public static int getStructureType(CxOptions cxOptions, boolean remove) {
        if (cxOptions == null) {
            return 0;
        }
        String tableTypeString = cxOptions.getStringValue("structureType");
        if (tableTypeString == null) {
            return 0;
        }
        if (remove) {
            cxOptions.removeOption("structureType");
        }
        return InteropOptions.tableTypeStringToInt(tableTypeString);
    }
}

