/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.nonidxscan;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.oresident.nonidxscan.IdxBasedTarget;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisOperationBase;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NonIdxScanException;
import chemaxon.jchem.cartridge.rmi.Evaluator;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JChemProperties;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.SQLException;

public class NisEvaluate
extends NisOperationBase {
    private static final JCartLogger logger = JCartLogger.getLogger(NisEvaluate.class);
    public static final int RESULT_TYPE_NUMERIC = 0;
    public static final int RESULT_TYPE_STRING = 1;
    public static final int RESULT_TYPE_ARRAY = 2;
    private int resultType = 0;
    private String plainChemTerms;

    private Object execute(byte[] target, String chemTerms, String standardizerConfig) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("execute(non-idx-based): chemTerms=" + chemTerms + ", standardizerConfig=" + standardizerConfig + ", resultType=" + this.resultType);
        }
        Evaluator evaluator = (Evaluator)RmiDirectory.instance().getServer("EvaluatorServer");
        switch (this.resultType) {
            case 0: {
                return evaluator.evaluateToNumeric(target, standardizerConfig, chemTerms);
            }
            case 1: {
                return evaluator.evaluate(target, standardizerConfig, this.cxOptions.toString());
            }
            case 2: {
                return evaluator.evaluateToArray(target, standardizerConfig, this.cxOptions.toString());
            }
        }
        throw new IllegalArgumentException("Unexpected result type: " + this.resultType);
    }

    private String getChemTerms() {
        if (this.plainChemTerms == null) {
            return this.cxOptions.getStringValue("chemTerms");
        }
        return this.plainChemTerms;
    }

    @Override
    public Object execute(JChemProperties jcp, byte[] target, byte[] query) throws NonIdxScanException, SQLException {
        try {
            String chemTerms = this.getChemTerms();
            String standardizerConfig = jcp.getStandardizerConfig();
            return this.execute(target, chemTerms, standardizerConfig);
        }
        catch (Exception e) {
            logger.error(e);
            throw new NonIdxScanException(e);
        }
    }

    @Override
    public Object execute(IdxBasedTarget target, byte[] query) throws NonIdxScanException, SQLException {
        try {
            String chemTerms = this.getChemTerms();
            String ctColName = target.getJccIdxDesc().getChemTermColumn(chemTerms);
            if (ctColName == null) {
                return this.execute(target.getTarget(), chemTerms, target.getJccIdxDesc().getStandardizerConfig());
            }
            switch (this.resultType) {
                case 0: {
                    return target.getChemTermValue(ctColName);
                }
                case 1: {
                    String value = target.getChemTermValue(ctColName);
                    String outFormat = this.cxOptions.getStringValue("outFormat");
                    if (outFormat == null) {
                        return value;
                    }
                    return new String(JFunctions.molconvertToBytes(value.getBytes("US-ASCII"), null, outFormat, null), "US-ASCII");
                }
                case 2: {
                    throw new IllegalArgumentException("Auto calculated fields cannot currently be used with table functions");
                }
            }
            throw new IllegalArgumentException("Unexpected result type: " + this.resultType);
        }
        catch (Exception e) {
            logger.error(e);
            throw new NonIdxScanException(e);
        }
    }

    @Override
    public void reset() {
        this.resultType = 0;
        this.plainChemTerms = null;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public void setChemTerm(String chemTerm) {
        this.plainChemTerms = chemTerm;
    }
}

