/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.nonidxscan;

import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.nonidxscan.IdxBasedTarget;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisDissimilarity;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NonIdxScanException;
import chemaxon.jchem.cartridge.rmi.Miscellanious;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.structs.JChemProperties;
import chemaxon.jchem.cartridge.structs.MdMetaDataSupport;
import chemaxon.jchem.cartridge.tunnel.search.MdScreenParams;
import chemaxon.jchem.cartridge.tunnel.search.ScreenParams;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.SQLException;

public class NisMdDissimilarity
extends NisDissimilarity {
    private static final JCartLogger logger = JCartLogger.getLogger(NisMdDissimilarity.class);

    private Object execute(byte[] target, byte[] query, String stdrConfig, ScreenParams screenParams) throws Exception {
        Miscellanious misc = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
        double dissim = misc.getMdDissimilarity(target, query, stdrConfig, screenParams);
        return this.getReturnValue(dissim);
    }

    @Override
    public Object execute(JChemProperties jcp, byte[] target, byte[] query) throws NonIdxScanException, SQLException {
        try {
            JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get((DbSession)JavaStoredProcSession.instance(), this.cxOptions.getStringValue("idxName"));
            MdScreenParams mdScreenParams = MdMetaDataSupport.getMdScreenParams(idxDesc, this.cxOptions);
            return this.execute(target, query, jcp.getStandardizerConfig(), new ScreenParams(null, mdScreenParams));
        }
        catch (Throwable throwable) {
            logger.error(throwable);
            throw new NonIdxScanException(throwable);
        }
    }

    @Override
    public Object execute(IdxBasedTarget target, byte[] query) throws NonIdxScanException, SQLException {
        try {
            String standardizerConfig = target.getJccIdxDesc().getStandardizerConfig();
            ScreenParams screenParams = target.getSceenParams(this.cxOptions);
            return this.execute(null, query, standardizerConfig, screenParams);
        }
        catch (Exception e) {
            logger.error(e);
            throw new NonIdxScanException(e);
        }
    }
}

