/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.nonidxscan;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.oresident.nonidxscan.IdxBasedTarget;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisDissimilarity;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisOperationBase;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.Admin;
import chemaxon.jchem.cartridge.rmi.MolSearch;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JChemProperties;
import chemaxon.jchem.cartridge.tunnel.search.MolSearchParams;
import chemaxon.jchem.cartridge.tunnel.search.ScreenParams;
import chemaxon.jchem.cartridge.tunnel.search.SearchStandardizationParams;
import chemaxon.jchem.cartridge.tunnel.search.TautomerSearchParams;

public class NisStructureSearch
extends NisOperationBase {
    private int searchType = -1;
    private boolean reportMatchCount;
    private Boolean markushScreeningEnabledByDefault;

    @Override
    public Object execute(JChemProperties jp, byte[] target, byte[] query) throws Exception {
        if (target == null || query == null) {
            return "0";
        }
        int structureType = NisDissimilarity.getStructureType(this.cxOptions, true);
        boolean targetStdrNeeded = true;
        MolSearchParams molSearchInfo = this.createMolSearchInfo(structureType, query, target, targetStdrNeeded, jp, jp.isAbsoluteStereo(this.cxOptions), null);
        MolSearch molSearch = (MolSearch)RmiDirectory.instance().getServer("MolSearchServer");
        if (this.reportMatchCount) {
            return String.valueOf(molSearch.matchCount(molSearchInfo));
        }
        boolean matching = molSearch.search(molSearchInfo);
        return matching ? "1" : "0";
    }

    @Override
    public Object execute(IdxBasedTarget target, byte[] query) throws Exception {
        ScreenParams screenParams;
        boolean absoluteStereo;
        boolean targetStdrNeeded;
        int structureType;
        block6: {
            if (target.getTarget() == null || query == null) {
                return "0";
            }
            structureType = target.getStructureType();
            targetStdrNeeded = false;
            absoluteStereo = target.getJccIdxDesc().isAbsoluteStereo(this.cxOptions);
            if (!target.isTargetFromIndex()) {
                targetStdrNeeded = true;
                byte[] cdFlags = target.getColByRowid("cd_flags");
                absoluteStereo = cdFlags != null && JFunctions.decodeDbString(cdFlags).indexOf(99) != -1;
            }
            screenParams = null;
            if (structureType == 3 && this.doMarkushScreen(this.cxOptions)) {
                this.cxOptions.setOptionValue("descriptorName", "MSCR");
                try {
                    screenParams = target.getSceenParams(this.cxOptions);
                }
                catch (IllegalArgumentException iae) {
                    if (iae.getMessage().indexOf("MSCR") != -1) break block6;
                    throw iae;
                }
            }
        }
        MolSearchParams molSearchInfo = this.createMolSearchInfo(structureType, query, target.getTarget(), targetStdrNeeded, target.getJccIdxDesc(), absoluteStereo, screenParams);
        MolSearch molSearch = (MolSearch)RmiDirectory.instance().getServer("MolSearchServer");
        if (this.reportMatchCount) {
            return String.valueOf(molSearch.matchCount(molSearchInfo));
        }
        boolean matching = molSearch.search(molSearchInfo);
        return matching ? "1" : "0";
    }

    private boolean doMarkushScreen(CxOptions cxOptions) throws Exception {
        return cxOptions.getBoolValue("markushScreening", this.isMarkushScreeningEnabled());
    }

    private boolean isMarkushScreeningEnabled() throws Exception {
        if (this.markushScreeningEnabledByDefault == null) {
            Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
            this.markushScreeningEnabledByDefault = new Boolean(admin.getProperty("markush.screening.enabled"));
        }
        return this.markushScreeningEnabledByDefault;
    }

    private MolSearchParams createMolSearchInfo(int structureType, byte[] query, byte[] target, boolean targetStdrNeeded, JChemProperties jp, boolean absoluteStereo, ScreenParams screenParams) throws Exception {
        String searchOptions = this.cxOptions == null ? null : this.cxOptions.toString();
        boolean queryStandardizationNeeded = true;
        return NisStructureSearch.createMolSearchInfo(this.searchType, searchOptions, queryStandardizationNeeded, absoluteStereo, structureType, query, target, targetStdrNeeded, jp, screenParams);
    }

    public static final MolSearchParams createMolSearchInfo(int searchType, String searchOptions, boolean queryStandardizationNeeded, boolean absoluteStereo, int structureType, byte[] query, byte[] target, boolean targetStdrNeeded, JChemProperties jp, ScreenParams screenParams) throws Exception {
        return new MolSearchParams(structureType, query, target, searchType, searchOptions, absoluteStereo, new SearchStandardizationParams(jp.getStandardizerConfig(), queryStandardizationNeeded, targetStdrNeeded), new TautomerSearchParams(jp.isTautomerDuplicateFiltering(), jp.isTautomerDuplicateFiltering(), jp.isProtectTautomerChirality(), jp.isSwitchOffAllProtectionsTdf()), screenParams);
    }

    public void setSearchType(int searchType) {
        this.searchType = searchType;
    }

    public void setReportMatchCount(boolean reportMatchCount) {
        this.reportMatchCount = reportMatchCount;
    }

    @Override
    public void reset() {
        this.searchType = -1;
        this.reportMatchCount = false;
    }
}

