/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.nonidxscan;

import chemaxon.jchem.cartridge.oresident.ScanContext;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisDissimilarity;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisEvaluate;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisMdDissimilarity;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisOperationBase;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisStructureSearch;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NonIdxScanException;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NonIdxScanOperation;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.IllegalOptionException;

public class NonIdxScanOperationFactory {
    private static NonIdxScanOperationFactory instance;

    public NonIdxScanOperation get(long scanId, String sqlOperator, String options) throws Exception {
        NisOperationBase operation = null;
        CxOptions cxOptions = null;
        if (!sqlOperator.equals("EVALUATE")) {
            try {
                ScanContext.SoftData softData;
                ScanContext sc = ScanContext.getScanContext(scanId);
                if (sc != null && (softData = sc.getSoftData()) != null) {
                    cxOptions = softData.getCxOptions();
                }
                if (cxOptions == null && options != null) {
                    cxOptions = this.getParseDoSearchOptions(options);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalOptionException(iae.getMessage());
            }
        }
        if (sqlOperator.equals("CONTAINS")) {
            operation = new NisStructureSearch();
            this.setSearchType(operation, 2);
        } else if (sqlOperator.equals("EQUALS")) {
            operation = new NisStructureSearch();
            this.setSearchType(operation, 5);
        } else if (sqlOperator.equals("MATCHCOUNT")) {
            operation = new NisStructureSearch();
            this.setSearchType(operation, 2);
            ((NisStructureSearch)operation).setReportMatchCount(true);
        } else if (sqlOperator.equals("COMPARE")) {
            operation = this.getGeneric(cxOptions);
        } else if (sqlOperator.equals("SIMILARITY") || sqlOperator.equals("TANIMOTO") || sqlOperator.equals("TVERSKY")) {
            operation = this.getDissimilarity(cxOptions, false);
        } else if (sqlOperator.equals("DISSIMILARITY")) {
            operation = this.getDissimilarity(cxOptions, true);
        } else if (sqlOperator.equals("EVALUATE")) {
            operation = new NisEvaluate();
            ((NisEvaluate)operation).setChemTerm(options);
        } else if (sqlOperator.equals("EVALUATE_X")) {
            operation = new NisEvaluate();
            this.setResultType(operation, 1);
        } else if (sqlOperator.equals("T_EVALUATE")) {
            operation = new NisEvaluate();
            this.setResultType(operation, 2);
        } else {
            throw new IllegalArgumentException("Unexpected operation type: " + sqlOperator);
        }
        operation.setCxOptions(cxOptions);
        return operation;
    }

    private void setResultType(NisOperationBase operation, int resultType) {
        ((NisEvaluate)operation).setResultType(resultType);
    }

    private void setSearchType(NisOperationBase operation, int substructure) {
        ((NisStructureSearch)operation).setSearchType(substructure);
    }

    private NisDissimilarity getDissimilarity(CxOptions cxOptions, boolean diss) {
        NisDissimilarity nisSimilarity = null;
        nisSimilarity = cxOptions != null && cxOptions.getStringValue("descriptorName") != null ? new NisMdDissimilarity() : new NisDissimilarity();
        nisSimilarity.setDiss(diss);
        return nisSimilarity;
    }

    private NisOperationBase getGeneric(CxOptions cxOptions) throws NonIdxScanException {
        NisOperationBase operation = new NisStructureSearch();
        String searchTypeOptionValue = cxOptions.getStringValue("t");
        operation = searchTypeOptionValue == null ? new NisStructureSearch() : ((searchTypeOptionValue = searchTypeOptionValue.toLowerCase()).equals("R") ? this.getSuperStructureSearchForGeneric(cxOptions) : (searchTypeOptionValue.equals("t") ? this.getDissimilarityForGeneric(cxOptions) : new NisStructureSearch()));
        return operation;
    }

    private NisOperationBase getSuperStructureSearchForGeneric(CxOptions cxOptions) throws NonIdxScanException {
        throw new NonIdxScanException("The 't:r' option for superstructure search can be used only for search in indexed tables. Use substructure search with inverted query and target arguments instead.");
    }

    private NisOperationBase getDissimilarityForGeneric(CxOptions cxOptions) {
        double dissimThreshold = this.getDissimThreshold(cxOptions);
        NisDissimilarity operation = this.getDissimilarity(cxOptions, true);
        operation.setDissimThreshold(dissimThreshold);
        return operation;
    }

    private double getDissimThreshold(CxOptions cxOptions) {
        String dissimThresholdValue = cxOptions.getStringValue("dissimilarityThreshold");
        if (dissimThresholdValue == null) {
            String simThresholdValue = cxOptions.getStringValue("simThreshold");
            if (simThresholdValue == null) {
                throw new IllegalArgumentException("'t:t' option requires either the 'simThreshold' or the 'dissimilarityThreshold' option");
            }
            return 1.0 - Double.parseDouble(simThresholdValue);
        }
        return Double.parseDouble(dissimThresholdValue);
    }

    private CxOptions getParseDoSearchOptions(String options) {
        CxOptions jcOptions = new CxOptions(options);
        if (jcOptions.getStringValue("CTFILTER") != null) {
            throw new IllegalArgumentException("To use chemical terms filter in non-scan access mode, use jc_evaluate");
        }
        if (jcOptions.getStringValue("QUERYFILTER:") != null) {
            throw new IllegalArgumentException("query filter cannot be used in non-scan access mode");
        }
        return jcOptions;
    }

    public void release(NonIdxScanOperation nisOperation) {
    }

    public static synchronized NonIdxScanOperationFactory instance() {
        if (instance == null) {
            instance = new NonIdxScanOperationFactory();
        }
        return instance;
    }
}

