/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.resultset;

import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.jcservcli.JchemSearchResultSRmiCli;
import chemaxon.jchem.cartridge.jcservcli.LocalPerfectSearchResult;
import chemaxon.jchem.cartridge.resultset.CdIdResultSet;
import chemaxon.jchem.cartridge.resultset.JCCartResultSet;
import chemaxon.jchem.cartridge.resultset.SearchExInfoSupport;
import chemaxon.jchem.cartridge.rmi.EvalTableScanner;
import chemaxon.jchem.cartridge.rmi.JchemSearch;
import chemaxon.jchem.cartridge.rmi.KilledTaskException;
import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;
import chemaxon.jchem.cartridge.tunnel.TableScanInfo;
import chemaxon.jchem.cartridge.tunnel.UserDefFuncInfo;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.rmi.NoSuchObjectException;
import java.sql.ResultSet;

public class EarlyCdIdResultSet
implements JCCartResultSet {
    public static final JCartLogger logger = JCartLogger.getLogger(EarlyCdIdResultSet.class);
    public static final int EARLY_CDID_BLOCK_SIZE = 100;
    private TableOpInfo tableOpInfo;
    private long termTime;
    private TableScan tableScanResult;
    private CdIdResultSet cdIdResultSet;
    private String usrOpId;

    public EarlyCdIdResultSet(SearchInfo searchInfo, long termTime, String usrOpId) throws Exception {
        this.tableOpInfo = searchInfo;
        this.termTime = termTime;
        String searchOptions = searchInfo.getOptions();
        if (searchOptions != null && searchOptions.indexOf("transport:rmi") > -1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using RMI for transport.");
            }
            JchemSearch remoteJcSearch = (JchemSearch)RmiDirectory.instance().getServer("JchemSearchServer");
            this.tableScanResult = remoteJcSearch.search(searchInfo);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Using SRMI for transport.");
            }
            this.tableScanResult = new JchemSearchResultSRmiCli(searchInfo);
        }
        this.usrOpId = usrOpId;
        this.init();
    }

    public EarlyCdIdResultSet(EvalChemTermInfo evalChemTermInfo, long termTime) throws Exception {
        this.tableOpInfo = evalChemTermInfo;
        this.termTime = termTime;
        EvalTableScanner evalScanner = (EvalTableScanner)RmiDirectory.instance().getServer("EvalTableScanner");
        this.tableScanResult = evalScanner.scan(evalChemTermInfo, 100);
        this.init();
    }

    public EarlyCdIdResultSet(UserDefFuncInfo userDefFuncInfo, long termTime) throws Exception {
        this.tableOpInfo = userDefFuncInfo;
        this.termTime = termTime;
        EvalTableScanner evalScanner = (EvalTableScanner)RmiDirectory.instance().getServer("EvalTableScanner");
        this.tableScanResult = evalScanner.scan(userDefFuncInfo, 100);
        this.init();
    }

    public EarlyCdIdResultSet(TableScanInfo perfectSearchInfo, String queryStructure, String querySmiles, int maxHitCount, String generTautomer, long termTime, int cdHashCode) throws Exception {
        this.tableOpInfo = perfectSearchInfo;
        this.termTime = termTime;
        JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), perfectSearchInfo.getIndexSchemaName(), perfectSearchInfo.getIndexName(), perfectSearchInfo.getIndexPartition(), perfectSearchInfo.getBaseSchemaName(), perfectSearchInfo.getBaseTableName(), perfectSearchInfo.getIndexedColumn());
        this.tableScanResult = new LocalPerfectSearchResult(idxDescriptor, queryStructure, querySmiles, maxHitCount, generTautomer, perfectSearchInfo.getOptions(), cdHashCode);
        this.init();
    }

    private void init() throws Exception {
    }

    private CdIdResultSet createCdIdResultSet(int[] hits, long termTime) throws Exception {
        return CdIdResultSet.createCdIdResultSet(this.tableOpInfo, hits, termTime);
    }

    @Override
    public int getNrRemainingRowids() throws Exception {
        if (this.tableScanResult == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNrRemainingRowids(): tableScanResult = null: no more results");
            }
            return 0;
        }
        int nrRemainingRowids = 0;
        if (this.cdIdResultSet == null) {
            nrRemainingRowids = this.fetchNextHits();
            if (nrRemainingRowids == 0) {
                return 0;
            }
        } else {
            nrRemainingRowids = this.cdIdResultSet.getNrRemainingRowids();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNrRemainingRowids(): cdIdResultSet.getNrRemainingRowids()=" + nrRemainingRowids);
        }
        if (nrRemainingRowids == 0) {
            nrRemainingRowids = this.fetchNextHits();
        }
        return nrRemainingRowids;
    }

    private int fetchNextHits() throws Exception {
        int[] result = this.tableScanResult.getNextHits();
        if (result == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNrRemainingRowids(): tableScanResult..getNextHits() returns null: no more results.");
            }
            this.cleanup();
            return 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNrRemainingRowids(): tableScanResult..getNextHits() returns " + result.length + " hit(s).");
        }
        this.cdIdResultSet = this.createCdIdResultSet(result, this.termTime);
        return this.cdIdResultSet.getNrRemainingRowids();
    }

    @Override
    public void cleanup() throws Exception {
        if (this.tableScanResult != null) {
            try {
                if (this.usrOpId != null) {
                    SearchExInfoSupport.instance.map(this.usrOpId, this.tableScanResult.getSearchId());
                }
                this.tableScanResult.dispose();
            }
            catch (NoSuchObjectException nsoe) {
                throw new KilledTaskException("Task has been killed");
            }
            finally {
                this.tableScanResult = null;
            }
        }
    }

    @Override
    public ResultSet getRowids(int count) throws Exception {
        int nrRemainingRowids = this.getNrRemainingRowids();
        if (nrRemainingRowids == 0) {
            throw new IllegalStateException("getRowids called on empty result set");
        }
        return this.cdIdResultSet.getRowids(count);
    }
}

