/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.resultset;

import chemaxon.jchem.cartridge.Debug;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.resultset.JCCartResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class ResultSetBase
implements JCCartResultSet,
Debug {
    public static final int NR_MAX_FETCH = 300;
    public static String oracleVersion;
    protected int idArrayIdx;
    protected boolean isJChemTable;
    protected String idxTblQName;

    public ResultSetBase(String idxTblQName, boolean isJChemTable, byte[] data) throws Exception {
        this.idxTblQName = idxTblQName;
        this.isJChemTable = isJChemTable;
        this.idArrayIdx = 0;
        this.prepareIdArray(data);
    }

    public ResultSetBase(String idxTblQName, boolean isJChemTable, int[] hits) throws Exception {
        this.idxTblQName = idxTblQName;
        this.isJChemTable = isJChemTable;
        this.idArrayIdx = 0;
        this.prepareIdArray(hits);
    }

    private void prepareIdArray(byte[] data) throws Exception {
        if (JFunctions.isProfiling()) {
            JFunctions.getSearchProfile().startCdid2Rowid = System.currentTimeMillis();
        }
        if (JFunctions.isNullString(data)) {
            data = new byte[]{};
        }
        this.createIdArray(data);
        if (JFunctions.isProfiling()) {
            JFunctions.getSearchProfile().endCdid2Rowid = System.currentTimeMillis();
        }
    }

    private void prepareIdArray(int[] data) throws Exception {
        if (JFunctions.isProfiling()) {
            JFunctions.getSearchProfile().startCdid2Rowid = System.currentTimeMillis();
        }
        this.createIdArray(data);
        if (JFunctions.isProfiling()) {
            JFunctions.getSearchProfile().endCdid2Rowid = System.currentTimeMillis();
        }
    }

    @Override
    public ResultSet getRowids(int nrows) throws Exception {
        int rest = this.getNrRemainingRowids();
        int maxNextCount = Math.min(nrows, rest);
        int nextCount = Math.min(300, maxNextCount);
        ResultSet rs = this.prepareExec(nextCount);
        this.idArrayIdx += nextCount;
        return rs;
    }

    protected static String getOracleVersion() throws SQLException {
        if (oracleVersion == null) {
            Connection conn = JavaStoredProcSession.instance().getConnection();
            DatabaseMetaData md = conn.getMetaData();
            oracleVersion = md.getDatabaseProductVersion();
            JFunctions.trace("Oracle major version is: " + oracleVersion);
        }
        return oracleVersion;
    }

    protected abstract void createIdArray(byte[] var1);

    protected abstract void createIdArray(int[] var1);

    @Override
    public abstract int getNrRemainingRowids();

    public abstract ResultSet prepareExec(int var1) throws Exception;
}

