/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.Admin;
import chemaxon.jchem.cartridge.rmi.Directory;
import chemaxon.jchem.cartridge.rmi.WrongPassword;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.rmi.client.RmiServerDesc;
import chemaxon.jchem.cartridge.rmi.impl.DirectoryImpl;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.server.task.Task;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.indexing.CacheIdManagement;
import chemaxon.jchem.cartridge.tunnel.GlobalMemoryInfo;
import chemaxon.jchem.cartridge.tunnel.LicenseInfo;
import chemaxon.jchem.cartridge.tunnel.TaskInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.util.Environment;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.cartridge.util.LoggingConfigurator;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.util.MaskingCmdLinePasswdReader;
import chemaxon.util.StringConverter;
import chemaxon.util.StringUtil;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class AdminImpl
implements Admin {
    private static boolean embedded;
    private static Logger logger;
    private static boolean promptForPassword;
    private static RmiServerDesc rmiServerDesc;
    private static Object appDeath;

    @Override
    public GlobalMemoryInfo getGlobalMemoryInfo() {
        return Environment.getInstance().getGlobalMemoryInfo();
    }

    @Override
    public TaskInfo[] getTaskInfos(String userId) throws Exception {
        return Task.getTaskInfos(userId);
    }

    @Override
    public int killTask(String userId, Long taskId) throws Exception {
        try {
            return Task.killTask(userId, taskId);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return 0;
        }
    }

    @Override
    public int removeZombies(String userId) throws Exception {
        return Task.removeZombies(userId);
    }

    @Override
    public String threadDump() {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        for (Thread t : stacks.keySet()) {
            sb.append(t.toString()).append('\n');
            for (StackTraceElement ste : t.getStackTrace()) {
                sb.append("\tat ").append(ste.toString()).append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void loadLicenses() throws Exception {
        File f;
        String licDirName;
        if (logger == null) {
            logger = Logger.getLogger(AdminImpl.class.getName());
        }
        if ((licDirName = JccConfig.getInstance().getProperty("license.dir")) == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No JCart property specified: license.dir. Trying in licenses...");
            }
            licDirName = "licenses";
        }
        if (!(f = new File(licDirName)).exists()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Directory " + licDirName + " does not exist. Leaving it to LicenseHandler " + "to check the default location for licenses.");
            }
            return;
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(licDirName + " is not a directory.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Looking in " + f.getCanonicalPath() + " for license files...");
        }
        String[] licFiles = f.list();
        for (int i = 0; i < licFiles.length; ++i) {
            String licFileName = licFiles[i];
            File licFile = new File(licDirName + File.separator + licFileName);
            if (licFile.isDirectory()) {
                logger.warning(licFile.getAbsolutePath() + " is a directory");
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing file " + licFile.getAbsolutePath());
            }
            LicenseHandler.getInstance().setLicenseFile(licFile.getAbsolutePath());
        }
        if (licFiles.length == 0 && logger.isLoggable(Level.INFO)) {
            logger.info("No license files found in " + f.getCanonicalPath() + ". Leaving it to LicenseHandler " + "to check the default location for licenses.");
        }
    }

    @Override
    public void execute(char[] password, String command) throws RemoteException, WrongPassword {
        block10: {
            String clientHost = null;
            try {
                clientHost = UnicastRemoteObject.getClientHost();
                this.checkRemoteAdminAllowed();
                this.checkAdminPassword(password);
                if (command.equals("stop")) {
                    this.shutdown();
                    break block10;
                }
                if (command.equals("reload")) {
                    this.reload();
                    break block10;
                }
                if (command.equals("reinit-connection-caches")) {
                    JccConfig.getInstance().load();
                    JCartConnectionManager.getInstance().reinitializeAll();
                    break block10;
                }
                if (command.equals("purge-connection-caches")) {
                    JccConfig.getInstance().load();
                    JCartConnectionManager.getInstance().purgeCaches();
                    break block10;
                }
                if (command.startsWith("setpassword")) {
                    String newpassword = command.substring("setpassword".length());
                    this.setNewPassword(newpassword);
                    break block10;
                }
                if (command.startsWith("list")) {
                    this.list(command);
                    break block10;
                }
                throw new RemoteException("Unknown command: " + command);
            }
            catch (WrongPassword wp) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Wrong password from " + clientHost);
                }
                throw wp;
            }
            catch (Throwable throwable) {
                System.err.println("throwable" + throwable.getClass().getName());
                RmiExceptionHandler.handleError(logger, throwable);
            }
        }
    }

    private void list(String command) {
        if (!command.equals("list result timers")) {
            throw new IllegalArgumentException("Unknown list command: '" + command);
        }
        Task.listActiveTasks();
    }

    private void checkRemoteAdminAllowed() throws IOException, ServerNotActiveException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("BEGIN");
        }
        boolean remoteAdminAllowed = false;
        String remoteAdminAllowedStr = JccConfig.getInstance().getProperty("remote.admin.allowed");
        if (remoteAdminAllowedStr != null) {
            remoteAdminAllowed = this.parseBoolean(remoteAdminAllowedStr);
        }
        String[] clientHost = new String[1];
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("About to call islocalclient...");
        }
        if (!remoteAdminAllowed && !RmiExceptionHandler.isLocalClient(clientHost)) {
            String message = "AdminImpl: called from " + clientHost[0] + ". Only calls from the loopback address are accepted";
            System.err.println(message);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(message);
            }
            throw new RemoteException(message);
        }
    }

    private boolean parseBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    private void checkAdminPassword(char[] password) throws IOException, WrongPassword {
        char[] adminPwd;
        String adminPassword = JccConfig.getInstance().getProperty("admin.password");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("adminPassword=" + adminPassword);
        }
        if (adminPassword == null || adminPassword.length() == 0) {
            return;
        }
        if (password == null || password.length == 0) {
            throw new WrongPassword();
        }
        String admPwd = StringConverter.megfejt(adminPassword);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("mmm:" + admPwd);
        }
        if ((adminPwd = admPwd.toCharArray()).length != password.length) {
            throw new WrongPassword();
        }
        for (int i = 0; i < adminPwd.length; ++i) {
            char c = adminPwd[i];
            if (c == password[i]) continue;
            throw new WrongPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServer(String propsFileName) throws IOException {
        block11: {
            if (propsFileName != null) {
                JccConfig.getInstance().setPropsFileName(propsFileName);
            }
            logger = Logger.getLogger(AdminImpl.class.getName());
            String serverHostname = JccConfig.getInstance().getProperty("jchem.server.host");
            if (serverHostname != null) {
                System.setProperty("java.rmi.server.hostname", serverHostname);
            }
            String serverPortStr = JccConfig.getInstance().getProperty("jchem.server.port");
            int serverPort = Integer.parseInt(serverPortStr);
            try {
                AdminImpl.setStructureCacheId();
                DirectoryImpl instance = DirectoryImpl.createInstance();
                AdminImpl.loadLicenses();
                AdminImpl.addShutdownHook();
                Registry registry = LocateRegistry.createRegistry(serverPort);
                registry.bind("jcc/Directory", instance);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Listening at " + serverPort);
                }
                if (embedded) break block11;
                Object object = appDeath;
                synchronized (object) {
                    appDeath.wait();
                }
                WorkUnitManager.getInstance().shutdownNow();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Error starting node", e);
                } else {
                    e.printStackTrace();
                }
                if (embedded) break block11;
                System.exit(1);
            }
        }
        if (!embedded) {
            System.err.println("Exiting...");
            System.exit(0);
        }
    }

    private static void setStructureCacheId() throws IOException {
        String structureCacheId = JccConfig.getInstance().getProperty("structure.cache.id");
        if (structureCacheId == null) {
            throw new RuntimeException("Missing parameter: structure.cache.id");
        }
        CacheRegistrationUtil.setPermanentCacheID(structureCacheId);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Cache id set to " + structureCacheId);
        }
    }

    private static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("\nShutting down...");
                }
                Object object = appDeath;
                synchronized (object) {
                    appDeath.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        System.err.println("AdminImpl: shutdown called...");
        logger.info("shutdown called");
        Object object = appDeath;
        synchronized (object) {
            appDeath.notifyAll();
        }
    }

    private void reload() throws Exception {
        System.err.println("AdminImpl: reload called...");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("reload called");
        }
        JccConfig.getInstance().load();
        LogManager.getLogManager().readConfiguration();
        AdminImpl.loadLicenses();
    }

    private void setNewPassword(String newpassword) throws IOException {
        String encryptedPwd = StringUtil.encrypt(new String(newpassword));
        JccConfig.getInstance().setProperty("admin.password", encryptedPwd);
        JccConfig.getInstance().store();
    }

    private static String processArgs(String[] args) throws IOException {
        String command = null;
        for (int ix = 0; ix < args.length; ++ix) {
            if (args[ix].equals("--no-pwprompt")) {
                promptForPassword = false;
                continue;
            }
            if (args[ix].equals("--config-file")) {
                JccConfig.getInstance().setPropsFileName(args[++ix]);
                continue;
            }
            if (args[ix].equals("setpassword")) {
                char[] newPassword = MaskingCmdLinePasswdReader.getPassword(System.in, "New password: ");
                command = args[ix] + new String(newPassword);
                continue;
            }
            command = args[ix];
        }
        if (command == null) {
            throw new IllegalArgumentException("Missing command");
        }
        return command;
    }

    private static Admin getAdminServer(RmiServerDesc srvDesc) throws Exception {
        try {
            Directory directory = new RmiDirectory(rmiServerDesc).locate();
            return (Admin)directory.get("AdminServer");
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Error", exception);
            }
            throw new Exception("Unable to connect to JChem Server at " + srvDesc, exception);
        }
    }

    private static char[] getAdminPassword() throws IOException {
        if (promptForPassword) {
            return MaskingCmdLinePasswdReader.getPassword(System.in, "Password: ");
        }
        return null;
    }

    public static void mainNoSysExit(String[] args) {
        embedded = true;
        AdminImpl.main(args);
    }

    public static void main(String[] args) {
        block12: {
            try {
                String command = AdminImpl.processArgs(args);
                new LoggingConfigurator();
                logger = Logger.getLogger(AdminImpl.class.getName());
                String serverHost = JccConfig.getInstance().getProperty("jchem.server.host");
                if (serverHost == null) {
                    serverHost = "localhost";
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("jchem.server.host is not set -- assuming localhost");
                    }
                }
                String serverPortStr = JccConfig.getInstance().getProperty("jchem.server.port");
                int serverPort = Integer.parseInt(serverPortStr);
                String connectString = serverHost + ":" + serverPort;
                rmiServerDesc = new RmiServerDesc(connectString);
                if (command.equals("start")) {
                    AdminImpl.startServer(null);
                    return;
                }
                if (command.equals("thread-dump")) {
                    System.err.println(AdminImpl.getAdminServer(rmiServerDesc).threadDump());
                    return;
                }
                boolean passwdOk = false;
                for (int ix = 0; ix < 3; ++ix) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Connecting to " + connectString);
                    }
                    Admin admin = AdminImpl.getAdminServer(rmiServerDesc);
                    char[] password = AdminImpl.getAdminPassword();
                    try {
                        admin.execute(password, command);
                        passwdOk = true;
                        break;
                    }
                    catch (WrongPassword wp) {
                        System.err.println("Wrong password");
                        continue;
                    }
                }
                if (!passwdOk) {
                    System.exit(1);
                }
            }
            catch (Throwable throwable) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
                if (embedded) break block12;
                System.exit(1);
            }
        }
    }

    @Override
    public String getMyCacheId() throws RemoteException {
        try {
            return new CacheIdManagement().getMyCacheId();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public String[] getAllJccCacheIds(UserInfo userInfo, String jccOwner) throws RemoteException {
        try {
            ArrayList<String> cacheIds = new CacheIdManagement().getAllJccCacheIds(userInfo, jccOwner);
            String[] ret = new String[cacheIds.size()];
            cacheIds.toArray(ret);
            return ret;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public void registerCacheIds(UserInfo userInfo, String jccOwner, String jchemPropertiesTableName) throws RemoteException {
        try {
            new CacheIdManagement().registerCacheIdsForJcb(userInfo, jccOwner, jchemPropertiesTableName);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public String getProperty(String propertyName) throws RemoteException {
        String result = null;
        boolean unpublihsed = false;
        try {
            if (propertyName.equals("markush.screening.enabled")) {
                result = String.valueOf(JccConfig.getInstance().getBoolean("markush.screening.enabled", true));
            } else if (propertyName.equals("chemaxon.jchem.cartridge.indexingIsAynch")) {
                result = String.valueOf(JccConfig.getInstance().getBoolean("chemaxon.jchem.cartridge.indexingIsAynch", false));
            } else {
                unpublihsed = true;
            }
        }
        catch (IOException e) {
            RmiExceptionHandler.handleError(logger, (Throwable)e);
            return result;
        }
        if (unpublihsed) {
            throw new IllegalArgumentException("Property not published: " + propertyName);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning " + result + " for " + propertyName);
        }
        return result;
    }

    @Override
    public LicenseInfo getLicenses(String product, String term) throws RemoteException {
        LicenseInfo lInfo = new LicenseInfo();
        ArrayList<License> licenses = LicenseHandler.getInstance().getLicenses(product, term);
        ArrayList licenseMap = new ArrayList();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Integer.toString(licenseMap.size()));
        }
        for (License licenseRow : licenses) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(licenseRow.toString());
            }
            HashMap<String, String> licenseMapRow = new HashMap<String, String>();
            for (int i = 0; i < licenseRow.getFieldCount(); ++i) {
                licenseMapRow.put(licenseRow.getFieldName(i), licenseRow.getFieldValue(i));
            }
            licenseMapRow.put("Restrictions", licenseRow.getRestrictions());
            licenseMap.add(licenseMapRow);
        }
        lInfo.licenseMapList = licenseMap;
        return lInfo;
    }

    static {
        promptForPassword = true;
        appDeath = new Object();
    }
}

