/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.cartridge.extfp.ExtFpRowDataGenerator;
import chemaxon.jchem.cartridge.rmi.Dml;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.tunnel.InsertFpReqData;
import chemaxon.jchem.cartridge.tunnel.InsertReqData;
import chemaxon.jchem.cartridge.tunnel.InsertRespData;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.util.OptUtil;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.UpdateHandlerException;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.MolHandler;
import chemaxon.util.cache.CachedPools;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DmlImpl
implements Dml {
    private static Logger logger = Logger.getLogger(DmlImpl.class.getName());
    private static UhHolderPooledCache uhCache = new UhHolderPooledCache();

    @Override
    public InsertRespData createInsertData(InsertFpReqData fpRequestData) throws RemoteException {
        try {
            ExtFpRowDataGenerator rdg = new ExtFpRowDataGenerator();
            InsertRespData respData = new InsertRespData();
            respData.fps = rdg.getRowData((String)fpRequestData.fpAsBitString).fingerprint;
            return respData;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public InsertRespData createInsertData(InsertReqData requestData) throws RemoteException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing " + requestData);
        }
        try {
            UhHolder uhHolder = this.getUhHolder(requestData.tableName, requestData.propTableName, requestData.tableTimeStamp, requestData.userInfo, requestData.isJChemTable, requestData.mdMetaData);
            InsertRespData respData = this.createResponseData(requestData, null, uhHolder);
            this.recycleUhHolder(uhHolder);
            return respData;
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return null;
        }
    }

    private InsertRespData createResponseData(InsertReqData requestData, Molecule origMol, UhHolder uhHolder) throws UpdateHandlerException, MolFormatException, UnsupportedEncodingException, MDGeneratorException {
        this.setFlags(requestData, uhHolder);
        byte[] struct = null;
        if (requestData.structure != null && requestData.structure.length() > 0) {
            struct = requestData.structure.getBytes("US-ASCII");
        }
        UpdateHandler.RowData rd = uhHolder.uh.createRowData(struct);
        this.clearFlags(uhHolder);
        byte[][] mdData = this.generateMdData(uhHolder.descriptors, struct);
        return this.fillResponseData(requestData, origMol, rd, mdData);
    }

    @Override
    public boolean isInsertable(String structure, int tableType) throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("structure=" + structure + ", tableType=" + tableType);
        }
        Molecule m = MolImporter.importMol(structure);
        return UpdateHandler.isInsertable(m, tableType, false);
    }

    private void setFlags(InsertReqData insertReqData, UhHolder uhHolder) {
        String flags = insertReqData.flags;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("flags=" + flags);
        }
        if (flags != null && flags.toUpperCase().indexOf("C") != -1) {
            uhHolder.uh.setSetChiralFlag(true);
        }
    }

    private void clearFlags(UhHolder uhHolder) {
        uhHolder.uh.setSetChiralFlag(false);
    }

    private byte[][] generateMdData(MolecularDescriptor[] descriptors, byte[] struct) throws MDGeneratorException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("descriptors=" + Arrays.asList(descriptors) + ", struct=" + struct);
        }
        if (descriptors == null) {
            return null;
        }
        byte[][] data = new byte[descriptors.length][];
        for (int i = 0; i < descriptors.length; ++i) {
            MolecularDescriptor desc = descriptors[i];
            if (struct == null) {
                desc.generate(new Molecule());
            } else {
                desc.generate(new String(struct));
            }
            data[i] = desc.toData();
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("data[" + i + "]=" + data[i]);
        }
        return data;
    }

    private InsertRespData fillResponseData(InsertReqData requestData, Molecule origMol, UpdateHandler.RowData rd, byte[][] mdData) throws UpdateHandlerException, MolFormatException, UnsupportedEncodingException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("requestData=" + requestData);
        }
        InsertRespData respData = new InsertRespData();
        respData.flags = rd.flags;
        respData.formula = rd.formula;
        respData.fps = rd.fingerprint;
        respData.hashCode = rd.hashCode;
        respData.markushData = rd.getMarkushData();
        respData.mass = rd.molWeight;
        respData.mdFps = this.calcMdFps();
        respData.smilesOrSmarts = rd.smiles;
        respData.structure = new String(rd.molString, "US-ASCII");
        if (rd.genericTautomer != null) {
            respData.genericTautomer = rd.genericTautomer.toFormat("mrv");
        }
        if (requestData.userDefinedColMap != null) {
            if (origMol == null) {
                origMol = new MolHandler(requestData.structure, false).getMolecule();
            }
            respData.xColNamesAndValues = DmlImpl.getXColNamesAndValues(requestData.userDefinedColMap, origMol);
        }
        if (rd.chemTermColValues != null) {
            respData.ctColNamesAndValues = new String[rd.chemTermColValues.size()][];
            Iterator<String> colNames = rd.chemTermColValues.keySet().iterator();
            int ix = 0;
            while (colNames.hasNext()) {
                String colName = colNames.next();
                String value = null;
                Object o = rd.chemTermColValues.get(colName);
                if (o != null) {
                    value = String.valueOf(o);
                }
                respData.ctColNamesAndValues[ix] = new String[]{colName, value};
                ++ix;
            }
        }
        respData.mdFps = mdData;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("respData=" + respData);
        }
        return respData;
    }

    private byte[][] calcMdFps() {
        return null;
    }

    @Override
    public InsertRespData[] createMultiInsertData(InsertReqData requestData) throws RemoteException {
        try {
            return this.createMultiInsertDataUc(requestData);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InsertRespData[] createMultiInsertDataUc(InsertReqData requestData) throws Exception {
        ArrayList<InsertRespData> l = new ArrayList<InsertRespData>();
        String origStructure = requestData.structure;
        UhHolder uhHolder = this.getUhHolder(requestData.tableName, requestData.propTableName, requestData.tableTimeStamp, requestData.userInfo, requestData.isJChemTable, requestData.mdMetaData);
        try {
            ByteArrayInputStream instream = new ByteArrayInputStream(origStructure.getBytes("US-ASCII"));
            MolImporter importer = new MolImporter(instream);
            importer.setGrabbingEnabled(true);
            Molecule mol = importer.read();
            while (mol != null) {
                String struct;
                requestData.structure = struct = importer.getGrabbedMoleculeString();
                InsertRespData respData = this.createResponseData(requestData, mol, uhHolder);
                l.add(respData);
                mol = importer.read();
            }
        }
        finally {
            this.recycleUhHolder(uhHolder);
        }
        InsertRespData[] result = new InsertRespData[l.size()];
        l.toArray(result);
        return result;
    }

    private UhHolder getUhHolder(String tableName, String propTableName, String tableTimeStamp, SessionInfo userInfo, boolean isJChemTable, MdMetaData[] mdMetaData) throws Exception {
        UhHolderKey key = new UhHolderKey(tableName, tableTimeStamp, userInfo, propTableName, isJChemTable, mdMetaData);
        UhHolder uholder = (UhHolder)uhCache.getCreatePoolItem(key);
        while (!uholder.uhHolderKey.tableTimeStamp.equals(tableTimeStamp)) {
            uholder = (UhHolder)uhCache.getCreatePoolItem(key);
        }
        return uholder;
    }

    private void recycleUhHolder(UhHolder uhHolder) {
        uhCache.recyclePoolItem(uhHolder.uhHolderKey, uhHolder);
    }

    public static String[][] getXColNamesAndValues(String userDefColMapString, Molecule mol) {
        int i;
        String[][] userDefColMap = OptUtil.createField2ColNameMap(userDefColMapString);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(userDefColMap.length + " element(s) in userDefColMap");
        }
        if (userDefColMap == null) {
            return null;
        }
        String[][] xColNamesAndValues = null;
        ArrayList<String[]> l = new ArrayList<String[]>();
        for (i = 0; i < userDefColMap.length; ++i) {
            String[] m = userDefColMap[i];
            String fieldName = m[0];
            String colName = m[1];
            String propValue = MPropHandler.convertToString(mol.properties(), fieldName);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("fieldName=" + fieldName + ", colName=" + colName + ", propValue=" + propValue);
            }
            l.add(new String[]{colName, propValue});
        }
        xColNamesAndValues = new String[l.size()][];
        for (i = 0; i < xColNamesAndValues.length; ++i) {
            xColNamesAndValues[i] = (String[])l.get(i);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(xColNamesAndValues.length + " element(s) in xColNamesAndValues");
        }
        return xColNamesAndValues;
    }

    private static class UhHolderPooledCache
    extends CachedPools {
        private UhHolderPooledCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Object createPoolItem(Object key) throws Exception {
            UpdateHandler updateHandler = null;
            Exception error = null;
            UhHolderKey uhHolderKey = (UhHolderKey)key;
            ConnectionHandler conh = JCartConnectionManager.getInstance().createConnectionHandler(uhHolderKey.userInfo, uhHolderKey.propTableName, true);
            try {
                updateHandler = uhHolderKey.isJChemTable ? new UpdateHandler(conh, 2, uhHolderKey.tableName, null) : new UpdateHandler(conh, 2, uhHolderKey.tableName, "", "", "");
                updateHandler.setEmptyStructuresAllowed(true);
                UhHolder uhHolder = new UhHolder(uhHolderKey, updateHandler, this.createMdDescriptors(uhHolderKey.mdMetaData));
                return uhHolder;
            }
            catch (Exception e) {
                error = e;
                return error;
            }
            finally {
                try {
                    conh.close();
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "error", e);
                    }
                    if (error == null) {
                        error = e;
                        return error;
                    }
                }
                finally {
                    if (error == null) return null;
                    throw error;
                }
            }
        }

        private MolecularDescriptor[] createMdDescriptors(MdMetaData[] mdMetaData) {
            if (mdMetaData == null) {
                return null;
            }
            MolecularDescriptor[] descriptors = new MolecularDescriptor[mdMetaData.length];
            for (int x = 0; x < mdMetaData.length; ++x) {
                String type = mdMetaData[x].type;
                String settings = mdMetaData[x].settings;
                MolecularDescriptor descriptor = MolecularDescriptor.newInstance(type);
                descriptor.setParameters(settings);
                descriptors[x] = descriptor;
            }
            return descriptors;
        }
    }

    private static class UhHolderKey {
        private String tableName;
        private String tableTimeStamp;
        private SessionInfo userInfo;
        private String propTableName;
        private boolean isJChemTable;
        private MdMetaData[] mdMetaData;

        public UhHolderKey(String tableName, String tableTimeStamp, SessionInfo userInfo, String propTableName, boolean isJChemTable, MdMetaData[] mdMetaData) {
            this.tableName = tableName;
            this.tableTimeStamp = tableTimeStamp;
            this.userInfo = userInfo;
            this.propTableName = propTableName;
            this.isJChemTable = isJChemTable;
            this.mdMetaData = mdMetaData;
        }

        public int hashCode() {
            return this.tableName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UhHolderKey)) {
                return false;
            }
            UhHolderKey other = (UhHolderKey)obj;
            return other.tableName.equals(this.tableName);
        }
    }

    private static class UhHolder {
        private UhHolderKey uhHolderKey;
        private UpdateHandler uh;
        private MolecularDescriptor[] descriptors;

        public UhHolder(UhHolderKey uhHolderKey, UpdateHandler uh, MolecularDescriptor[] descriptors) {
            this.uhHolderKey = uhHolderKey;
            this.uh = uh;
            this.descriptors = descriptors;
        }
    }
}

