/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.rmi.Evaluator;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.interop.InteropEval;
import chemaxon.util.CxOptions;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvaluatorImpl
implements Evaluator {
    private static Log log = LogFactory.getLog(EvaluatorImpl.class);

    protected EvaluatorImpl() throws RemoteException {
    }

    @Override
    public String evaluateToNumeric(byte[] query, String standizerConfig, String expression) throws RemoteException {
        try {
            return (String)new InteropEval().evaluate(JFunctions.decodeDbString(query), standizerConfig, expression, null, false, true);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(log, tbl);
            return null;
        }
    }

    @Override
    public String evaluate(byte[] query, String standizerConfig, String options) throws RemoteException {
        String expression = null;
        try {
            CxOptions opts = new CxOptions(options);
            expression = opts.getStringValue("chemTerms");
            String outFormat = opts.getStringValue("outFormat");
            return (String)new InteropEval().evaluate(JFunctions.decodeDbString(query), standizerConfig, expression, outFormat, false, false);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(log, "Error while applying '" + expression + "' to '" + query + "'", tbl);
            return null;
        }
    }

    @Override
    public String[] evaluateToArray(byte[] query, String standizerConfig, String options) throws RemoteException {
        try {
            CxOptions opts = new CxOptions(options);
            String expression = opts.getStringValue("chemTerms");
            String outFormat = opts.getStringValue("outFormat");
            return (String[])new InteropEval().evaluate(JFunctions.decodeDbString(query), standizerConfig, expression, outFormat, true, false);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(log, tbl);
            return null;
        }
    }
}

