/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.FormulaSearch;
import java.rmi.RemoteException;

public class FormulaSearchImpl
implements FormulaSearch {
    @Override
    public boolean isMatching(String target, String query, String searchType) throws RemoteException {
        chemaxon.sss.formula.FormulaSearch fs = new chemaxon.sss.formula.FormulaSearch();
        try {
            fs.setTarget(target);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Illegal target: " + iae.getMessage() + ": '" + target + "'");
        }
        try {
            fs.setQuery(query);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Illegal query: " + iae.getMessage() + ": '" + query + "'");
        }
        fs.setSearchType(FormulaSearchImpl.stringToSearchType(searchType));
        return fs.isMatching();
    }

    public static String searchTypeToString(int searchType) {
        switch (searchType) {
            case 3: {
                return "sub";
            }
            case 1: {
                return "exact";
            }
            case 2: {
                return "exact_sub";
            }
        }
        throw new IllegalArgumentException("Unexpected formula search type: " + searchType);
    }

    private static int stringToSearchType(String searchType) {
        if (searchType.equalsIgnoreCase("sub")) {
            return 3;
        }
        if (searchType.equalsIgnoreCase("exact")) {
            return 1;
        }
        if (searchType.equalsIgnoreCase("exact_sub")) {
            return 2;
        }
        throw new IllegalArgumentException("Illegal formula search type: " + searchType);
    }
}

