/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.JcReact;
import chemaxon.jchem.cartridge.rmi.ReactProducts;
import chemaxon.jchem.cartridge.rmi.impl.ReactProductsImpl;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.servlets.react.JCartReactor;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.reactor.InteropReactOption;
import chemaxon.util.CxOptions;
import java.rmi.RemoteException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JcReactImpl
implements JcReact {
    private static Logger logger = Logger.getLogger(JcReactImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reactSimple(String reaction, String[] reactantArray, String options, boolean oldJcReact, SessionInfo userInfo) throws RemoteException {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < reactantArray.length; ++i) {
                String reactant = reactantArray[i];
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(reactant);
            }
            logger.fine("reaction=" + reaction + ", reactants=" + sb.toString() + ", options=" + options + ", oldJcReact=" + oldJcReact + ", userId=" + userInfo);
        }
        try {
            String[] result = null;
            ReactProducts rp = this.reactUc(reaction, reactantArray, options, oldJcReact, false, userInfo, 0);
            try {
                result = rp.getNextProducts();
            }
            finally {
                rp.dispose();
            }
            if (result == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No products");
                }
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning " + result[0]);
            }
            return result[0];
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public ReactProducts react(String reaction, String[] reactantArray, String options, boolean oldJcReact, boolean separateOutMols, SessionInfo userInfo, int resultChunkSize) throws RemoteException {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < reactantArray.length; ++i) {
                String reactant = reactantArray[i];
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(reactant);
            }
            logger.fine("reaction=" + reaction + ", reactants=" + sb.toString() + ", options=" + options + ", oldJcReact=" + oldJcReact + ", userId=" + userInfo + ", separateOutMols=" + separateOutMols + ", resultChunkSize=" + resultChunkSize);
        }
        try {
            ReactProducts rp = this.reactUc(reaction, reactantArray, options, oldJcReact, separateOutMols, userInfo, resultChunkSize);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning ReactProducts");
            }
            return rp;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    private ReactProducts reactUc(String reaction, String[] reactantArray, String options, boolean oldJcReact, boolean separateOutMols, SessionInfo userInfo, int resultChunkSize) throws Throwable {
        CxOptions jcOptions = new CxOptions(InteropReactOption.getNames(), options);
        LinkedBlockingQueue<String> lbq = new LinkedBlockingQueue<String>(1000 * Runtime.getRuntime().availableProcessors());
        JCartReactor jcartReactor = new JCartReactor(reaction, reactantArray, jcOptions, separateOutMols, userInfo, lbq, oldJcReact);
        try {
            jcartReactor.start();
            String taskDescription = "reaction=" + reaction + ", reactants=" + InteropUtil.flattenStringArray(reactantArray) + ", options=" + options;
            ReactProductsImpl products = new ReactProductsImpl(userInfo, jcOptions.getStringValue("usrOpId"), taskDescription, lbq, jcartReactor, resultChunkSize);
            return products;
        }
        catch (Throwable throwable) {
            jcartReactor.stop();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        String reactionString = "[Cl:2][C:1]=O.[#7:3][H:4]>>[#7:3][C:1]=O.[Cl:2][H:4]";
        String[] reactants = new String[]{"ClC(=O)CC1=CC(=CC=C1)C(Cl)=O", "CC(N)CN"};
        JcReactImpl jcReactImpl = new JcReactImpl();
        try {
            String p = jcReactImpl.reactSimple("[Cl:2][C:1]=O.[#7:3][H:4]>>[#7:3][C:1]=O.[Cl:2][H:4]", reactants, null, false, null);
            System.out.println(p);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

