/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.rmi.IllegalOptionException;
import chemaxon.jchem.cartridge.rmi.MolSearch;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.search.MolSearchParams;
import chemaxon.jchem.cartridge.tunnel.search.ScreenParams;
import chemaxon.jchem.cartridge.tunnel.search.SearchStandardizationParams;
import chemaxon.jchem.cartridge.tunnel.search.TautomerSearchParams;
import chemaxon.jchem.cartridge.util.probe.CountProbe;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandlerCache;
import chemaxon.jchem.interop.InteropMiscellanious;
import chemaxon.jchem.interop.MolSearchOptionsAdapter;
import chemaxon.jchem.interop.Pools;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.io.formats.smiles.CxsmilesImport;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.screen.DefaultMarkushScreenOptions;
import chemaxon.sss.search.DataSgroupComparator;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.TautomerUtil;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.MolHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MolSearchImpl
implements MolSearch {
    private static final Logger logger = Logger.getLogger(MolSearchImpl.class.getName());
    private static final CountProbe screenCountProbe = new CountProbe(MolSearchImpl.class, "screen.count");
    CDMarkushHandlerCache markushHandlerCache = new CDMarkushHandlerCache(CDMarkushHandlerCache.ThreadSafety.SYNCHRONIZED, CDMarkushHandlerCache.CacheBehavior.CACHEFIRST);
    private static int counter;
    private static Random random;

    protected MolSearchImpl() throws RemoteException {
    }

    @Override
    public boolean search(MolSearchParams molSearchInfo) throws RemoteException {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(molSearchInfo.toString());
            }
            Molecule queryMolecule = null;
            Molecule targetMolecule = null;
            try {
                MolSearchOptionsAdapter opt = this.createSearchOptions(molSearchInfo);
                queryMolecule = this.queryToMol(molSearchInfo.getQuery(), opt);
                targetMolecule = this.targetStringToMol(molSearchInfo, opt);
                if (this.screen(molSearchInfo.getStructureType(), molSearchInfo.getScreenInfo(), queryMolecule, targetMolecule, opt)) {
                    if (screenCountProbe.isActive()) {
                        screenCountProbe.count();
                    }
                    return this.match(molSearchInfo, opt, queryMolecule, targetMolecule, false) > 0;
                }
                return false;
            }
            catch (MolFormatException mfe) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, mfe.getMessage(), mfe);
                }
                if (queryMolecule == null) {
                    throw new StructureFormatException("Invalid query", mfe);
                }
                throw new StructureFormatException("Invalid target", mfe);
            }
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return false;
        }
    }

    private MolSearchOptionsAdapter createSearchOptions(MolSearchParams molSearchInfo) throws IllegalOptionException {
        int searchType = molSearchInfo.getSearchType();
        String options = molSearchInfo.getOptions();
        try {
            MolSearchOptionsAdapter opt;
            if (searchType == -1) {
                opt = new MolSearchOptionsAdapter(options);
            } else {
                opt = new MolSearchOptionsAdapter(searchType);
                opt.setOptions(options);
            }
            return opt;
        }
        catch (IllegalArgumentException iae) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, iae.getMessage(), iae);
            }
            throw new IllegalOptionException("Invalid search option: " + iae.getMessage());
        }
    }

    @Override
    public int matchCount(MolSearchParams molSearchInfo) throws RemoteException {
        try {
            MolSearchOptionsAdapter opt = new MolSearchOptionsAdapter(2);
            opt.setOptions(molSearchInfo.getOptions());
            Molecule queryMolecule = this.queryToMol(molSearchInfo.getQuery(), opt);
            Molecule targetMolecule = this.targetStringToMol(molSearchInfo, opt);
            return this.match(molSearchInfo, opt, queryMolecule, targetMolecule, true);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int match(MolSearchParams molSearchInfo, MolSearchOptionsAdapter searchOptions, Molecule queryMolecule, Molecule targetMolecule, boolean reportMatchCount) throws Exception {
        TautomerSearchParams tautomerGenInfo = molSearchInfo.getTautomerGenInfo();
        tautomerGenInfo.setCalcQueryGenericTautomer(this.isGenTautCalcNeededYet(tautomerGenInfo.isCalcQueryGenericTautomer(), searchOptions));
        tautomerGenInfo.setCalcTargetGenericTautomer(this.isGenTautCalcNeededYet(tautomerGenInfo.isCalcTargetGenericTautomer(), searchOptions));
        SearchStandardizationParams standardizationInfo = molSearchInfo.getStandardizationInfo();
        Standardizer standardizer = this.createStandardizer(molSearchInfo.getStructureType(), standardizationInfo);
        try {
            chemaxon.sss.search.MolSearch molSearch = this.createMolSearch(molSearchInfo.getStructureType(), queryMolecule, standardizationInfo.isQueryStandardizationNeeded() ? standardizer : null, searchOptions, molSearchInfo.isAbsoluteStereo(), tautomerGenInfo);
            int n = this.search(molSearchInfo.getStructureType(), molSearch, reportMatchCount, targetMolecule, standardizationInfo.isTargetStandardizationNeeded() ? standardizer : null, tautomerGenInfo);
            return n;
        }
        finally {
            if (standardizer != null) {
                Pools.recycleStandardizer(standardizationInfo.getStandardizerConfiguration(), standardizer);
            }
        }
    }

    private Standardizer createStandardizer(int structureType, SearchStandardizationParams standardizationInfo) throws Exception {
        String stdrConfig = standardizationInfo.getStandardizerConfiguration();
        Standardizer standardizer = null;
        if (standardizationInfo.isQueryStandardizationNeeded() || standardizationInfo.isTargetStandardizationNeeded()) {
            if (stdrConfig == null) {
                stdrConfig = structureType == 4 ? "aromatize" : "aromatize..removeexplicitH";
            }
            standardizer = Pools.getCreateStandardizer(stdrConfig);
        }
        return standardizer;
    }

    private boolean isGenTautCalcNeededYet(boolean calcGenericTautomer, MolSearchOptionsAdapter searchOptions) {
        if (calcGenericTautomer) {
            return true;
        }
        if (searchOptions.isTdf()) {
            return true;
        }
        return searchOptions.getSearchType() == 5 && searchOptions.getTautomerSearch() == 1;
    }

    private Molecule targetStringToMol(MolSearchParams molSearchInfo, MolSearchOptionsAdapter searchOptions) throws SupergraphException, IOException {
        byte[] target = molSearchInfo.getTarget();
        int structureType = molSearchInfo.getStructureType();
        boolean targetStdrNeeded = molSearchInfo.getStandardizationInfo().isTargetStandardizationNeeded();
        Molecule targetMol = null;
        try {
            if (targetStdrNeeded) {
                targetMol = new MolHandler(target).getMolecule();
            } else if (this.isDuplicateSearch(searchOptions)) {
                if (structureType == 3) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("About to read markush data of " + target.length + " bytes length...");
                    }
                    targetMol = this.markushHandlerCache.parseWithCompatibleHandler(target).getMarkush();
                } else {
                    targetMol = new MolHandler(target).getMolecule();
                }
            } else if (structureType == 3) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("About to read markush data of " + target.length + " bytes length...");
                }
                targetMol = this.markushHandlerCache.parseWithCompatibleHandler(target).getSupergraph();
            } else {
                targetMol = new RgMolecule();
                CxsmilesImport cxsmi = new CxsmilesImport();
                cxsmi.readMol(new String(target), targetMol);
            }
            return targetMol;
        }
        catch (MolFormatException ex) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Offending structure: '" + target + "'", ex);
            }
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Offending structure: '" + target + "'", ex);
            }
            throw ex;
        }
    }

    private chemaxon.sss.search.MolSearch createMolSearch(int targetType, Molecule queryMolecule, Standardizer standardizer, MolSearchOptionsAdapter molSearchOptions, boolean absStereo, TautomerSearchParams tautomerGenInfo) throws Exception {
        boolean markushTarget;
        boolean isMarkushQuery;
        boolean isDuplicateSearch = this.isDuplicateSearch(molSearchOptions);
        boolean bl = isMarkushQuery = queryMolecule.getAtomCount() == 0 ? false : Supergraph.isMarkushMolecule(queryMolecule);
        if (isMarkushQuery && isDuplicateSearch) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("markush aromatization");
            }
            MarkushAromata ma = new MarkushAromata();
            ma.aromatize(queryMolecule);
        } else if (standardizer != null) {
            boolean removeHydrogenesOrWhat = isDuplicateSearch;
            TableInfo.standardize(queryMolecule, standardizer, removeHydrogenesOrWhat);
        }
        if (isDuplicateSearch && tautomerGenInfo.isCalcQueryGenericTautomer()) {
            queryMolecule = this.calcGenericTautomer(queryMolecule, tautomerGenInfo.isProtectTautomerChirality(), tautomerGenInfo.isSwitchOffAllTautomerProtectionTdf());
        }
        if (logger.isLoggable(Level.FINEST)) {
            MolSearchImpl.printMol(counter, "inq", queryMolecule);
        }
        boolean bl2 = markushTarget = targetType == 3;
        if (markushTarget) {
            molSearchOptions.setMarkushEnabled(true);
        }
        this.setStereoModel(molSearchOptions, targetType);
        chemaxon.sss.search.MolSearch msearch = new chemaxon.sss.search.MolSearch();
        molSearchOptions.setQueryAbsoluteStereo(absStereo);
        molSearchOptions.setTargetAbsoluteStereo(absStereo);
        msearch.setSearchOptions(molSearchOptions);
        msearch.setQuery(queryMolecule);
        return msearch;
    }

    private void setStereoModel(MolSearchOptions searchOptions, int targetType) {
        int model = searchOptions.getStereoModel();
        int searchType = searchOptions.getSearchType();
        if (model == 3) {
            if (targetType == 3) {
                searchOptions.setStereoModel(0);
            } else if (searchType == 2 || searchType == 6) {
                searchOptions.setStereoModel(1);
            } else if (targetType == 4) {
                searchOptions.setStereoModel(0);
            } else {
                searchOptions.setStereoModel(2);
            }
        }
    }

    public static boolean getQueryType(MolSearchOptionsAdapter searchOptions) throws IllegalOptionException {
        Character carr;
        int queryTypeOption = 0;
        if (searchOptions != null && searchOptions.getQueryType() != null && (carr = Character.valueOf(searchOptions.getQueryType().charAt(0))) != null) {
            switch (carr.charValue()) {
                case 'L': 
                case 'l': {
                    queryTypeOption = 1;
                    break;
                }
                case 'R': 
                case 'r': {
                    queryTypeOption = 2;
                    break;
                }
                case 'D': 
                case 'd': {
                    queryTypeOption = 0;
                    break;
                }
                default: {
                    throw new IllegalOptionException(searchOptions.getQueryType() + " for queryType");
                }
            }
        }
        boolean queryType = true;
        if (queryTypeOption == 0) {
            if (searchOptions.getSearchType() == 5 || searchOptions.getSearchType() == 3 || searchOptions.getSearchType() == 6 || searchOptions.getTautomerSearch() == 1) {
                queryType = false;
            }
        } else if (queryTypeOption == 1) {
            queryType = false;
        } else if (queryTypeOption == 2) {
            queryType = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("queryType=" + queryType);
        }
        return queryType;
    }

    private int search(int structureType, chemaxon.sss.search.MolSearch molSearch, boolean isMatchCount, Molecule targetMol, Standardizer standardizer, TautomerSearchParams tautomerGenInfo) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isMatching: target=" + targetMol + ", calcTargetGenericTautomer=" + tautomerGenInfo.isCalcTargetGenericTautomer() + ", protectTautomerChirality=" + tautomerGenInfo.isProtectTautomerChirality());
        }
        if (standardizer != null) {
            TableInfo.standardize(targetMol, standardizer, true);
        }
        if (this.isDuplicateSearch(molSearch.getSearchOptions()) && tautomerGenInfo.isCalcTargetGenericTautomer()) {
            molSearch.setOrigTargetMayBeMarkush(ExpansionUtil.isMarkushMolecule(targetMol));
            targetMol = this.calcGenericTautomer(targetMol, tautomerGenInfo.isProtectTautomerChirality(), tautomerGenInfo.isSwitchOffAllTautomerProtectionTdf());
            MolSearchOptions mso = molSearch.getSearchOptions();
            mso.addUserComparator(new DataSgroupComparator(2, "BEC"));
            molSearch.setSearchOptions(mso);
        }
        molSearch.setTarget(targetMol);
        if (isMatchCount) {
            int matchCount = this.calcMatchCount(molSearch);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("returning matchCount=" + matchCount);
            }
            return matchCount;
        }
        if (molSearch.isMatching()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("returning isMatching=1");
            }
            return 1;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("returning matchCount=0");
        }
        return 0;
    }

    private boolean screen(int structureType, ScreenParams screenInfo, Molecule queryMolecule, Molecule targetMolecule, MolSearchOptions searchOptions) throws Exception {
        if (screenInfo == null || searchOptions.getSearchType() == 5) {
            return true;
        }
        byte[] targetFp = screenInfo.getTargetFp();
        MdMetaData mdmeta = screenInfo.getMdScreenInfo().getMdmeta();
        String mdScreenConfig = screenInfo.getMdScreenInfo().getScreenConfiguration();
        if (structureType == 3) {
            MarkushDescriptor queryDesc = (MarkushDescriptor)InteropMiscellanious.createMd(mdmeta.type, mdmeta.settings, mdScreenConfig);
            DefaultMarkushScreenOptions screenOptions = new DefaultMarkushScreenOptions(searchOptions);
            queryDesc.generateQueryDescriptor(queryMolecule, screenOptions);
            MarkushDescriptor targetDesc = (MarkushDescriptor)InteropMiscellanious.createMd(mdmeta.type, mdmeta.settings, mdScreenConfig);
            targetDesc.fromData(targetFp);
            return queryDesc.acceptTarget(targetDesc);
        }
        return true;
    }

    public static void printMol(String name, Molecule mol) {
        MolSearchImpl.printMol(random.nextInt(), name, mol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMol(int count, String name, Molecule mol) {
        String format2 = "mrv";
        String fileName = name + "_" + count + "." + "mrv";
        logger.finest("Writing " + fileName);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(fileName));
            try {
                String s = MolExporter.exportToFormat(mol, "mrv");
                writer.write(s);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Molecule calcGenericTautomer(Molecule mol, boolean protectTautomerChirality, boolean switchOffAllTautomerProtectionTdf) throws DatabaseSearchException {
        if (logger.isLoggable(Level.FINEST)) {
            MolSearchImpl.printMol(++counter, "in", mol);
        }
        Molecule genericTautomer = null;
        TautomerizationPlugin tautomerizationPlugin = null;
        if (tautomerizationPlugin == null) {
            tautomerizationPlugin = new TautomerizationPlugin();
            tautomerizationPlugin.setLicenseEnvironment("LicenseEnvironmentForFreeIsomersInternalUsage");
            tautomerizationPlugin.setTakeGenericTautomer(true);
            if (switchOffAllTautomerProtectionTdf) {
                TautomerUtil.switchOffAllProtects(tautomerizationPlugin);
            } else {
                tautomerizationPlugin.setProtectAllTetrahedralStereoCenters(protectTautomerChirality);
            }
        }
        try {
            tautomerizationPlugin.setMolecule(mol);
            tautomerizationPlugin.run();
            genericTautomer = tautomerizationPlugin.getStructure(0);
        }
        catch (PluginException e) {
            e.printStackTrace();
            throw new DatabaseSearchException(e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            MolSearchImpl.printMol(counter, "out", genericTautomer);
        }
        return genericTautomer;
    }

    private int calcMatchCount(chemaxon.sss.search.MolSearch msearch) throws Exception {
        return msearch.getMatchCount();
    }

    private Molecule queryToMol(byte[] query, MolSearchOptionsAdapter searchOptions) throws MolFormatException, IllegalOptionException {
        if (query == null || query.equals(" ") || query.equals("null")) {
            return new Molecule();
        }
        boolean queryType = MolSearchImpl.getQueryType(searchOptions);
        return new MolHandler(query, queryType).getMolecule();
    }

    private boolean isDuplicateSearch(SearchOptions searchOptions) {
        return searchOptions.getSearchType() == 5;
    }

    public static void main(String[] args) throws RemoteException {
        String targetFileName = System.getProperty("user.home") + File.separator + "t.mol";
        try {
            String query = "c1cncn1";
            String target = MolSearchImpl.readTarget(targetFileName);
            MolSearchImpl mi = new MolSearchImpl();
            System.out.println(mi.search(new MolSearchParams(3, query.getBytes(), target.getBytes(), 2, "t:s", true, new SearchStandardizationParams(null, true, true), new TautomerSearchParams(false, false, false, false), null)));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private static String readTarget(String fileName) throws IOException {
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        char[] cbuf = new char[4096];
        int count = ((Reader)reader).read(cbuf, 0, cbuf.length);
        while (count != -1) {
            buffer.append(new String(cbuf, 0, count));
            count = ((Reader)reader).read(cbuf, 0, cbuf.length);
        }
        return buffer.toString();
    }

    static {
        random = new Random(System.currentTimeMillis());
    }
}

