/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.RmiTunnel;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.tunnel.JcTableInfo;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.interop.InteropOptions;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.CxOptions;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RmiTunnelImpl
implements RmiTunnel {
    private static Logger logger = Logger.getLogger(RmiTunnelImpl.class.getName());

    @Override
    public Object process(Object param) throws RemoteException {
        try {
            return this.processUc(param);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    private Object processUc(Object obj) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting to process " + obj);
        }
        if (obj instanceof UserInfo) {
            UserInfo userInfo = (UserInfo)obj;
            RmiTunnelImpl.setUserInfo(userInfo);
            return null;
        }
        if (obj instanceof JcTableInfo) {
            JcTableInfo jcTableInfo = (JcTableInfo)obj;
            switch (jcTableInfo.operation) {
                case 1: {
                    this.createJcTable(jcTableInfo);
                    break;
                }
                case 2: {
                    this.regenerateJcTable(jcTableInfo);
                    break;
                }
                case 3: {
                    this.dropJcTable(jcTableInfo);
                    break;
                }
                case 4: {
                    return this.listJcTable(jcTableInfo);
                }
                default: {
                    throw new IllegalArgumentException("Invalid op code: " + jcTableInfo.operation);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalide parameter type: " + obj.getClass().getName());
        }
        return null;
    }

    public static void setUserInfo(UserInfo userInfo) throws Exception {
        RmiTunnelImpl.getCm().changeUserInfo(userInfo);
    }

    public static ConnectionHandler getConnectionHandler(TableOpInfo ii) throws Exception {
        SessionInfo userInfo = ii.getSessionInfo();
        String userName = userInfo.getUserName();
        if (userInfo.getPassword() != null) {
            RmiTunnelImpl.setUserInfo(userInfo);
        }
        ConnectionHandler ch = RmiTunnelImpl.getCm().createConnectionHandler(userInfo, ii.getJcpropTableName(), true);
        return ch;
    }

    public static JCartConnectionManager getCm() throws Exception {
        return JCartConnectionManager.getInstance();
    }

    public static ConnectionHandler getConnectionHandler(JcTableInfo ji, boolean connect) throws Exception {
        SessionInfo userInfo = ji.sessionInfo;
        String userName = userInfo.getUserName();
        if (userInfo.getPassword() != null) {
            RmiTunnelImpl.setUserInfo(userInfo);
        }
        ConnectionHandler ch = RmiTunnelImpl.getCm().createConnectionHandler(userInfo, ji.jcPropTableName, connect);
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJcTable(JcTableInfo jcTableInfo) throws Exception {
        String[] allowedOptions = new String[]{"ctColCfg", "tableType"};
        CxOptions opts = new CxOptions(allowedOptions, jcTableInfo.options);
        Map ctColConfig = RmiTunnelImpl.getChemTermColsCfg(opts);
        int tableType = RmiTunnelImpl.getTableType(opts);
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(jcTableInfo, true);
        try {
            if (!DatabaseProperties.propertyTableExists(ch)) {
                DatabaseProperties.createPropertyTable(ch);
            }
            int numberOfInts = UpdateHandler.FP_DEFAULT_LENGTH_IN_INTS[tableType];
            int numberOfOnes = UpdateHandler.FP_DEFAULT_BITS_PER_PATTERN[tableType];
            int numberOfEdges = UpdateHandler.FP_DEFAULT_PATTERN_LENGTH[tableType];
            if (jcTableInfo.fpProps != null) {
                numberOfInts = jcTableInfo.fpProps[0] / 32;
                numberOfOnes = jcTableInfo.fpProps[1];
                numberOfEdges = jcTableInfo.fpProps[2];
            }
            StructureTableOptions tableOptions = new StructureTableOptions();
            tableOptions.name = jcTableInfo.tableName;
            tableOptions.fp_numberOfInts = numberOfInts;
            tableOptions.fp_numberOfOnes = numberOfOnes;
            tableOptions.fp_numberOfEdges = numberOfEdges;
            tableOptions.extraColumnDefinitions = jcTableInfo.colDefs;
            tableOptions.standardizerConfig = jcTableInfo.standardizerConfig;
            tableOptions.absoluteStereo = jcTableInfo.absoluteStereo;
            tableOptions.chemTermColsConfig = ctColConfig;
            tableOptions.tableType = tableType;
            UpdateHandler.createStructureTable(ch, tableOptions);
            ch.getConnection().commit();
        }
        finally {
            ch.close();
        }
    }

    public static int getTableType(CxOptions opts) {
        String optionName = "tableType";
        String ttString = opts.getStringValue(optionName);
        int tt = RmiTunnelImpl.tableTypeStringToInt(ttString);
        if (tt != Integer.MAX_VALUE) {
            return tt;
        }
        CxOptions.throwBadOptionValueException(ttString.toCharArray(), optionName);
        return -1;
    }

    public static int tableTypeStringToInt(String ttString) {
        if (ttString == null) {
            return 0;
        }
        return InteropOptions.tableTypeStringToInt(ttString);
    }

    public static Map getChemTermColsCfg(CxOptions opts) {
        String optionName = "ctColCfg";
        String ctColCfgString = opts.getStringValue(optionName);
        if (ctColCfgString == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(ctColCfgString, ";");
        while (tokenizer.hasMoreTokens()) {
            String ss = tokenizer.nextToken();
            int eqsPos = ss.indexOf(61);
            if (eqsPos == -1) {
                throw new IllegalArgumentException("Invalid format for " + optionName + ": " + ss);
            }
            map.put(ss.substring(0, eqsPos).toUpperCase(), ss.substring(eqsPos + 1));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regenerateJcTable(JcTableInfo jcTableInfo) throws Exception {
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(jcTableInfo, false);
        ch.connect();
        try {
            UpdateHandler.recalculateTable(ch, jcTableInfo.tableName, jcTableInfo.standardizerConfig != null, jcTableInfo.standardizerConfig, null, null, null);
        }
        finally {
            ch.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropJcTable(JcTableInfo jcTableInfo) throws Exception {
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(jcTableInfo, true);
        try {
            UpdateHandler.dropStructureTable(ch, jcTableInfo.tableName);
        }
        finally {
            ch.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String listJcTable(JcTableInfo jcTableInfo) throws Exception {
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(jcTableInfo, true);
        try {
            StringBuffer b = new StringBuffer();
            DatabaseProperties dbProps = new DatabaseProperties(ch);
            Vector<String> v = dbProps.getStructureTableNames();
            for (String tableName : v) {
                b.append(tableName).append("{sep}");
            }
            String string = b.toString();
            return string;
        }
        finally {
            ch.close();
        }
    }

    @Override
    public void purgeConnectionCache(String userName) throws RemoteException {
        try {
            JCartConnectionManager.getInstance().purgeCache(userName);
        }
        catch (Exception e) {
            RmiExceptionHandler.handleError(logger, (Throwable)e);
        }
    }
}

