/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.errcache;

import chemaxon.jchem.cartridge.rmi.impl.errcache.ErrorRecordWrapper;
import chemaxon.jchem.cartridge.tunnel.search.ErrorRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class SessionErrors {
    private volatile long emptySessionErrorsExpirationTime = 2419200000L;
    private volatile long errorRecordExpirationTime = 3600000L;
    private volatile boolean removeRecordsWhenAccessed = true;
    private volatile Date emptySince;
    private List<ErrorRecordWrapper> errors = new Vector<ErrorRecordWrapper>();

    SessionErrors() {
    }

    public synchronized void addRecord(ErrorRecord errorRecord) {
        this.emptySince = null;
        this.errors.add(new ErrorRecordWrapper(errorRecord));
    }

    public synchronized void removeOldErrors() {
        Date olderThan = null;
        Iterator<ErrorRecordWrapper> iter = this.errors.iterator();
        while (iter.hasNext()) {
            if (olderThan == null) {
                olderThan = this.olderThan(this.errorRecordExpirationTime);
            }
            ErrorRecordWrapper wrapper = iter.next();
            if (!wrapper.timeStamp.before(olderThan)) continue;
            iter.remove();
        }
        this.checkEmpty();
    }

    public synchronized ErrorRecord[] getErrorRecords(int count) {
        ArrayList<ErrorRecord> l = new ArrayList<ErrorRecord>();
        Iterator<ErrorRecordWrapper> iter = this.errors.iterator();
        for (int i = 0; iter.hasNext() && i < count; ++i) {
            ErrorRecord record = iter.next().errorRecord;
            l.add(record);
            if (!this.removeRecordsWhenAccessed) continue;
            iter.remove();
        }
        ErrorRecord[] records = new ErrorRecord[l.size()];
        l.toArray(records);
        return records;
    }

    public synchronized ErrorRecord[] getErrorRecords(Long scanId, int count) {
        ArrayList<ErrorRecord> l = new ArrayList<ErrorRecord>();
        Iterator<ErrorRecordWrapper> iter = this.errors.iterator();
        for (int i = 0; iter.hasNext() && i < count; ++i) {
            ErrorRecord record = iter.next().errorRecord;
            if (scanId != null && record.getScanId() != (long)scanId.intValue()) continue;
            l.add(record);
            if (!this.removeRecordsWhenAccessed) continue;
            iter.remove();
        }
        if (scanId == null) {
            this.checkEmpty();
        }
        ErrorRecord[] records = new ErrorRecord[l.size()];
        l.toArray(records);
        return records;
    }

    public synchronized int getErrorCount() {
        return this.errors.size();
    }

    public synchronized void clearErrors() {
        this.errors.clear();
        this.checkEmpty();
    }

    public synchronized boolean isEmptyLongEnough() {
        if (this.emptySince == null) {
            return false;
        }
        return this.emptySince.before(this.olderThan(this.emptySessionErrorsExpirationTime));
    }

    public void setEmptySessionErrorsExpirationTime(long emptySessionErrorsExpirationTime) {
        this.emptySessionErrorsExpirationTime = emptySessionErrorsExpirationTime;
    }

    public void setErrorRecordExpirationTime(long errorRecordExpirationTime) {
        this.errorRecordExpirationTime = errorRecordExpirationTime;
    }

    public void setRemoveRecordsOnAccess(boolean removeRecordsWhenAccessed) {
        this.removeRecordsWhenAccessed = removeRecordsWhenAccessed;
    }

    private void checkEmpty() {
        if (this.errors.size() == 0 && this.emptySince == null) {
            this.emptySince = new Date();
        }
    }

    private Date olderThan(long expirationTime) {
        return new Date(new Date().getTime() - expirationTime);
    }
}

