/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.scanresult;

import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.jctable.ColumnTypeHandler;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.TableScanBaseImpl;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.util.CardinalPredicat;
import chemaxon.util.IntArray;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoCalcCtColScan
extends TableScanBaseImpl {
    private static Logger logger = Logger.getLogger(AutoCalcCtColScan.class.getName());
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private int chunkSize;
    private EvalChemTermInfo evalCtInfo;
    private String ctColName;
    private CardinalPredicat cardinalPredicat;
    private IntArray results = new IntArray();
    private volatile Throwable error;
    private boolean done;

    public AutoCalcCtColScan(int chunkSize, EvalChemTermInfo evalCtInfo, String ctColName) throws Exception {
        super(evalCtInfo);
        this.chunkSize = chunkSize;
        this.evalCtInfo = evalCtInfo;
        this.ctColName = ctColName;
        this.init(evalCtInfo.getIndexTableQName());
    }

    private void init(String idxTableQName) throws Exception {
        this.cardinalPredicat = new CardinalPredicat(this.evalCtInfo.getPredicateInfo());
        WorkUnitManager.getInstance().submit(new AutoCalcCtColReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() throws Exception {
        try {
            super.dispose();
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            finally {
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int[] getNextHits0() throws RemoteException {
        int[] nextHits = null;
        IntArray intArray = this.results;
        synchronized (intArray) {
            while (this.results.size() < this.chunkSize && !this.done) {
                try {
                    this.results.wait();
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "Interrupted", e);
                    }
                    if (this.error != null) continue;
                    this.error = e;
                }
            }
            this.checkError();
            nextHits = this.results.toArray();
            this.results.clear();
        }
        return nextHits;
    }

    private void checkError() throws RemoteException {
        if (this.error != null) {
            block3: {
                try {
                    this.dispose();
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block3;
                    logger.log(Level.SEVERE, "error", e);
                }
            }
            throw new RemoteException(this.error.getMessage());
        }
    }

    private class AutoCalcCtColReader
    implements Callable<Object> {
        private DbSession dbSession;

        private AutoCalcCtColReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            try {
                AutoCalcCtColScan.this.conn = JCartConnectionManager.getInstance().getConnection(AutoCalcCtColScan.this.evalCtInfo.getSessionInfo());
                this.dbSession = new ClientSideSession(AutoCalcCtColScan.this.conn);
                AutoCalcCtColScan.this.pstmt = AutoCalcCtColScan.this.conn.prepareStatement("select cd_id, " + AutoCalcCtColScan.this.ctColName + " from " + AutoCalcCtColScan.this.evalCtInfo.getIndexTableQName());
                AutoCalcCtColScan.this.rs = AutoCalcCtColScan.this.pstmt.executeQuery();
                int cdId = this.getNextHit();
                while (cdId > -1) {
                    IntArray intArray = AutoCalcCtColScan.this.results;
                    synchronized (intArray) {
                        AutoCalcCtColScan.this.results.add(cdId);
                        if (AutoCalcCtColScan.this.results.size() >= AutoCalcCtColScan.this.chunkSize) {
                            AutoCalcCtColScan.this.results.notify();
                        }
                    }
                    cdId = this.getNextHit();
                }
            }
            catch (Throwable throwable) {
                AutoCalcCtColScan.this.error = throwable;
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "error", throwable);
                }
            }
            finally {
                IntArray cdId = AutoCalcCtColScan.this.results;
                synchronized (cdId) {
                    AutoCalcCtColScan.this.done = true;
                    AutoCalcCtColScan.this.results.notify();
                }
            }
            return null;
        }

        private int getNextHit() throws Exception {
            int cdId = -1;
            while (AutoCalcCtColScan.this.rs.next()) {
                int cid = AutoCalcCtColScan.this.rs.getInt(1);
                String idxTableQName = AutoCalcCtColScan.this.evalCtInfo.getIndexTableQName();
                String value = ColumnTypeHandler.getValue(this.dbSession, idxTableQName, AutoCalcCtColScan.this.evalCtInfo.getJcpropTableName(), AutoCalcCtColScan.this.evalCtInfo.isJchemTable(), AutoCalcCtColScan.this.ctColName, AutoCalcCtColScan.this.rs, 2);
                if (value == null || !this.isHit(value)) continue;
                cdId = cid;
                break;
            }
            return cdId;
        }

        private boolean isHit(String value) {
            return AutoCalcCtColScan.this.cardinalPredicat.isMatching(Double.parseDouble(value));
        }
    }
}

