/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.scanresult;

import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.impl.RemoteTask;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.tunnel.TableScanInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.util.CxOptions;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public abstract class TableScanBaseImpl
extends RemoteTask
implements TableScan {
    private static final Logger logger = Logger.getLogger(TableScanBaseImpl.class.getName());
    private static final ConcurrentHashMap<String, String> idxNameReverseMap = new ConcurrentHashMap();
    private TableScanInfo tableScanInfo;
    private volatile CxOptions cxOptions;

    public TableScanBaseImpl(TableScanInfo tableScanInfo) throws IOException {
        super(tableScanInfo.getSessionInfo(), tableScanInfo.getUserAssignedId(), tableScanInfo.toString(), TableScanBaseImpl.getScanResultTimeout(tableScanInfo));
        idxNameReverseMap.put(tableScanInfo.getIndexTableQName(), tableScanInfo.getIndexSchemaName() + "." + tableScanInfo.getIndexName());
        this.tableScanInfo = tableScanInfo;
    }

    public static int getScanResultTimeout(TableScanInfo tableScanInfo) {
        CxOptions cxOptions = new CxOptions(tableScanInfo.getOptions());
        String s = cxOptions.getStringValue("resultTimeout");
        if (s == null) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    @Override
    public Long getMemoryUsage() throws Exception {
        return null;
    }

    @Override
    public int[] getNextHits() throws RemoteException {
        try {
            this.touch();
            return this.getNextHits0();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            assert (false);
            return null;
        }
    }

    protected int getThreadCount(String workerCountPropertyName) throws IOException {
        return TableScanBaseImpl.getThreadCount(this.tableScanInfo, workerCountPropertyName);
    }

    public static int getThreadCount(TableScanInfo tableScanInfo, String workerCountPropertyName) throws IOException {
        int threadCount = tableScanInfo.getThreadCount();
        if (threadCount <= 0) {
            threadCount = JccConfig.getInstance().getThreadCount(workerCountPropertyName);
        }
        return threadCount;
    }

    public static int getThreadCount(TableScanInfo tableScanInfo, int defaultThreadCount) throws IOException {
        int threadCount = tableScanInfo.getThreadCount();
        if (threadCount <= 0) {
            threadCount = defaultThreadCount;
        }
        return threadCount;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[super=" + super.toString() + ",tableScanInfo=" + this.tableScanInfo + "]";
    }

    protected abstract int[] getNextHits0() throws Exception;

    public static final String getIndexNameByIdxTableQName(String idxTableQName) {
        return idxNameReverseMap.get(idxTableQName);
    }

    @Override
    public Long getSearchId() throws RemoteException {
        return new Long(this.getId());
    }

    protected CxOptions getCxOptions() {
        if (this.cxOptions == null) {
            this.cxOptions = new CxOptions(this.tableScanInfo.getOptions());
        }
        return this.cxOptions;
    }
}

