/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.scanresult;

import chemaxon.jchem.cartridge.JChemCartEvalModule;
import chemaxon.jchem.cartridge.JChemCartModule;
import chemaxon.jchem.cartridge.tunnel.UserDefFuncInfo;
import chemaxon.jchem.cartridge.tunnel.search.PredicateInfo;
import chemaxon.util.hitfinder.HitFinder;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDefFuncHitFinder
implements HitFinder<String> {
    private static final Log log = LogFactory.getLog(UserDefFuncHitFinder.class);
    private JChemCartModule userDefinedCalc;
    private JChemCartEvalModule userDefinedEval;
    private String[] parameters;
    private PredicateInfo predInfo;

    public UserDefFuncHitFinder(UserDefFuncInfo userDefFuncInfo) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(userDefFuncInfo.getUserDefClassName());
        this.userDefinedCalc = (JChemCartModule)clazz.newInstance();
        clazz = Class.forName(userDefFuncInfo.getUserDefClassName() + "_eval");
        this.userDefinedEval = (JChemCartEvalModule)clazz.newInstance();
        this.parameters = UserDefFuncHitFinder.parseParamStr(userDefFuncInfo.getParamDelimiter(), userDefFuncInfo.getParameters());
        this.predInfo = userDefFuncInfo.getPredicateInfo();
    }

    @Override
    public boolean yieldsHit(String struct) throws Exception {
        if (struct == null) {
            return false;
        }
        this.parameters[0] = struct;
        Object o = this.userDefinedCalc.doFunc(this.parameters);
        return this.userDefinedEval.eval(o, this.predInfo.toString());
    }

    private static String[] parseParamStr(String delim, String param) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("delim=" + delim + ", param=" + param));
        }
        ArrayList<String> valueList = null;
        if (param != null) {
            valueList = new ArrayList<String>();
            valueList.add(null);
            int paramStart = 0;
            int paramEnd = param.indexOf("{PARAM}");
            while (paramEnd > -1) {
                String paramValue = param.substring(paramStart, paramEnd);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("paramValue=" + paramValue));
                }
                valueList.add(paramValue);
                paramStart = paramEnd + "{PARAM}".length();
                paramEnd = param.indexOf("{PARAM}", paramStart);
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return null;
    }
}

