/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.server.task;

import chemaxon.jchem.cartridge.rmi.JccSecurityException;
import chemaxon.jchem.cartridge.rmi.KilledTaskException;
import chemaxon.jchem.cartridge.server.task.TimedResource;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.TaskInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Task
extends TimedResource {
    private static final Logger logger = Logger.getLogger(Task.class.getName());
    private static AtomicLong taskCounter = new AtomicLong();
    private static final ConcurrentHashMap<Long, Task> taskList = new ConcurrentHashMap();
    private long id;
    private String jccSessionId;
    private String userName;
    private String userAssignedOp;
    private Date startTime;
    private String description;

    protected Task(SessionInfo sessionInfo, String userAssignedOp, String description, int timeOutInSeconds) throws IOException {
        super(timeOutInSeconds);
        this.jccSessionId = sessionInfo.getSessionId();
        this.userName = sessionInfo.getUserName();
        this.userAssignedOp = userAssignedOp;
        this.description = description;
        this.id = taskCounter.incrementAndGet();
        this.startTime = GregorianCalendar.getInstance().getTime();
        taskList.put(this.id, this);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Task is created: " + this);
        }
    }

    private Task(Task task, int timeOutInSeconds) throws IOException {
        super(timeOutInSeconds);
        this.id = task.id;
        this.jccSessionId = task.jccSessionId;
        this.userName = task.userName;
        this.userAssignedOp = task.userAssignedOp;
        this.description = "*** Zombie *** of " + task.description;
        this.startTime = task.startTime;
        taskList.put(this.id, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Called", new Exception("trace call stack"));
        }
        try {
            super.dispose();
        }
        finally {
            taskList.remove(this.id);
        }
    }

    public long getId() {
        return this.id;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public TaskInfo toTaskInfo() throws Exception {
        TaskInfo ti = new TaskInfo();
        ti.id = this.id;
        ti.jccSessionId = this.jccSessionId;
        ti.userName = this.userName;
        ti.userAssignedOpId = this.userAssignedOp;
        ti.startTime = this.startTime;
        ti.memoryUsed = this.getMemoryUsage();
        ti.description = this.getDescription();
        ti.timeout = this.getTimeout();
        ti.lastRescheduled = this.getLastRescheduleDate();
        return ti;
    }

    @Override
    public String toString() {
        try {
            return this.getClass().getName() + " [id=" + this.id + ", jccSessionId=" + this.jccSessionId + ", userName=" + this.userName + ", userAssignedOp=" + this.userAssignedOp + ", startTime=" + this.startTime + ", description=" + this.getDescription() + ", memoryUsed=" + this.getMemoryUsage() + "]";
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static String listActiveTasks() {
        StringBuffer sb = new StringBuffer();
        Iterator<Task> iter = taskList.values().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(sb.toString());
        }
        return sb.toString();
    }

    public static TaskInfo[] getTaskInfos(String userId) throws Exception {
        ArrayList<TaskInfo> l = new ArrayList<TaskInfo>();
        for (Task task : taskList.values()) {
            if (userId != null && !userId.equals(task.userName)) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Adding " + task.getClass().getName() + "@" + task.id);
            }
            l.add(task.toTaskInfo());
        }
        TaskInfo[] ta = new TaskInfo[l.size()];
        l.toArray(ta);
        return ta;
    }

    public static synchronized int killTask(String userId, Long taskId) throws Exception {
        Task task = taskList.get(taskId);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Found " + task + " for taskId=" + taskId);
        }
        if (task == null) {
            return 0;
        }
        if (userId == null || userId.equals(task.userName)) {
            if (task instanceof ZombieTask) {
                taskList.remove(taskId);
                return 1;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Killing " + task.getClass().getName() + ": " + task.toString());
            }
            task.dispose();
            new ZombieTask(task, userId);
            return 1;
        }
        throw new JccSecurityException(userId + " is not allowed to kill tasks of " + task.userName);
    }

    public static int removeZombies(String userId) {
        int count = 0;
        Iterator<Task> iter = taskList.values().iterator();
        while (iter.hasNext()) {
            Task task = iter.next();
            if (userId != null && !userId.equals(task.userName) || !(task instanceof ZombieTask)) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Removing " + task.getClass().getName() + "@" + task.id + " as zombie");
            }
            iter.remove();
            ++count;
        }
        return count;
    }

    public static synchronized Task get(long id) throws KilledTaskException {
        Task task = taskList.get(id);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Found " + task + " for id=" + id);
        }
        if (task instanceof ZombieTask) {
            ZombieTask zombie = (ZombieTask)task;
            zombie.tryToCatchMe();
        }
        return task;
    }

    public static void dispose(long id) throws Exception {
        Task task = taskList.get(id);
        if (task != null) {
            task.dispose();
        }
    }

    public static long intArrayMemory(int size) {
        return (long)((double)(size * 4) * 1.01);
    }

    public static class ZombieTask
    extends Task {
        private Date deathDate = new Date();
        private String killerUserId;

        protected ZombieTask(Task task, String killerUserId) throws IOException {
            super(task, JccConfig.getInstance().getInt("chemaxon.jchem.cartridge.zombie.task.timeout", 86400));
            this.killerUserId = killerUserId;
        }

        @Override
        public Long getMemoryUsage() throws Exception {
            return 0L;
        }

        private void tryToCatchMe() throws KilledTaskException {
            throw new KilledTaskException("Task killed by " + this.killerUserId + " on " + this.deathDate);
        }
    }
}

