/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.server.task;

import chemaxon.jchem.cartridge.server.task.Resource;
import chemaxon.jchem.cartridge.server.task.ResourceTimer;
import chemaxon.jchem.cartridge.server.task.ResourceTimerImpl;
import chemaxon.jchem.cartridge.util.JccConfig;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimedResource
implements Resource {
    private static final Logger logger = Logger.getLogger(TimedResource.class.getName());
    public static final String GLOBAL_TIMEOUT_KEY = "scanresult.timeout";
    public static final int DEFAULT_GLOBAL_TIMEOUT = 0;
    private ResourceTimer timer;

    protected TimedResource(int timeOutInSeconds) throws IOException {
        this.timer = this.createTimer(timeOutInSeconds);
    }

    @Override
    public void dispose() throws Exception {
        this.timer.cancel();
    }

    private ResourceTimer createTimer(int optionTimeout) throws IOException {
        int effectiveTimeout = this.getTimeout(optionTimeout);
        if (effectiveTimeout <= 0) {
            return TimedResource.createNullTimer();
        }
        return new ResourceTimerImpl(this, effectiveTimeout);
    }

    private int getTimeout(int timeout) throws IOException {
        if (timeout != -1) {
            return timeout;
        }
        return this.getTimeoutFromConfig();
    }

    private int getTimeoutFromConfig() throws IOException {
        int timeout;
        int t = this.getResourceSpecificTimeout();
        int n = timeout = t > -1 ? t : this.getGlobalTimeout();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning " + timeout + "...");
        }
        return timeout;
    }

    private int getGlobalTimeout() throws IOException {
        int timeout = 0;
        String s = JccConfig.getInstance().getProperty(GLOBAL_TIMEOUT_KEY);
        if (s != null) {
            timeout = Integer.parseInt(s);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning " + timeout + "...");
        }
        return timeout;
    }

    private int getResourceSpecificTimeout() throws IOException {
        String srName = this.getClass().getName();
        int lastDotPos = srName.lastIndexOf(46);
        String s = JccConfig.getInstance().getProperty(srName.substring(lastDotPos + 1) + ".timeout");
        if (s == null) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private static ResourceTimer createNullTimer() {
        return new ResourceTimer(){

            @Override
            public void touch() {
            }

            @Override
            public void cancel() {
            }

            @Override
            public Integer getTimeout() {
                return null;
            }

            @Override
            public Date getLastRescheduleDate() {
                return null;
            }
        };
    }

    protected void touch() {
        this.timer.touch();
    }

    public Integer getTimeout() {
        return this.timer.getTimeout();
    }

    public Date getLastRescheduleDate() {
        return this.timer.getLastRescheduleDate();
    }

    public String toString() {
        long timeout = -1L;
        if (this.timer != null) {
            Integer to = this.timer.getTimeout();
            timeout = to == null ? -1L : (long)to.intValue();
        }
        Date lastRescheduleDate = null;
        if (this.timer != null) {
            lastRescheduleDate = this.timer.getLastRescheduleDate();
        }
        return this.getClass().getName() + "[super=" + super.toString() + ",timeout=" + timeout + ",lastRescheduled=" + lastRescheduleDate + "]";
    }
}

