/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing;

import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.util.DatabaseTools;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MdParams {
    private static final Logger logger = Logger.getLogger(MdParams.class.getName());
    public static final String PARAM_SEPARATOR = ";";
    public static final char PARAM_NVDIVIDER = '=';
    private String name;
    private String type;
    private String settings;
    private String comment;

    public void createMdTable(MDTableHandler mdTableHandler) throws SQLException {
        block3: {
            try {
                mdTableHandler.deleteMDTable(this.name);
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("MD Table for " + this.name + " has been deleted.");
                }
            }
            catch (SQLException sqlException) {
                if (sqlException.getErrorCode() == 942) break block3;
                throw sqlException;
            }
        }
        mdTableHandler.createMDTable(this.name, this.type, this.settings, this.comment, true);
    }

    public static MdParams createDefaultMdConf(String params) {
        String mdShortTypeName = null;
        String mdName = null;
        int colonPos = params.indexOf(58);
        if (colonPos > -1) {
            mdShortTypeName = params.substring(0, colonPos);
            mdName = params.substring(colonPos + 1);
        } else {
            mdShortTypeName = params;
            mdName = params;
        }
        MdParams mdParams = new MdParams();
        mdParams.name = mdName;
        MolecularDescriptor md = MolecularDescriptor.newInstance(mdShortTypeName);
        mdParams.type = md.getClass().getName();
        mdParams.comment = mdShortTypeName + " with default settings";
        return mdParams;
    }

    public static MdParams[] extractInstanceArray(Connection connection, String mdDescParams, boolean hasType) throws IOException, SQLException {
        if (mdDescParams.toLowerCase().startsWith("select ")) {
            return MdParams.instanceArrayFromFullSql(connection, mdDescParams, hasType);
        }
        return MdParams.instanceArrayFromPropertyFile(mdDescParams, hasType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MdParams[] instanceArrayFromPropertyFile(String mdDescParams, boolean hasType) throws IOException {
        Properties mdDescList = new Properties();
        FileInputStream is = new FileInputStream(mdDescParams);
        try {
            mdDescList.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        ArrayList<MdParams> paramsList = new ArrayList<MdParams>();
        String pcString = mdDescList.getProperty("descriptor.count");
        if (pcString == null) {
            throw new IllegalArgumentException("'descriptor.count' property is missing from file '" + mdDescParams);
        }
        int paramCount = Integer.parseInt(pcString);
        for (int i = 0; i < paramCount; ++i) {
            int ix = i + 1;
            MdParams params = new MdParams();
            params.name = MdParams.getProperty(mdDescList, "mdname." + ix);
            params.comment = MdParams.getProperty(mdDescList, "mdcomment." + ix);
            params.settings = MdParams.getSettings(mdDescList, "mdsettingsfile." + ix);
            if (hasType) {
                params.type = MolecularDescriptor.newInstanceFromXML(params.settings).getClass().getName();
            }
            paramsList.add(params);
        }
        MdParams[] mdParamsArr = new MdParams[paramsList.size()];
        paramsList.toArray(mdParamsArr);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("returning " + mdParamsArr.length + " parameter sets...");
        }
        return mdParamsArr;
    }

    private static String getProperty(Properties mdDescList, String key) {
        String value = mdDescList.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Expected property '" + key + "' not found.");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("returning " + value + "...");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSettings(Properties mdDescList, String key) throws IOException {
        String fileName = MdParams.getProperty(mdDescList, key);
        FileReader reader = new FileReader(fileName);
        try {
            StringWriter sw = new StringWriter();
            char[] cbuf = new char[4096];
            int count = reader.read(cbuf);
            while (count != -1) {
                sw.append(new String(cbuf, 0, count));
                count = reader.read(cbuf);
            }
            String string = sw.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MdParams[] instanceArrayFromFullSql(Connection conn, String sql, boolean hasType) throws SQLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("sql=\"" + sql + "\"");
        }
        ArrayList<MdParams> paramsList = new ArrayList<MdParams>();
        ResultSet rs = null;
        PreparedStatement ps = conn.prepareStatement(sql);
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                MdParams params = new MdParams();
                params.name = DatabaseTools.readString(rs, 1);
                params.comment = DatabaseTools.readString(rs, 2);
                params.settings = DatabaseTools.readString(rs, 3);
                if (hasType) {
                    params.type = MolecularDescriptor.newInstanceFromXML(params.settings).getClass().getName();
                }
                paramsList.add(params);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        MdParams[] parr = new MdParams[paramsList.size()];
        paramsList.toArray(parr);
        return parr;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public String getSettings() {
        return this.settings;
    }

    public String getType() {
        return this.type;
    }
}

