/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.IndexDataQueueProcessor;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.IndexingWorker;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.concurrent.util.Timeout;
import chemaxon.util.concurrent.worker.Worker;
import chemaxon.util.concurrent.worker.WorkerController;
import chemaxon.util.concurrent.worker.WorkerFactory;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConcurrentIndexBuilder {
    private static final Logger logger = Logger.getLogger(ConcurrentIndexBuilder.class.getName());
    private String userName;
    private int threadCount;
    protected AtomicLong indexCounter = new AtomicLong();

    public ConcurrentIndexBuilder(String userName, int threadCount) {
        this.userName = userName;
        this.threadCount = threadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void build(ConnectionHandler ch, String getSourceDataSql, IndexDataQueueProcessor indexDataQueueProcessor) throws Exception {
        ResultSet sourceDataSet = null;
        PreparedStatement ps = ch.getConnection().prepareStatement(getSourceDataSql);
        try {
            this.parametrizeSql(ps);
            final ResultSet finalSourceDataSet = sourceDataSet = ps.executeQuery();
            WorkerFactory<Integer> workerFactory = new WorkerFactory<Integer>(){

                @Override
                public Worker<Integer> createWorker() throws Exception {
                    return new IndexingWorker(ConcurrentIndexBuilder.this.createStructIndexer(), finalSourceDataSet, ConcurrentIndexBuilder.this.indexCounter);
                }
            };
            if (this.threadCount == 0) {
                this.threadCount = JccConfig.getInstance().getIndexingThreadsPerCall();
            }
            WorkerController<Integer, Integer> workerController = new WorkerController<Integer, Integer>(this.threadCount, (WorkerFactory)workerFactory, new Timeout(60000L)){

                @Override
                protected Integer processWorkerResult(Integer workerResult, Integer workerControllerResult) {
                    if (workerControllerResult == null) {
                        return new Integer(workerResult);
                    }
                    return new Integer(workerResult + workerControllerResult);
                }
            };
            ExecutorCompletionService<Integer> ecs = new ExecutorCompletionService<Integer>(WorkUnitManager.getInstance());
            Future<Integer> fInserter = null;
            Future<Integer> fWorkers = ecs.submit(workerController);
            if (indexDataQueueProcessor != null) {
                fInserter = ecs.submit(indexDataQueueProcessor);
            }
            try {
                Future f = ecs.take();
                if (f.equals(fInserter)) {
                    workerController.cancel();
                } else if (indexDataQueueProcessor != null) {
                    indexDataQueueProcessor.closeQueue();
                }
                f.get();
            }
            finally {
                if (indexDataQueueProcessor != null) {
                    ecs.take().get();
                }
            }
            ConcurrentIndexBuilder.handleDeferredErrors(fWorkers.get());
        }
        catch (SQLException sqlE) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Failing statement (" + this.userName + "): " + getSourceDataSql);
            }
            throw sqlE;
        }
        finally {
            try {
                if (sourceDataSet != null) {
                    sourceDataSet.close();
                }
            }
            finally {
                ps.close();
            }
        }
    }

    public static void handleDeferredErrors(int deferredErrorCount) throws Exception {
        if (deferredErrorCount > 0) {
            throw new Exception(deferredErrorCount + " structure(s) could not be indexed. " + "Please, check the JChem Server logs.");
        }
    }

    private void parametrizeSql(PreparedStatement ps) {
    }

    protected abstract StructHandler createStructIndexer() throws Exception;
}

