/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.ctcol.ChemTermColSupport;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.servlets.indexing.CtColDefList;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexCreate;
import chemaxon.jchem.cartridge.tunnel.index.AlterIndexInfo;
import chemaxon.jchem.db.CTColumnRegenerator;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.RecalculationException;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCartIndexAlter {
    private static final Logger logger = Logger.getLogger(JCartIndexAlter.class.getName());
    private AlterIndexInfo aii;
    private DbSession dbSession;

    public JCartIndexAlter(AlterIndexInfo ii) {
        this.aii = ii;
    }

    public void execute() throws Exception {
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(this.aii);
        try {
            this.dbSession = new ClientSideSession(ch.getConnection());
            this.deleteCts(ch, this.aii);
            String[] ctColNamesToAdd = this.addCts(ch, this.aii);
            if (ctColNamesToAdd != null) {
                this.regenCtCols(this.aii, ch, ctColNamesToAdd);
            }
            DatabaseProperties dbProp = new DatabaseProperties(ch, true);
            TableInfo.resetTableValidityTimestamp(dbProp, this.aii.getIndexTableQName());
            ch.getConnection().commit();
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    ch.getConnection().rollback();
                }
                catch (SQLException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block10;
                    logger.log(Level.SEVERE, "error", e);
                }
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
        finally {
            ch.close();
        }
    }

    public void deleteCts(ConnectionHandler ch, AlterIndexInfo aii) throws Exception {
        String tableName = aii.getIndexTableQName().toUpperCase();
        DatabaseProperties dbProperties = new DatabaseProperties(ch, true);
        String[] delCts = aii.getDelCts();
        String[] ctColNames = this.getCtColNames(aii.getJcpropTableName(), tableName, delCts);
        this.deleteCts(ch, dbProperties, tableName, ctColNames);
        ctColNames = aii.getDelCtsWcn();
        this.deleteCts(ch, dbProperties, tableName, ctColNames);
    }

    private void deleteCts(ConnectionHandler ch, DatabaseProperties dbProperties, String tableName, String[] ctColNames) throws SQLException {
        if (ctColNames == null || ctColNames.length == 0) {
            return;
        }
        for (int i = 0; i < ctColNames.length; ++i) {
            this.dropColumn(ch.getConnection(), tableName, ctColNames[i]);
            dbProperties.deleteChemTermForColumn(tableName, ctColNames[i]);
        }
    }

    private String[] getCtColNames(String jcptName, String tableName, String[] delCts) throws Exception {
        if (delCts == null) {
            return null;
        }
        String[] ctColNames = new String[delCts.length];
        for (int i = 0; i < delCts.length; ++i) {
            String delct = delCts[i];
            String ctColName = new ChemTermColSupport(this.dbSession).getChemTermColumn(jcptName, tableName, false, delct);
            if (ctColName == null) {
                throw new IllegalArgumentException("No autocalc column for " + delct);
            }
            ctColNames[i] = ctColName;
        }
        return ctColNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection conn, String tableQName, String ctColName) throws SQLException {
        String sql = "alter table " + tableQName + " drop column " + ctColName;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] addCts(ConnectionHandler ch, AlterIndexInfo aii) throws Exception {
        Set existingCtColNames = JCartIndexAlter.getExistingCtColNames(this.dbSession, aii);
        CtColDefList ctColDefList = new CtColDefList(existingCtColNames);
        ctColDefList.addDefListStrings(aii.getAddCtsWcn(), true);
        ctColDefList.addDefListStrings(aii.getAddCts(), false);
        CtColDefList.CtColDef[] ctColDefs = ctColDefList.toArray();
        if (ctColDefs == null || ctColDefs.length == 0) {
            return null;
        }
        String[] ctColNamesToAdd = new String[ctColDefs.length];
        StringBuffer addClauses = new StringBuffer();
        for (int i = 0; i < ctColDefs.length; ++i) {
            CtColDefList.CtColDef ctColDef = ctColDefs[i];
            addClauses.append(" add (").append(ctColDef.getColName()).append(" ").append(ctColDef.getColType()).append(")");
            ctColNamesToAdd[i] = ctColDef.getColName();
        }
        String sql = "alter table " + aii.getIndexTableQName() + " " + addClauses.toString();
        Statement stmt = this.dbSession.getConnection().createStatement();
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Executing " + sql + "...");
            }
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        JCartIndexCreate.setCtColumns(this.dbSession, aii.getJcpropTableName(), aii.getIndexTableQName(), ctColDefList);
        return ctColNamesToAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getExistingCtColNames(DbSession dbSession, AlterIndexInfo aii) throws Exception {
        String owner = aii.getIndexSchemaName();
        String tableName = InteropUtil.getTableBaseName(aii.getIndexTableQName());
        HashSet<String> existingCtColNames = new HashSet<String>();
        String sql = "select column_name from all_tab_columns where owner = ? and table_name = ? and column_name like 'CHEMTERM%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Executing " + sql + " using " + owner + ", " + tableName + "...");
        }
        PreparedStatement pstmt = dbSession.prepareStatement(sql);
        int paramIdx = 1;
        pstmt.setString(paramIdx++, owner);
        pstmt.setString(paramIdx++, tableName);
        try {
            ResultSet rs = pstmt.executeQuery();
            try {
                while (rs.next()) {
                    existingCtColNames.add(rs.getString(1));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            pstmt.close();
        }
        return existingCtColNames;
    }

    public void regenCtCols(AlterIndexInfo aii, ConnectionHandler ch, String[] addCtCols) throws SQLException, PropertyNotSetException {
        final Log log = LogFactory.getLog(JCartIndexCreate.class);
        ProgressWriter pw = new ProgressWriter("Alter Index", 0L, 100L);
        pw.addLogger(new ProgressWriter.Logger(){

            @Override
            public void addMessage(int severity, String message, Throwable t) {
                switch (severity) {
                    case 0: {
                        if (!log.isErrorEnabled()) break;
                        log.error((Object)message, t);
                        break;
                    }
                    case 1: {
                        if (!log.isWarnEnabled()) break;
                        log.warn((Object)message, t);
                        break;
                    }
                    case 2: {
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)message, t);
                    }
                }
            }
        });
        try {
            CTColumnRegenerator ctregen = new CTColumnRegenerator(ch, aii.getIndexTableQName(), addCtCols, pw, 0, aii.getBaseSchemaName() + "." + aii.getBaseTableName(), aii.getIndexedColumn());
            ctregen.run();
        }
        catch (RecalculationException e) {
            throw new RuntimeException(e);
        }
    }
}

