/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.rmi.impl.RemoteTask;
import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class JCartIndexBase
extends RemoteTask {
    private static final Logger logger = Logger.getLogger(JCartIndexBase.class.getName());
    protected IndexingInfo ii;
    protected JcMetaDataFunctions metaData;
    protected ConnectionHandler ch;
    protected DbSession dbSession;
    protected JCartIndexDescriptor idxDesc;

    public JCartIndexBase(IndexingInfo ii) throws IOException {
        super(ii.getSessionInfo(), ii.getUserAssignedId(), ii.toString(), JCartIndexBase.getIndexResultTimeout(ii));
        this.ii = ii;
    }

    @Override
    public Long getMemoryUsage() throws Exception {
        return null;
    }

    public static int getIndexResultTimeout(IndexingInfo indexingInfo) {
        return -1;
    }

    protected void endSynch() throws Exception {
        this.dispose();
    }

    public void executeSynch() throws Exception {
        this.ch = RmiTunnelImpl.getConnectionHandler(this.ii);
        try {
            this.dbSession = new ClientSideSession(this.ch.getConnection());
            this.metaData = new JcMetaDataFunctions(this.dbSession);
            this.executePayLoad();
            this.ch.close();
            this.endSynch();
        }
        catch (Throwable throwable) {
            block5: {
                try {
                    this.ch.getConnection().rollback();
                    this.ch.close();
                    this.endSynch();
                }
                catch (SQLException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block5;
                    logger.log(Level.SEVERE, "error", e);
                }
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected JCartIndexDescriptor getIndexDescriptor() throws Exception {
        if (this.idxDesc == null) {
            this.idxDesc = JCartIndexDescriptor.get(this.dbSession, this.ii);
        }
        return this.idxDesc;
    }

    protected abstract void executePayLoad() throws Exception;
}

