/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexBase;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JCartIndexBaseAsync
extends JCartIndexBase {
    private static final Logger logger = Logger.getLogger(JCartIndexBaseAsync.class.getName());
    private int totalwork;
    private boolean ended;
    private Future<Exception> synchFuture;

    protected abstract int calcTotalWork() throws Exception;

    public JCartIndexBaseAsync(IndexingInfo ii) throws IOException {
        super(ii);
    }

    public abstract int getSofar();

    public abstract String getOpName();

    public int getTotalWork() {
        return this.totalwork;
    }

    public synchronized boolean waitForRefresh() throws Exception {
        if (this.ended) {
            this.dispose();
            Exception e = this.synchFuture.get();
            if (e != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(e.getMessage());
                }
                throw e;
            }
            return true;
        }
        this.wait(this.ii.getRefreshPeriod());
        return false;
    }

    @Override
    protected void endSynch() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean executeAsynch() throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Changing longop values: totalwork=" + this.totalwork + ".");
        }
        boolean asynch = JccConfig.getInstance().getBoolean("chemaxon.jchem.cartridge.indexingIsAynch", false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("asynch=" + asynch);
        }
        if (asynch) {
            this.totalwork = this.calcTotalWork();
            this.ended = false;
            this.synchFuture = WorkUnitManager.getInstance().submit(new Callable<Exception>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Exception call() {
                    try {
                        JCartIndexBaseAsync.this.executeSynch();
                        Exception exception = null;
                        return exception;
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        Exception exception = e;
                        return exception;
                    }
                    finally {
                        JCartIndexBaseAsync.this.notifyAllOnComplete();
                    }
                }
            });
            return false;
        }
        try {
            this.executeSynch();
        }
        finally {
            this.dispose();
        }
        return true;
    }

    private synchronized void notifyAllOnComplete() {
        this.ended = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("about to notifyAll()...");
        }
        this.notifyAll();
    }
}

