/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.ColumnDescriptor;
import chemaxon.jchem.cartridge.IndexTableStruct;
import chemaxon.jchem.cartridge.Indexing;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.indexing.CacheIdManagement;
import chemaxon.jchem.cartridge.servlets.indexing.CtColDefList;
import chemaxon.jchem.cartridge.servlets.indexing.operations.ConcurrentIndexBuilder;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexBaseAsync;
import chemaxon.jchem.cartridge.servlets.indexing.operations.MdDescManager;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.CalculateInsertHandler;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.CalculateOnlyHandler;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.ExtFpColumnHandler;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.IndexDataQueueProcessor;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.FetchIndexStats;
import chemaxon.jchem.cartridge.tunnel.index.CreateMolDescInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexCreateInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableStatistics;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.sss.screen.StrucFPConfig;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCartIndexCreate
extends JCartIndexBaseAsync {
    public static final boolean IDXTBL_XTENDS_IDXNAME = true;
    private static final Logger logger = Logger.getLogger(JCartIndexCreate.class.getName());
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private IndexDataQueueProcessor rdqProcessor;
    private AtomicInteger cdIdCounter = new AtomicInteger();
    private boolean beforeRecreation = true;

    public JCartIndexCreate(IndexingInfo ii) throws IOException {
        super(ii);
    }

    @Override
    protected void executePayLoad() throws Exception {
        this.initIndex(this.dbSession, this.ch);
        this.buildIndex(this.ch);
        Indexing.completeIndexTable(this.metaData, (IndexCreateInfo)this.ii);
        if (RmiTunnelImpl.tableTypeStringToInt(this.ii.getTableType()) == 3) {
            MdDescManager.addDefaultMd(new CreateMolDescInfo(JCartIndexDescriptor.get(this.dbSession, this.ii), this.ii.getSessionInfo(), this.ii.getUserAssignedId(), this.ii.getThreadCount(), 1, "MSCR"));
        }
        this.ch.getConnection().commit();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Indexing completed, returning...");
        }
    }

    private String createInitIndexTable(DbSession dbSession) throws Exception {
        int i;
        IndexCreateInfo indexCreateInfo = (IndexCreateInfo)this.ii;
        String idxSchema = this.ii.getIndexSchemaName();
        String idxName = this.ii.getIndexName();
        String idxPartition = this.ii.getIndexPartition();
        String idxTblQName = this.generateIdxTableQName(dbSession, idxSchema, idxName, idxPartition);
        int tableType = RmiTunnelImpl.tableTypeStringToInt(this.ii.getTableType());
        int[] fp_props = indexCreateInfo.getFpProperties();
        int fp_bit = UpdateHandler.FP_DEFAULT_BITS_PER_PATTERN[tableType];
        int pat_length = UpdateHandler.FP_DEFAULT_PATTERN_LENGTH[tableType];
        int fp_size = UpdateHandler.FP_DEFAULT_LENGTH_IN_INTS[tableType];
        if (fp_props != null) {
            fp_size = fp_props[0] / 32;
            if (fp_props[1] != -1) {
                fp_bit = fp_props[1];
            }
            if (fp_props[2] != -1) {
                pat_length = fp_props[2];
            }
        }
        ArrayList structFpConfigList = this.createStructFpConfigList(dbSession, indexCreateInfo.getStructFpConfig());
        int structFpColCount = (int)Math.ceil((double)structFpConfigList.size() / 32.0);
        StrucFPConfig strucFpConfig = new StrucFPConfig();
        strucFpConfig.setMolStrings(structFpConfigList, true);
        String structFpConfigString = strucFpConfig.getConfig();
        int totalFpColCount = fp_size + structFpColCount;
        String idxQName = this.metaData.getIdxQName(idxSchema, idxName, idxPartition);
        this.metaData.setMasterProperty(idxSchema, idxQName + ".JChemProperties", this.ii.getJcpropTableName());
        this.metaData.setMasterProperty(idxSchema, idxQName + ".idxTable", idxTblQName);
        if (indexCreateInfo.getStndzerConfig() != null) {
            this.metaData.setJChemPropertyForIndex(this.ii.getJcpropTableName(), idxTblQName, false, "standardizerConfig", indexCreateInfo.getStndzerConfig());
        }
        StringBuffer stmt_buf = new StringBuffer();
        stmt_buf.append("CREATE TABLE ").append(idxTblQName).append("(cd_id NUMBER(10,0) NOT NULL UNIQUE,");
        stmt_buf.append("rid ROWID NOT NULL UNIQUE,");
        ColumnDescriptor[] colDefs = IndexTableStruct.getMiscColumnDefs(tableType);
        for (i = 0; i < colDefs.length; ++i) {
            ColumnDescriptor columnDescriptor = colDefs[i];
            stmt_buf.append(columnDescriptor.toString()).append(",");
        }
        for (i = 0; i < totalFpColCount; ++i) {
            if (i > 0) {
                stmt_buf.append(",");
            }
            stmt_buf.append("cd_fp" + (i + 1) + " NUMBER(10,0) NOT NULL");
        }
        CtColDefList ctColDefList = new CtColDefList();
        ctColDefList.addDefListStrings(indexCreateInfo.getAutoCalcCtsWcn(), true);
        ctColDefList.addDefListStrings(indexCreateInfo.getAutoCalcCts(), false);
        CtColDefList.CtColDef[] ctColDefArray = ctColDefList.toArray();
        for (int i2 = 0; i2 < ctColDefArray.length; ++i2) {
            CtColDefList.CtColDef ctColDef = ctColDefArray[i2];
            stmt_buf.append(", ").append(ctColDef.getColName()).append(" ").append(ctColDef.getColType());
        }
        stmt_buf.append(", CONSTRAINT ");
        stmt_buf.append(JFunctions.oracleObjectBaseName(idxTblQName));
        stmt_buf.append("_jcp PRIMARY KEY ( cd_id, rid )");
        stmt_buf.append(")");
        if (indexCreateInfo.getTablespaceName() != null) {
            stmt_buf.append(" TABLESPACE ").append(indexCreateInfo.getTablespaceName());
        }
        if (indexCreateInfo.getStorageClose() != null) {
            stmt_buf.append(" STORAGE (").append(indexCreateInfo.getStorageClose() + ")");
        }
        this.metaData.execDDLStatement(stmt_buf.toString());
        if (ctColDefList != null) {
            JCartIndexCreate.setCtColumns(dbSession, this.ii.getJcpropTableName(), idxTblQName, ctColDefList);
        }
        boolean dupfilt = this.ii.isDuplicateFiltering();
        boolean tautDupfilt = this.ii.isTautomerDuplicateFiltering();
        boolean uniqueLikeDupfilt = this.ii.isUniqueLikeDuplicateFiltering();
        boolean switchOffAllProtectionsTdf = this.ii.isSwitchOffAllProtectionsTdf();
        String[][] initProperties = new String[][]{{"creationTime", sdf.format(new Date())}, {"updateCounter", "1"}, {"version", "" + VersionInfo.JCHEM_TABLE_VERSION}, {"ctVersion", "" + VersionInfo.JCHEM_TABLE_VERSION}, {"mdVersion", "" + VersionInfo.JCHEM_TABLE_VERSION}, {"absoluteStereo", String.valueOf(indexCreateInfo.isAbsoluteStereo())}, {"fingerprint.numberOfBits", "" + fp_size * 32}, {"fingerprint.numberOfOnes", "" + fp_bit}, {"fingerprint.numberOfEdges", "" + pat_length}, {"fingerprint.numberOfStrucFPCols", "" + structFpColCount}, {"fingerprint.structuralKeys", structFpConfigString}, {"haltOnBadFormat", this.ii.getErrorHandlingMode()}, {"tableType", String.valueOf(tableType)}, {"idxSubType", String.valueOf(this.ii.getIndexSubType())}, {"JChemVersion", VersionInfo.JCHEM_VERSION}, {"duplicateFiltering", String.valueOf(dupfilt)}, {"tautomerDuplicateFiltering", String.valueOf(tautDupfilt)}, {"switchOffAllProtections", String.valueOf(switchOffAllProtectionsTdf)}, {"exclusiveDuplicateFiltering", String.valueOf(uniqueLikeDupfilt)}};
        for (int ix = 0; ix < initProperties.length; ++ix) {
            this.metaData.setJChemPropertyForIndex(this.ii.getJcpropTableName(), idxTblQName, false, initProperties[ix][0], initProperties[ix][1]);
        }
        ConnectionHandler ch = new ConnectionHandler();
        ch.setPropertyTable(this.ii.getJcpropTableName());
        ch.setConnection(dbSession.getConnection());
        DatabaseProperties dbProp = new DatabaseProperties(ch, true);
        TableInfo.resetTableValidityTimestamp(dbProp, idxTblQName.toUpperCase());
        this.createUpdateLogTable(idxTblQName, indexCreateInfo.getTablespaceName());
        Indexing.createUpdateLogSequence(this.metaData, idxTblQName);
        ch.getConnection().commit();
        return idxTblQName;
    }

    private String generateIdxTableQName(DbSession dbSession, String idxSchema, String idxName, String idxPartition) throws Exception {
        int indexNo = -1;
        String idxTblQName = idxSchema + "." + idxName;
        if (idxPartition != null) {
            idxTblQName = idxTblQName + "_" + idxPartition;
        }
        idxTblQName = idxTblQName + "_JCX";
        return idxTblQName;
    }

    private String initIndex(DbSession dbSession, ConnectionHandler ch) throws Exception {
        Connection conn = ch.getConnection();
        conn.setAutoCommit(false);
        if (!this.metaData.tableExists(this.ii.getJcpropTableName())) {
            DatabaseProperties.createPropertyTable(ch);
        }
        CacheIdManagement cim = new CacheIdManagement();
        cim.registerCacheIdsForJcb(ch, dbSession.getJccOwner(), this.ii.getJcpropTableName());
        String idxTblQName = this.createInitIndexTable(dbSession);
        conn.commit();
        this.ii.setIndexTableQName(idxTblQName);
        return idxTblQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildIndex(ConnectionHandler ch) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BEGIN");
        }
        JCartConnectionManager.setSqlTrace(ch.getConnection(), true);
        try {
            this.buildIndexConcurrently(ch);
            this.recreateSequence();
        }
        finally {
            JCartConnectionManager.setSqlTrace(ch.getConnection(), false);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    private void buildIndexConcurrently(ConnectionHandler ch) throws Exception {
        ConcurrentIndexBuilder ciBuilder = new ConcurrentIndexBuilder(this.ii.getSessionInfo().getUserName(), this.ii.getThreadCount()){

            @Override
            protected StructHandler createStructIndexer() throws Exception {
                StructHandler structHandler = null;
                structHandler = JCartIndexCreate.this.ii.getIndexSubType() == 1 ? new ExtFpColumnHandler(JCartIndexCreate.this.ii, JCartIndexCreate.this.cdIdCounter) : (JCartIndexCreate.this.rdqProcessor.getIndexDataQueue() == null ? new CalculateInsertHandler(JCartIndexCreate.this.ii, JCartIndexCreate.this.cdIdCounter) : new CalculateOnlyHandler(JCartIndexCreate.this.ii, JCartIndexCreate.this.rdqProcessor.getIndexDataQueue()));
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Returning " + structHandler.getClass().getName());
                }
                return structHandler;
            }
        };
        this.rdqProcessor = new IndexDataQueueProcessor(this.ii, this.cdIdCounter);
        ciBuilder.build(ch, this.getSqlForStructures(), this.rdqProcessor.getIndexDataQueue() == null ? null : this.rdqProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList createStructFpConfigList(DbSession dbSession, String structFpConfig) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (structFpConfig == null || structFpConfig.length() == 0) {
            return list;
        }
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = dbSession.prepareStatement(structFpConfig);
        try {
            rset = ps.executeQuery();
            ResultSetMetaData metaData = rset.getMetaData();
            String errMsg = "Bad structural fingerprint configuration statement: ";
            if (metaData.getColumnCount() != 1) {
                errMsg = errMsg + " must return exactly one column -- containing a structure";
                throw new IllegalArgumentException(errMsg);
            }
            while (rset.next()) {
                byte[] bytes = JFunctions.readBytes(rset, 1);
                if (bytes == null) {
                    errMsg = errMsg + "structure should be of dataype char, varchar,varchar2, lob or long and should not be NULL";
                    throw new IllegalArgumentException(errMsg);
                }
                list.add(new String(bytes));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            dbSession.close(rset, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIndexStatistics(FetchIndexStats statsRequest) throws Exception {
        TableStatistics tblStats = new TableStatistics(!statsRequest.isJchemTable());
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(statsRequest);
        try {
            String tableName = statsRequest.getIndexTableQName();
            String string = tblStats.getPrintableStats(ch, tableName);
            return string;
        }
        finally {
            ch.close();
        }
    }

    protected void recreateSequence() throws Exception {
        this.beforeRecreation = false;
        this.metaData.execDDLStatement("CREATE SEQUENCE " + this.ii.getIndexTableQName() + "_SQ INCREMENT BY 1 START WITH " + this.cdIdCounter.incrementAndGet());
    }

    static void setCtColumns(DbSession dbSession, String jcptName, String idxTblQName, CtColDefList ctColDefList) throws SQLException {
        idxTblQName = idxTblQName.toUpperCase();
        ConnectionHandler conh = new ConnectionHandler();
        conh.setPropertyTable(jcptName);
        conh.setConnection(dbSession.getConnection());
        DatabaseProperties dbProperties = new DatabaseProperties(conh, true);
        CtColDefList.CtColDef[] ctColDefArray = ctColDefList.toArray();
        for (int i = 0; i < ctColDefArray.length; ++i) {
            CtColDefList.CtColDef ctColDef = ctColDefArray[i];
            String columnName = ctColDef.getColName();
            String expression = ctColDef.getExpression();
            dbProperties.setChemTermForColumn(idxTblQName, columnName, expression);
        }
        TableInfo.resetTableValidityTimestamp(dbProperties, idxTblQName);
    }

    protected String getSqlForStructures() {
        String sql = "SELECT rowid, " + this.ii.getIndexedColumn() + " FROM " + this.ii.getBaseSchemaName() + "." + this.ii.getBaseTableName();
        String tablePartition = this.ii.getTablePartition();
        if (tablePartition != null) {
            sql = sql + " PARTITION (" + tablePartition + ")";
        }
        return sql;
    }

    protected void createUpdateLogTable(String idxTableQName, String tablespaceName) throws Exception {
        String sql = "CREATE TABLE " + Indexing.generateUpdateLogTableName(idxTableQName) + " (update_id number(10) primary key, update_info varchar2(" + 120 + "), " + "cache_id" + " varchar2(" + 32 + "))";
        if (tablespaceName != null) {
            sql = sql + " TABLESPACE " + tablespaceName;
        }
        this.metaData.execDDLStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int calcTotalWork() throws Exception {
        int totalwork = 0;
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(this.ii);
        try {
            this.dbSession = new ClientSideSession(ch.getConnection());
            String sql = "select count(1) from " + this.ii.getBaseSchemaName() + "." + this.ii.getBaseTableName();
            PreparedStatement psTotalwork = this.dbSession.getConnection().prepareStatement(sql);
            ResultSet rsTotalwork = null;
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(sql);
                }
                rsTotalwork = psTotalwork.executeQuery();
                rsTotalwork.next();
                totalwork = rsTotalwork.getInt(1);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Totalwork result: " + totalwork);
                }
                rsTotalwork.close();
            }
            finally {
                this.dbSession.close(rsTotalwork, psTotalwork);
            }
        }
        finally {
            ch.close();
        }
        return totalwork;
    }

    @Override
    public int getSofar() {
        if (this.beforeRecreation) {
            return this.cdIdCounter.get();
        }
        return this.cdIdCounter.get() - 1;
    }

    @Override
    public String getOpName() {
        return "Creating index " + this.ii.getIndexName();
    }

    protected int getCdIdCounter() {
        return this.cdIdCounter.get();
    }
}

