/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.structhandlers;

import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.rmi.DuplicateStructureException;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalculateInsertHandler
implements StructHandler {
    private static Logger logger = Logger.getLogger(CalculateInsertHandler.class.getName());
    protected IndexingInfo ii;
    protected ConnectionHandler ch;
    protected UpdateHandler uh;
    protected String rowid;
    protected byte[] structure;
    protected long commitInterval;
    protected AtomicInteger cdIdCounter;

    public CalculateInsertHandler(IndexingInfo ii, AtomicInteger cdIdCounter2) throws Exception {
        this.ii = ii;
        this.cdIdCounter = cdIdCounter2;
        this.commitInterval = JccConfig.getInstance().getLong("idx.commit.interval", 1000L);
    }

    protected void setUpUpdateHandler() throws Exception {
        try {
            this.ch = RmiTunnelImpl.getConnectionHandler(this.ii);
            int uhMode = 2;
            if (this.cdIdCounter == null) {
                uhMode = 1;
            }
            this.uh = new UpdateHandler(this.ch, uhMode, this.ii.getIndexTableQName(), "", this.ii.getBaseSchemaName() + "." + this.ii.getBaseTableName(), this.ii.getIndexedColumn());
            this.uh.setEmptyStructuresAllowed(true);
            this.uh.setIgnoreChemicalTermsExceptions(this.ii.isSkipAutoCalcCt());
            this.uh.setLoggingEnabled(false);
            JCartConnectionManager.setSqlTrace(this.ch.getConnection(), true);
        }
        catch (Exception e) {
            ConnectionHandler tmp = this.ch;
            this.ch = null;
            if (tmp != null) {
                tmp.close();
            }
            throw e;
        }
    }

    @Override
    public boolean index(String rowid, byte[] structure) throws Exception {
        this.rowid = rowid;
        this.structure = structure;
        if (this.uh == null) {
            this.setUpUpdateHandler();
        }
        try {
            this.prepare();
        }
        catch (MolFormatException molFormatException) {
            return !CalculateInsertHandler.handleException(rowid, structure, molFormatException, this.ii.getErrorHandlingMode());
        }
        try {
            this.execute();
            this.commitMayBe();
            return true;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "error ", e);
            }
            return !CalculateInsertHandler.handleException(rowid, structure, e, this.ii.getErrorHandlingMode());
        }
    }

    protected void commitMayBe() throws SQLException {
        int cdId = this.cdIdCounter.get();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("commitInterval=" + this.commitInterval + ", cdId=" + cdId);
        }
        if (this.commitInterval > 0L && (long)cdId % this.commitInterval == 0L) {
            this.ch.getConnection().commit();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finer("Committed");
            }
        }
    }

    protected void prepare() throws Exception {
        if (this.cdIdCounter != null) {
            this.uh.setID(this.cdIdCounter.incrementAndGet());
        }
        this.uh.setROWID(this.rowid);
        this.uh.setStructure(this.structure);
    }

    protected static boolean handleException(String rowid, byte[] structure, Exception exception, String haltOnFailure) throws Exception {
        String message = "Error while processing ROWID=" + rowid + ": " + (exception.getMessage() == null ? "" : exception.getMessage()) + ", " + (structure == null ? "<null>" : new String(structure));
        if (haltOnFailure.equals("true")) {
            if (exception instanceof MolFormatException) {
                throw new StructureFormatException(exception);
            }
            if (exception instanceof DuplicateStructureException) {
                throw new DuplicateStructureException(message);
            }
            throw new Exception(message);
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(message);
        }
        return haltOnFailure.equals("false");
    }

    protected void execute() throws SQLException, InterruptedException {
        int maxRetries = 5;
        int retryCount = 0;
        while (true) {
            try {
                this.uh.execute();
                if (!logger.isLoggable(Level.FINEST)) break;
                logger.finest("Structure executed: " + (this.structure == null ? "<null>" : new String(this.structure)));
            }
            catch (SQLException sqlException) {
                if (sqlException.getErrorCode() == 604 && (sqlException.getMessage().indexOf("ORA-00942") != -1 || sqlException.getNextException() != null && sqlException.getNextException().getErrorCode() == 942)) {
                    if (++retryCount > 5) {
                        throw sqlException;
                    }
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, retryCount + "th attempt to recover with cdIdCounter=" + this.cdIdCounter.get() + " after " + sqlException.getMessage(), sqlException);
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                throw sqlException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean commit) throws SQLException {
        if (this.ch == null) {
            return;
        }
        try {
            this.uh.close();
        }
        finally {
            try {
                if (commit) {
                    this.ch.getConnection().commit();
                } else {
                    this.ch.getConnection().rollback();
                }
            }
            finally {
                try {
                    JCartConnectionManager.setSqlTrace(this.ch.getConnection(), false);
                }
                finally {
                    if (this.ch != null) {
                        this.ch.close();
                        this.ch = null;
                    }
                }
            }
        }
    }
}

